/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

final class ExpandCollapseModification {
    private List<ArchitecturalViewNode> m_add;
    private int m_atIndex = -1;
    private Set<Integer> m_remove;
    private Set<Integer> m_update;

    ExpandCollapseModification() {
    }

    void update(int index) {
        assert (index >= 0) : "'index' must not be negative in 'update'";
        if (this.m_update == null) {
            this.m_update = new TreeSet<Integer>();
        }
        boolean success = this.m_update.add(index);
        assert (success) : "Already updated: " + index;
    }

    private void update(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= toIndex) : "Illegal index range: " + fromIndex + " - " + toIndex;
        int i = fromIndex;
        while (i < toIndex + 1) {
            this.update(i);
            ++i;
        }
    }

    void add(List<ArchitecturalViewNode> add, int atIndex) {
        assert (this.m_add == null) : "'m_add' of method 'add' must be null";
        assert (this.m_remove == null) : "'m_remove' of method 'add' must be null";
        assert (add != null && !add.isEmpty()) : "Parameter 'add' of method 'add' must not be empty";
        assert (atIndex >= 0) : "'atIndex' must not be negative";
        assert (add.size() == 1 || new HashSet<ArchitecturalViewNode>(add).size() == add.size()) : "Contains duplicates: " + String.valueOf(add);
        this.m_add = add;
        this.m_atIndex = atIndex;
        this.update(atIndex, atIndex + add.size() - 1);
    }

    void remove(int fromIndex, int toIndex) {
        assert (this.m_add == null) : "'m_add' of method 'remove' must be null";
        assert (this.m_remove == null) : "'m_remove' of method 'remove' must be null";
        assert (fromIndex >= 0 && fromIndex <= toIndex) : "Illegal index range: " + fromIndex + " - " + toIndex;
        if (this.m_remove == null) {
            this.m_remove = new TreeSet<Integer>();
        }
        int i = fromIndex;
        while (i < toIndex + 1) {
            this.m_remove.add(i);
            ++i;
        }
    }

    List<ArchitecturalViewNode> add() {
        return this.m_add != null ? Collections.unmodifiableList(this.m_add) : Collections.emptyList();
    }

    int addAtIndex() {
        return this.m_atIndex;
    }

    Collection<Integer> remove() {
        return this.m_remove != null ? Collections.unmodifiableSet(this.m_remove) : Collections.emptySet();
    }

    Collection<Integer> update() {
        return this.m_update != null ? Collections.unmodifiableSet(this.m_update) : Collections.emptySet();
    }

    boolean isEmpty() {
        return this.m_add == null && this.m_remove == null && this.m_update == null;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<empty>";
        }
        StringBuilder builder = new StringBuilder();
        if (this.m_add != null) {
            builder.append("Add ").append(this.m_add.size()).append(" node(s) at index: ").append(this.m_atIndex);
            int i = 1;
            for (ArchitecturalViewNode next : this.m_add) {
                builder.append("\n");
                builder.append("  (").append(i).append(") ").append(next.getName());
                ++i;
            }
        }
        if (this.m_remove != null) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("Remove node(s): ").append(this.m_remove);
        }
        if (this.m_update != null) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("Update node(s): ").append(this.m_update);
        }
        return builder.toString();
    }
}

