/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.CollapseToArtifactsCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ExpandCollapseData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IExpandCollapseInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExpandCollapseRequest;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewHandler;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public final class CollapseToArtifactsHandler
extends ArchitecturalViewHandler {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.EXPLORATION_VIEW_COLLAPSE_TO_ARTIFACTS;
    }

    public final IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> currentSelection) {
                return CollapseToArtifactsHandler.this.mayBeExecuted(workbenchView, currentSelection);
            }

            public String getLabel(IWorkbenchView workbenchView, List<Element> currentSelection, String defaultLabel) {
                if (!$assertionsDisabled && currentSelection == null) {
                    throw new AssertionError((Object)"Parameter 'currentSelection' of method 'getLabel' must not be null");
                }
                return "Collapse To 'Artifacts'";
            }

            public IMenuGroup getMenuGroup() {
                return ArchitecturalViewMenuGroup.OTHER;
            }
        };
    }

    @CanExecute
    public final boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        if (this.mayBeExecuted(selection)) {
            ExplorationViewRepresentation representation = (ExplorationViewRepresentation)CollapseToArtifactsHandler.getSingleSelection(ExplorationViewRepresentation.class, (List)selection.getElements(), (boolean)false);
            List nodes = CollapseToArtifactsHandler.getMultipleSelection(ArchitecturalViewNode.class, (List)selection.getElements());
            List dependencies = CollapseToArtifactsHandler.getMultipleSelection(ArchitecturalViewNode.ArchitecturalViewDependency.class, (List)selection.getElements());
            return ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).isCollapseToArtifactsPossible(representation, nodes, dependencies, true) != null;
        }
        return false;
    }

    @Execute
    public final void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        assert (WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) : "Not software system available";
        IArchitecturalViewProvider provider = (IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class);
        ExplorationViewRepresentation selectedRepresentation = (ExplorationViewRepresentation)CollapseToArtifactsHandler.getSingleSelection(ExplorationViewRepresentation.class, (List)selection.getElements(), (boolean)false);
        List selectedNodes = CollapseToArtifactsHandler.getMultipleSelection(ArchitecturalViewNode.class, (List)selection.getElements());
        List selectedDependencies = CollapseToArtifactsHandler.getMultipleSelection(ArchitecturalViewNode.ArchitecturalViewDependency.class, (List)selection.getElements());
        final ExpandCollapseRequest request = provider.isCollapseToArtifactsPossible(selectedRepresentation, selectedNodes, selectedDependencies, false);
        assert (request != null) : "'request' of method 'execute' must not be null";
        CollapseToArtifactsCommand command = new CollapseToArtifactsCommand(WorkbenchRegistry.getInstance().getProvider(), new IExpandCollapseInteraction(){

            public boolean collect(ExpandCollapseData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setRequest(request);
                return true;
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)command);
    }
}

