/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewRepresentationData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.CollapseAllCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewHandler;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public final class CollapseAllHandler
extends ArchitecturalViewHandler {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.EXPLORATION_VIEW_COLLAPSE_ALL;
    }

    public final IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> currentSelection) {
                return CollapseAllHandler.this.mayBeExecuted(workbenchView, currentSelection);
            }

            public IMenuGroup getMenuGroup() {
                return ArchitecturalViewMenuGroup.OTHER;
            }
        };
    }

    @CanExecute
    public final boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        if (this.mayBeExecuted(selection)) {
            ExplorationViewRepresentation selectedRepresentation = (ExplorationViewRepresentation)CollapseAllHandler.getSingleSelection(ExplorationViewRepresentation.class, (List)selection.getElements(), (boolean)false);
            List selectedNodes = CollapseAllHandler.getMultipleSelection(ArchitecturalViewNode.class, (List)selection.getElements());
            List selectedDependencies = CollapseAllHandler.getMultipleSelection(ArchitecturalViewNode.ArchitecturalViewDependency.class, (List)selection.getElements());
            return ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).isCollapseAllPossible(selectedRepresentation, selectedNodes, selectedDependencies) != null;
        }
        return false;
    }

    @Execute
    public final void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        assert (WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) : "Not software system available";
        ExplorationViewRepresentation selectedRepresentation = (ExplorationViewRepresentation)CollapseAllHandler.getSingleSelection(ExplorationViewRepresentation.class, (List)selection.getElements(), (boolean)false);
        List selectedNodes = CollapseAllHandler.getMultipleSelection(ArchitecturalViewNode.class, (List)selection.getElements());
        List selectedDependencies = CollapseAllHandler.getMultipleSelection(ArchitecturalViewNode.ArchitecturalViewDependency.class, (List)selection.getElements());
        final ExplorationViewRepresentation representation = ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).isCollapseAllPossible(selectedRepresentation, selectedNodes, selectedDependencies);
        assert (representation != null) : "Parameter 'representation' of method 'execute' must not be null";
        CollapseAllCommand command = new CollapseAllCommand(WorkbenchRegistry.getInstance().getProvider(), new CollapseAllCommand.ICollapseAllInteraction(){

            public boolean collect(ArchitecturalViewRepresentationData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setRepresentation(representation);
                return true;
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)command);
    }
}

