/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFinding;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalNonLazyListView;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewOperationBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExplorationView;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

public final class ArchitecturalOperationsView
extends ArchitecturalNonLazyListView {
    private PropertyTableViewer<ArchitecturalViewOperation> m_operationsViewer;

    public IViewId getViewId() {
        return ViewId.ARCHITECTURAL_OPERATIONS_VIEW;
    }

    @Override
    protected void createViewer(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewer' must not be null";
        this.m_operationsViewer = new PropertyTableViewer(viewContentArea, (BeanPropertyReader.BeanAdapter)new ArchitecturalViewOperationBeanAdapter(), "sortIndex", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_operationsViewer.addColumn("Index", "index", "sortIndex", "indexImage", 5, PropertyTableViewer.ColumnType.NUMBER);
        this.m_operationsViewer.addColumn("Operation", "operation", "operation", "operationImage", 23, PropertyTableViewer.ColumnType.TEXT);
        this.m_operationsViewer.addColumn("Information", "information", "information", null, 54, PropertyTableViewer.ColumnType.TEXT);
        this.m_operationsViewer.addColumn("Inherited From", "inheritedFrom", "inheritedFrom", "inheritedFromImage", 18, PropertyTableViewer.ColumnType.TEXT);
    }

    @Override
    protected PropertyTableViewer<? extends Element> getViewer() {
        return this.m_operationsViewer;
    }

    @Override
    protected void clear() {
        this.m_operationsViewer.showData(null);
        super.clear();
    }

    @Override
    protected void show(ArchitecturalViewFile file) {
        NavigationState state;
        assert (file != null) : "Parameter 'file' of method 'show' must not be null";
        List operations = file.getOperations();
        this.m_operationsViewer.showData((Collection)operations);
        if (!operations.isEmpty() && WorkbenchRegistry.getInstance().getCurrentlySelectedView() == this && (state = ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.getViewId(), this.getSecondaryId())) != null) {
            WorkbenchRegistry.getInstance().selectView((IWorkbenchView)this);
            this.getSelectionProviderAdapter().handleSelectionChanged((IStructuredSelection)this.restoreNavigationState(state));
        }
    }

    public void showInView(IContext context, List<Element> elements, List<IStandardEnumeration> options, boolean secondaryIdReused) {
        ArchitecturalViewFinding finding;
        ArchitecturalViewFile file;
        Element element;
        assert (elements != null) : "Parameter 'elements' of method 'showInView' must not be null";
        if (elements.size() == 1 && (element = elements.get(0)) instanceof ArchitecturalViewFinding && (file = (ArchitecturalViewFile)(finding = (ArchitecturalViewFinding)element).getParent(ArchitecturalViewFile.class, new Class[0])) != null) {
            ArchitecturalViewOperation operation;
            MPart part;
            if (this.getFile() == null && (part = RcpUtility.findPart((IEclipseContext)this.getEclipseContext(), (IViewId)ViewId.EXPLORATION_VIEW, (String)file.getIdentifyingPath())) != null) {
                this.initialize((WorkbenchView)RcpUtility.getWorkbenchView((MPart)part, ExplorationView.class));
            }
            if (this.getFile() == file && (operation = ((IArchitecturalViewProvider)this.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).getCorrespondingOperation(finding)) != null) {
                this.m_operationsViewer.select(Arrays.asList(operation));
            }
        }
    }
}

