/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFinding;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalNonLazyListView;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewFindingBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

public final class ArchitecturalFindingsView
extends ArchitecturalNonLazyListView {
    private PropertyTableViewer<ArchitecturalViewFinding> m_findingsViewer;

    public IViewId getViewId() {
        return ViewId.ARCHITECTURAL_FINDINGS_VIEW;
    }

    @Override
    protected void createViewer(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewer' must not be null";
        this.m_findingsViewer = new PropertyTableViewer(viewContentArea, (BeanPropertyReader.BeanAdapter)new ArchitecturalViewFindingBeanAdapter(), "sortIndex", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_findingsViewer.addColumn("Index", "index", "sortIndex", null, 5, PropertyTableViewer.ColumnType.NUMBER);
        this.m_findingsViewer.addColumn("Name", "name", "name", "image", 30, PropertyTableViewer.ColumnType.TEXT);
        this.m_findingsViewer.addColumn("Description", "description", "description", null, 65, PropertyTableViewer.ColumnType.TEXT);
    }

    @Override
    protected PropertyTableViewer<? extends Element> getViewer() {
        return this.m_findingsViewer;
    }

    @Override
    protected void clear() {
        this.m_findingsViewer.showData(null);
        super.clear();
    }

    @Override
    protected void show(ArchitecturalViewFile file) {
        NavigationState state;
        assert (file != null) : "Parameter 'file' of method 'handleFileSelection' must not be null";
        List findings = file.getFindingList().getFindings();
        this.m_findingsViewer.showData((Collection)findings);
        if (!findings.isEmpty() && WorkbenchRegistry.getInstance().getCurrentlySelectedView() == this && (state = ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.getViewId(), this.getSecondaryId())) != null) {
            WorkbenchRegistry.getInstance().selectView((IWorkbenchView)this);
            this.getSelectionProviderAdapter().handleSelectionChanged((IStructuredSelection)this.restoreNavigationState(state));
        }
    }
}

