/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.MoveComponentFilterPatternsCommand;
import com.hello2morrow.sonargraph.core.command.system.MoveFileFilterPatternsCommand;
import com.hello2morrow.sonargraph.core.command.system.MoveFilterPatternsCommand;
import com.hello2morrow.sonargraph.core.command.system.MoveModulesCommand;
import com.hello2morrow.sonargraph.core.command.system.MoveRootDirectoryPathsCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.filter.ComponentFilter;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.Pattern;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DragSourceAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DropTargetAdapter;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.WorkspaceViewContentProvider;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithTree;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.TreeBasedViewNavigationStateUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DropLocation;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.TreeBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class WorkspaceView
extends WorkbenchSlaveView
implements DropTargetAdapter.IDropTargetActionHandler<NamedElement>,
DragSourceAdapter.IDragActionHandler<NamedElement>,
ISelectionChangedListener,
ITreeViewerListener,
IViewWithTree {
    private static final EnumSet<Modification> IGNORE_MODIFICATIONS = EnumSet.of(Modification.ARCHITECTURE_MODIFIED);
    private TreeViewer m_treeViewer;
    private TreeBasedTextSearchHandler m_textSearchProvider;

    public TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    public IViewId getViewId() {
        return ViewId.WORKSPACE_VIEW;
    }

    protected EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    public List<Control> getControlsForInteraction() {
        return new ArrayList<Control>(Arrays.asList(this.m_treeViewer.getControl()));
    }

    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    protected void createViewContent(Composite viewContentArea) {
        this.m_treeViewer = new TreeViewer(viewContentArea, 66306);
        this.m_treeViewer.getTree().setHeaderVisible(true);
        this.m_textSearchProvider = new TreeBasedTextSearchHandler(this.m_treeViewer, this.getViewId().getPresentationName());
        TreeViewerColumn column1 = new TreeViewerColumn(this.m_treeViewer, 0);
        column1.getColumn().setWidth(240);
        column1.getColumn().setText("Element");
        column1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                if (!$assertionsDisabled && !(obj instanceof NamedElement)) {
                    throw new AssertionError((Object)("Not of class named element: " + String.valueOf(obj)));
                }
                return ((NamedElement)obj).getPresentationName(true);
            }

            public Image getImage(Object obj) {
                if (!$assertionsDisabled && !(obj instanceof NamedElement)) {
                    throw new AssertionError((Object)("Not of class named element: " + String.valueOf(obj)));
                }
                NamedElement element = (NamedElement)obj;
                return UiResourceManager.getInstance().getImage((Element)element);
            }
        });
        TreeViewerColumn column2 = new TreeViewerColumn(this.m_treeViewer, 0);
        column2.getColumn().setWidth(380);
        column2.getColumn().setText("Description");
        column2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                if (!$assertionsDisabled && !(obj instanceof NamedElement)) {
                    throw new AssertionError((Object)("Not of class named element: " + String.valueOf(obj)));
                }
                return ((NamedElement)obj).getDescription();
            }
        });
        TreeViewerColumn column3 = new TreeViewerColumn(this.m_treeViewer, 0);
        column3.getColumn().setWidth(380);
        column3.getColumn().setText("Information");
        column3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                if (!$assertionsDisabled && !(obj instanceof NamedElement)) {
                    throw new AssertionError((Object)("Not of class named element: " + String.valueOf(obj)));
                }
                return ((NamedElement)obj).getInformation();
            }
        });
        this.m_treeViewer.setContentProvider((IContentProvider)new WorkspaceViewContentProvider());
        ArrayList dropClasses = new ArrayList(3);
        dropClasses.add(Module.class);
        dropClasses.add(RootDirectoryPath.class);
        dropClasses.add(Filter.class);
        dropClasses.add(Pattern.class);
        DropTargetAdapter targetAdapter = new DropTargetAdapter((StructuredViewer)this.m_treeViewer, this, dropClasses, false);
        ArrayList dragClasses = new ArrayList(3);
        dragClasses.add(Module.class);
        dragClasses.add(RootDirectoryPath.class);
        dragClasses.add(Pattern.class);
        new DragSourceAdapter<NamedElement>((StructuredViewer)this.m_treeViewer, 2, Collections.singletonList(targetAdapter), dragClasses, this);
        this.m_treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    @Override
    public boolean validateDrag(List<NamedElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'validateDrag' must not be empty";
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        if (softwareSystem != null && softwareSystem.getMode() != SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT) {
            return this.getElementInteractor().dragAndDropStarted();
        }
        return false;
    }

    @Override
    public void dragFinished() {
        this.getElementInteractor().dragAndDropFinished();
    }

    private void addListeners() {
        this.m_treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_treeViewer.addTreeListener((ITreeViewerListener)this);
    }

    private void removeListeners() {
        this.m_treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_treeViewer.removeTreeListener((ITreeViewerListener)this);
    }

    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.removeListeners();
        this.m_treeViewer.getTree().setRedraw(false);
        this.m_treeViewer.setInput(this.getSoftwareSystem().getUniqueExistingChild(Workspace.class));
        if (mode == WorkbenchView.ShowMode.AWAKE) {
            this.restoreNavigationState();
        }
        this.m_treeViewer.getTree().setRedraw(true);
        this.addListeners();
        super.softwareSystemShow(mode);
    }

    private void restoreNavigationState() {
        NavigationState state = ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.getViewId(), this.getSecondaryId());
        if (state != null) {
            TreeBasedViewNavigationStateUtility.restoreViewState((TreeViewer)this.m_treeViewer, (NavigationState)state, (IElementResolver)this.getElementResolver());
        }
    }

    protected void softwareSystemModified(EnumSet<Modification> modifications, boolean restoredFromHistory) {
        boolean setNewInput;
        assert (modifications != null) : "Parameter 'modifications' of method 'softwareSystemModified' must not be null";
        Object currentInput = this.m_treeViewer.getInput();
        assert (currentInput != null && currentInput instanceof Workspace) : "Unexpected class in method 'softwareSystemModified': " + String.valueOf(currentInput);
        boolean bl = setNewInput = !((Workspace)currentInput).isValid();
        if (setNewInput || !this.ignoreModification(modifications, IGNORE_MODIFICATIONS)) {
            this.removeListeners();
            this.m_treeViewer.getControl().setRedraw(false);
            if (setNewInput) {
                this.m_treeViewer.setInput(this.getSoftwareSystem().getUniqueExistingChild(Workspace.class));
            } else {
                this.m_treeViewer.refresh();
            }
            this.restoreNavigationState();
            this.m_treeViewer.getControl().setRedraw(true);
            this.addListeners();
        }
        this.m_textSearchProvider.requestNewFindInfo();
        super.softwareSystemModified(modifications, restoredFromHistory);
    }

    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.ISSUE_MODIFIED)) {
            this.removeListeners();
            this.m_treeViewer.getControl().setRedraw(false);
            this.m_treeViewer.refresh();
            this.m_treeViewer.getControl().setRedraw(true);
            this.addListeners();
        }
        super.analyzerModification(modification, analyzerId);
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.removeListeners();
        this.m_treeViewer.setInput(null);
        this.m_treeViewer.setSelection((ISelection)new StructuredSelection());
        this.addListeners();
    }

    @Override
    public boolean perform(NamedElement target, DropLocation location, List<NamedElement> dropped, StructuredViewer viewer) {
        assert (target != null) : "Parameter 'target' of method 'perform' must not be null";
        assert (location != null) : "Parameter 'location' of method 'perform' must not be null";
        assert (dropped != null && !dropped.isEmpty()) : "Parameter 'dropped' of method 'perform' must not be empty";
        assert (viewer != null) : "Parameter 'viewer' of method 'perform' must not be null";
        ArrayList<Module> droppedModules = new ArrayList<Module>();
        ArrayList<RootDirectoryPath> droppedRootDirectoryPaths = new ArrayList<RootDirectoryPath>();
        ArrayList<Pattern> droppedPatterns = new ArrayList<Pattern>();
        for (NamedElement nextDropped : dropped) {
            if (nextDropped instanceof Module) {
                droppedModules.add((Module)nextDropped);
                continue;
            }
            if (nextDropped instanceof RootDirectoryPath) {
                droppedRootDirectoryPaths.add((RootDirectoryPath)nextDropped);
                continue;
            }
            if (nextDropped instanceof Pattern) {
                droppedPatterns.add((Pattern)nextDropped);
                continue;
            }
            assert (false) : "Unexpected class: " + nextDropped.getClass().getName();
        }
        int numberOfTypesToBeDropped = 0;
        if (!droppedModules.isEmpty()) {
            ++numberOfTypesToBeDropped;
        }
        if (!droppedRootDirectoryPaths.isEmpty()) {
            ++numberOfTypesToBeDropped;
        }
        if (!droppedPatterns.isEmpty()) {
            ++numberOfTypesToBeDropped;
        }
        if (numberOfTypesToBeDropped != 1) {
            return false;
        }
        if (target instanceof Module) {
            if (!droppedModules.isEmpty() || !droppedRootDirectoryPaths.isEmpty()) {
                return this.processDroppedOnModule((Module)target, location, droppedModules, droppedRootDirectoryPaths);
            }
        } else if (target instanceof RootDirectoryPath) {
            if (!droppedRootDirectoryPaths.isEmpty()) {
                return this.processDroppedOnRootDirectoryPath((RootDirectoryPath)target, location, droppedRootDirectoryPaths);
            }
        } else if (target instanceof Pattern || target instanceof Filter) {
            if (!droppedPatterns.isEmpty()) {
                return this.processDroppedPatterns(target, location, droppedPatterns);
            }
        } else assert (false) : "Unhandled target: " + target.getClass().getName();
        return false;
    }

    private boolean processDroppedOnModule(final Module target, DropLocation location, final List<Module> droppedModules, final List<RootDirectoryPath> droppedRootDirectoryPaths) {
        assert (target != null) : "Parameter 'target' of method 'processDroppedOnModule' must not be null";
        assert (location != null) : "Parameter 'location' of method 'processDroppedOnModule' must not be null";
        assert (droppedModules.isEmpty() || droppedRootDirectoryPaths.isEmpty());
        assert (droppedRootDirectoryPaths.isEmpty() || droppedModules.isEmpty());
        if (!droppedModules.isEmpty()) {
            if (!SonargraphCommand.isAvailable((ICommandId)CoreCommandId.MOVE_MODULES, (SoftwareSystem)this.getSoftwareSystem())) {
                return false;
            }
            NamedElement parentOfTarget = target.getParent();
            assert (parentOfTarget != null) : "'parentOfTarget' of method 'perform' must not be null";
            final int targetPosition = DropTargetAdapter.convertToPosition(location, parentOfTarget.getIndexOf(Module.class, (NamedElement)target), parentOfTarget.getNumberOfChildren());
            MoveModulesCommand cmd = new MoveModulesCommand(WorkbenchRegistry.getInstance().getProvider(), new MoveModulesCommand.IMoveModulesInteraction(){

                public void processMoveModulesResult(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processMoveModulesResult' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                }

                public boolean collectMoveModulesData(MoveModulesCommand.MoveModulesData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collectMoveModulesData' must not be null");
                    }
                    data.set(droppedModules, targetPosition);
                    return true;
                }
            });
            UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)cmd);
            return true;
        }
        for (RootDirectoryPath next : droppedRootDirectoryPaths) {
            if (next.getParent() != target) continue;
            return false;
        }
        if (!SonargraphCommand.isAvailable((ICommandId)CoreCommandId.MOVE_ROOT_DIRECTORY_PATHS, (SoftwareSystem)this.getSoftwareSystem())) {
            return false;
        }
        MoveRootDirectoryPathsCommand cmd = new MoveRootDirectoryPathsCommand(WorkbenchRegistry.getInstance().getProvider(), new MoveRootDirectoryPathsCommand.IMoveRootDirectoryPathsInteraction(){

            public void processMoveRootDirectoryPathsResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processMoveRootDirectoryPathsResult' must not be null");
                }
                UserInterfaceAdapter.getInstance().process(result);
            }

            public boolean collectMoveRootDirectoryPathsData(MoveRootDirectoryPathsCommand.MoveRootDirectoryPathsData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collectMoveRootDirectoryPathsData' must not be null");
                }
                data.set(droppedRootDirectoryPaths, target, target.getNumberOfChildren());
                return true;
            }
        });
        UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)cmd);
        return true;
    }

    private boolean processDroppedOnRootDirectoryPath(final RootDirectoryPath target, DropLocation location, final List<RootDirectoryPath> droppedRootDirectoryPaths) {
        if (!SonargraphCommand.isAvailable((ICommandId)CoreCommandId.MOVE_ROOT_DIRECTORY_PATHS, (SoftwareSystem)this.getSoftwareSystem())) {
            return false;
        }
        NamedElement parentOfTarget = target.getParent();
        if (!(parentOfTarget instanceof Module)) {
            return false;
        }
        final int targetPosition = DropTargetAdapter.convertToPosition(location, parentOfTarget.getIndexOf(RootDirectoryPath.class, (NamedElement)target), parentOfTarget.getNumberOfChildren());
        MoveRootDirectoryPathsCommand cmd = new MoveRootDirectoryPathsCommand(WorkbenchRegistry.getInstance().getProvider(), new MoveRootDirectoryPathsCommand.IMoveRootDirectoryPathsInteraction(){

            public void processMoveRootDirectoryPathsResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processMoveRootDirectoryPathsResult' must not be null");
                }
                UserInterfaceAdapter.getInstance().process(result);
            }

            public boolean collectMoveRootDirectoryPathsData(MoveRootDirectoryPathsCommand.MoveRootDirectoryPathsData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collectMoveRootDirectoryPathsData' must not be null");
                }
                data.set(droppedRootDirectoryPaths, (Module)target.getParent(), targetPosition);
                return true;
            }
        });
        UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)cmd);
        return true;
    }

    private boolean processDroppedPatterns(NamedElement target, DropLocation location, final List<Pattern> droppedPatterns) {
        int targetPosition;
        assert (target != null) : "Parameter 'target' of method 'processDroppedPatterns' must not be null";
        assert (target instanceof Filter || target instanceof Pattern) : "Unexpected class: " + target.getClass().getName();
        assert (droppedPatterns != null && !droppedPatterns.isEmpty()) : "Parameter 'droppedPatterns' of method 'processDroppedPatterns' must not be empty";
        SoftwareSystem system = this.getSoftwareSystem();
        if (system == null) {
            return false;
        }
        IWorkspaceProvider workspaceProvider = (IWorkspaceProvider)system.getExtension(IWorkspaceProvider.class);
        StrictPair targetFilterAndSize = workspaceProvider.isMovePatternPossible((Element)target, droppedPatterns);
        if (targetFilterAndSize == null) {
            return false;
        }
        final Filter targetFilter = (Filter)targetFilterAndSize.getFirst();
        int numberOfPatterns = (Integer)targetFilterAndSize.getSecond();
        int n = targetPosition = target instanceof Filter || targetFilter.getIndexOf(Pattern.class, target) == numberOfPatterns ? -1 : DropTargetAdapter.convertToPosition(location, targetFilter.getIndexOf(Pattern.class, target), numberOfPatterns);
        if (targetFilter instanceof WorkspaceFilter && SonargraphCommand.isAvailable((ICommandId)CoreCommandId.MOVE_FILE_FILTER_PATTERNS, (SoftwareSystem)system)) {
            MoveFileFilterPatternsCommand cmd = new MoveFileFilterPatternsCommand(WorkbenchRegistry.getInstance().getProvider(), new MoveFilterPatternsCommand.IInteraction(){

                public boolean collect(MoveFilterPatternsCommand.Data data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.setData(droppedPatterns, targetFilter, targetPosition);
                    return true;
                }

                public void processMoveResult(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processMoveResult' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                }
            });
            UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)cmd);
            return true;
        }
        if (targetFilter instanceof ComponentFilter && SonargraphCommand.isAvailable((ICommandId)CoreCommandId.MOVE_COMPONENT_FILTER_PATTERNS, (SoftwareSystem)system)) {
            MoveComponentFilterPatternsCommand cmd = new MoveComponentFilterPatternsCommand(WorkbenchRegistry.getInstance().getProvider(), new MoveFilterPatternsCommand.IInteraction(){

                public boolean collect(MoveFilterPatternsCommand.Data data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.setData(droppedPatterns, targetFilter, targetPosition);
                    return true;
                }

                public void processMoveResult(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processMoveResult' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                }
            });
            UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)cmd);
            return true;
        }
        return false;
    }

    public List<Element> getSelectedElements() {
        return SelectionProviderAdapter.getElementsFromSelection((IStructuredSelection)this.m_treeViewer.getStructuredSelection());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        TreeBasedViewNavigationStateUtility.createViewState((NavigationState)state, (IElementResolver)this.getSoftwareSystemProvider().getElementResolver(), (TreeViewer)this.m_treeViewer);
        ViewNavigationManager.getInstance().addNavigationState(state);
        IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
        this.getSelectionProviderAdapter().handleSelectionChanged(structuredSelection);
    }

    public void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        this.m_treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'finishShowInView' must not be empty";
        this.m_treeViewer.setSelection((ISelection)new StructuredSelection(elements));
        WorkbenchRegistry.getInstance().selectView((IWorkbenchView)this);
        super.finishShowInView(sourceViewId, elements, options);
    }

    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        assert (this.m_treeViewer != null) : "'m_treeViewer' of method 'restoreNavigationState' must not be null";
        this.removeListeners();
        this.m_treeViewer.getTree().setRedraw(false);
        TreeBasedViewNavigationStateUtility.restoreViewState((TreeViewer)this.m_treeViewer, (NavigationState)state, (IElementResolver)this.getElementResolver());
        this.m_treeViewer.getTree().setRedraw(true);
        this.addListeners();
    }

    public final void collapseAll() {
        assert (this.m_treeViewer != null) : "'m_treeViewer' of method 'collapseAll' must not be null";
        this.m_treeViewer.collapseAll();
        this.treeCollapsed(null);
    }

    public final void expandAll() {
        assert (this.m_treeViewer != null) : "'m_treeViewer' of method 'expandAll' must not be null";
        this.m_treeViewer.expandToLevel(2);
        this.treeExpanded(null);
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        assert (this.m_treeViewer != null) : "'m_treeViewer' of method 'treeCollapsed' must not be null";
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_COLLAPSED);
        TreeBasedViewNavigationStateUtility.createViewState((NavigationState)state, (IElementResolver)this.getSoftwareSystemProvider().getElementResolver(), (TreeViewer)this.m_treeViewer, (TreeExpansionEvent)event, (TreeBasedViewNavigationStateUtility.TreeOperation)TreeBasedViewNavigationStateUtility.TreeOperation.COLLAPSE);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    public void treeExpanded(TreeExpansionEvent event) {
        assert (this.m_treeViewer != null) : "'m_treeViewer' of method 'treeExpanded' must not be null";
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_EXPANDED);
        TreeBasedViewNavigationStateUtility.createViewState((NavigationState)state, (IElementResolver)this.getSoftwareSystemProvider().getElementResolver(), (TreeViewer)this.m_treeViewer, (TreeExpansionEvent)event, (TreeBasedViewNavigationStateUtility.TreeOperation)TreeBasedViewNavigationStateUtility.TreeOperation.EXPAND);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    public void completeViewNavigationState(NavigationState state) {
        TreeBasedViewNavigationStateUtility.createViewState((NavigationState)state, (IElementResolver)this.getSoftwareSystemProvider().getElementResolver(), (TreeViewer)this.m_treeViewer);
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchProvider;
    }
}

