/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceprofile;

import com.hello2morrow.sonargraph.core.command.system.CreateWorkspaceProfileCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.PatternType;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.core.model.system.FilterModification;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DragSourceAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DropTargetAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.workspaceprofile.WorkspaceProfilePatternWizard;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DropLocation;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class WorkspaceProfileFilterWizardPage
extends StandardWizardPage
implements SelectionListener,
DropTargetAdapter.IDropTargetActionHandler<NamedElement>,
ISelectionChangedListener {
    private final FilterModification m_filterModification;
    private final List<WildcardPattern> m_existingWorkspaceFilters;
    private PropertyTableViewer<WildcardPattern> m_workspaceFilterTable;
    private PropertyTableViewer<WildcardPattern> m_profileFilterTable;
    private Button m_overrideWorkspaceFilter;
    private Button m_addInclude;
    private Button m_addExclude;
    private Button m_edit;
    private Button m_delete;
    private Button m_up;
    private Button m_down;
    private ITextValidator m_patternValidator;

    WorkspaceProfileFilterWizardPage(String title, FilterModification filterModification) {
        super(CoreDialogId.CREATE_WORKSPACE_PROFILE_FILTER.getStandardName(), title);
        assert (filterModification != null) : "Parameter 'filterModification' of method 'WorkspaceProfileFilterWizardPage' must not be null";
        this.m_filterModification = filterModification;
        ProductionCodeFilter workspaceFilter = ((Workspace)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getProductionCodeFilter();
        this.m_existingWorkspaceFilters = workspaceFilter.getChildren(WildcardPattern.class);
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.CREATE_WORKSPACE_PROFILE_FILTER;
    }

    protected void createContent(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'createContent' must not be null";
        this.m_overrideWorkspaceFilter = new Button(composite, 32);
        this.m_overrideWorkspaceFilter.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_overrideWorkspaceFilter.setText("Override workspace filter");
        this.m_overrideWorkspaceFilter.addSelectionListener((SelectionListener)this);
        SashForm sashForm = new SashForm(composite, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite left = new Composite((Composite)sashForm, 0);
        left.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithoutMargin((int)2));
        left.setLayoutData((Object)new GridData(4, 4, true, true));
        WildcardBeanAdapter beanAdapter = new WildcardBeanAdapter();
        this.m_workspaceFilterTable = new PropertyTableViewer(left, (BeanPropertyReader.BeanAdapter)beanAdapter, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_workspaceFilterTable.addColumn("Workspace Filter", "pattern", "pattern", "image", 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_workspaceFilterTable.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite right = new Composite((Composite)sashForm, 0);
        right.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithoutMargin((int)2));
        this.m_profileFilterTable = new PropertyTableViewer(right, (BeanPropertyReader.BeanAdapter)beanAdapter, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_profileFilterTable.addColumn("Profile Filter", "pattern", "pattern", "image", 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_profileFilterTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_profileFilterTable.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        Composite buttonRow = new Composite(right, 0);
        buttonRow.setLayoutData((Object)new GridData(1, 4, false, true));
        buttonRow.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1));
        this.m_addInclude = new Button(buttonRow, 8);
        this.m_addInclude.setImage(UiResourceManager.getInstance().getImage("NewWorkspaceIncludePattern"));
        this.m_addInclude.addSelectionListener((SelectionListener)this);
        this.m_addExclude = new Button(buttonRow, 8);
        this.m_addExclude.setImage(UiResourceManager.getInstance().getImage("NewWorkspaceExcludePattern"));
        this.m_addExclude.addSelectionListener((SelectionListener)this);
        this.m_edit = new Button(buttonRow, 8);
        this.m_edit.setImage(UiResourceManager.getInstance().getImage("Edit"));
        this.m_edit.addSelectionListener((SelectionListener)this);
        this.m_delete = new Button(buttonRow, 8);
        this.m_delete.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_delete.addSelectionListener((SelectionListener)this);
        this.m_up = new Button(buttonRow, 8);
        this.m_up.setImage(UiResourceManager.getInstance().getImage("ArrowUp"));
        this.m_up.addSelectionListener((SelectionListener)this);
        this.m_down = new Button(buttonRow, 8);
        this.m_down.setImage(UiResourceManager.getInstance().getImage("ArrowDown"));
        this.m_down.addSelectionListener((SelectionListener)this);
        this.m_patternValidator = CreateWorkspaceProfileCommand.getWorkspaceFilterValidator((ISoftwareSystemProvider)WorkbenchRegistry.getInstance().getProvider(), (ProductionCodeFilter)this.m_filterModification.getFilter());
        DropTargetAdapter targetAdapter = new DropTargetAdapter((StructuredViewer)this.m_profileFilterTable.getTableViewer(), this, Collections.singletonList(WildcardPattern.class), true);
        new DragSourceAdapter((StructuredViewer)this.m_workspaceFilterTable.getTableViewer(), 2, Collections.singletonList(targetAdapter), Collections.singletonList(WildcardPattern.class));
        this.m_workspaceFilterTable.showData(this.m_existingWorkspaceFilters);
        this.m_profileFilterTable.showData((Collection)this.m_filterModification.getPatterns());
        this.m_overrideWorkspaceFilter.setSelection(this.m_filterModification.overrideWorkspaceFilter());
        this.enableFilterWidgets(this.m_filterModification.overrideWorkspaceFilter());
    }

    private void processModification() {
        this.m_profileFilterTable.showData((Collection)this.m_filterModification.getPatterns());
        this.setPageComplete(this.m_filterModification.isModified());
        this.enableFilterWidgets(this.m_filterModification.overrideWorkspaceFilter());
    }

    @Override
    public boolean perform(NamedElement target, DropLocation location, List<NamedElement> dropped, StructuredViewer viewer) {
        assert (dropped != null && !dropped.isEmpty()) : "Parameter 'dropped' of method 'perform' must not be empty";
        assert (viewer == this.m_profileFilterTable.getTableViewer()) : "Invalid target viewer: " + String.valueOf(viewer);
        ArrayList<WildcardPattern> patterns = new ArrayList<WildcardPattern>(dropped.size());
        for (NamedElement nextDropped : dropped) {
            assert (nextDropped != null && nextDropped instanceof WildcardPattern) : "Unexpected class in method 'perform': " + String.valueOf(nextDropped);
            patterns.add((WildcardPattern)nextDropped);
        }
        List omitted = this.m_filterModification.addPatterns(patterns);
        this.processModification();
        return omitted.size() != patterns.size();
    }

    private void enableFilterWidgets(boolean overrideWorkspaceFilter) {
        int selected;
        boolean enableSelectionBasedInteractions;
        this.m_workspaceFilterTable.setEnabled(overrideWorkspaceFilter);
        this.m_workspaceFilterTable.setEnabled(overrideWorkspaceFilter);
        this.m_addInclude.setEnabled(overrideWorkspaceFilter);
        this.m_addExclude.setEnabled(overrideWorkspaceFilter);
        if (!overrideWorkspaceFilter) {
            enableSelectionBasedInteractions = false;
            selected = 0;
        } else {
            selected = this.m_profileFilterTable.getSelected().size();
            enableSelectionBasedInteractions = selected > 0;
        }
        this.m_edit.setEnabled(enableSelectionBasedInteractions);
        this.m_delete.setEnabled(enableSelectionBasedInteractions);
        if (selected == 1) {
            List patterns = this.m_filterModification.getPatterns();
            int pos = patterns.indexOf(this.m_profileFilterTable.getSelected().get(0));
            this.m_up.setEnabled(pos > 0);
            this.m_down.setEnabled(pos < patterns.size() - 1);
        } else {
            this.m_up.setEnabled(false);
            this.m_down.setEnabled(false);
        }
    }

    public FilterModification getFilterModifiaction() {
        return this.m_filterModification;
    }

    public void widgetSelected(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
        Object source = event.getSource();
        if (source == this.m_overrideWorkspaceFilter) {
            boolean overrideFilter = this.m_overrideWorkspaceFilter.getSelection();
            this.enableFilterWidgets(overrideFilter);
            this.m_filterModification.setOverrideWorkspaceFilter(overrideFilter);
            if (!overrideFilter && this.m_filterModification.getPatterns().size() > 0) {
                UserInterfaceAdapter.getInstance().information("Deletion of Filter Patterns", "The existing profile filter patterns will be cleared when finishing the changes.");
            }
            this.processModification();
            return;
        }
        if (source == this.m_addInclude) {
            WorkspaceProfilePatternWizard newIncludePatternWizard = new WorkspaceProfilePatternWizard(PatternType.INCLUDE, (Filter)this.m_filterModification.getFilter()){

                @Override
                protected ITextValidator getPatternValidator() {
                    return WorkspaceProfileFilterWizardPage.this.m_patternValidator;
                }

                public boolean performFinish() {
                    WorkspaceProfileFilterWizardPage.this.m_filterModification.addPattern((WildcardPattern)new WildcardPatternInclude(null, this.getPattern()));
                    WorkspaceProfileFilterWizardPage.this.processModification();
                    return true;
                }
            };
            SonargraphWizardAdapter.createWizardDialog((Shell)this.getShell(), (SonargraphWizard)newIncludePatternWizard).open();
        } else if (source == this.m_addExclude) {
            WorkspaceProfilePatternWizard newExcludePatternWizard = new WorkspaceProfilePatternWizard(PatternType.EXCLUDE, (Filter)this.m_filterModification.getFilter()){

                @Override
                protected ITextValidator getPatternValidator() {
                    return WorkspaceProfileFilterWizardPage.this.m_patternValidator;
                }

                public boolean performFinish() {
                    WorkspaceProfileFilterWizardPage.this.m_filterModification.addPattern((WildcardPattern)new WildcardPatternExclude(null, this.getPattern()));
                    WorkspaceProfileFilterWizardPage.this.processModification();
                    return true;
                }
            };
            SonargraphWizardAdapter.createWizardDialog((Shell)this.getShell(), (SonargraphWizard)newExcludePatternWizard).open();
        } else if (source == this.m_up) {
            WildcardPattern selected = (WildcardPattern)this.m_profileFilterTable.getSelected().get(0);
            List patterns = this.m_filterModification.getPatterns();
            int pos = patterns.indexOf(selected);
            WildcardPattern replaced = patterns.set(pos - 1, selected);
            patterns.set(pos, replaced);
            this.m_filterModification.setPatterns(patterns);
        } else if (source == this.m_down) {
            WildcardPattern selected = (WildcardPattern)this.m_profileFilterTable.getSelected().get(0);
            List patterns = this.m_filterModification.getPatterns();
            int pos = patterns.indexOf(selected);
            WildcardPattern replaced = patterns.set(pos + 1, selected);
            patterns.set(pos, replaced);
            this.m_filterModification.setPatterns(patterns);
        } else if (source == this.m_delete) {
            List selected = this.m_profileFilterTable.getSelected();
            List currentPatterns = this.m_filterModification.getPatterns();
            currentPatterns.removeAll(selected);
            this.m_filterModification.setPatterns(currentPatterns);
        } else if (source == this.m_edit) {
            WorkspaceProfilePatternWizard editWizard;
            final WildcardPattern selected = (WildcardPattern)this.m_profileFilterTable.getSelected().get(0);
            if (selected instanceof WildcardPatternInclude) {
                editWizard = new WorkspaceProfilePatternWizard(selected){

                    @Override
                    protected ITextValidator getPatternValidator() {
                        return WorkspaceProfileFilterWizardPage.this.m_patternValidator;
                    }

                    public boolean performFinish() {
                        WorkspaceProfileFilterWizardPage.this.updatePattern(selected, (WildcardPattern)new WildcardPatternInclude(null, this.getPattern()));
                        return true;
                    }
                };
            } else if (selected instanceof WildcardPatternExclude) {
                editWizard = new WorkspaceProfilePatternWizard(selected){

                    @Override
                    protected ITextValidator getPatternValidator() {
                        return WorkspaceProfileFilterWizardPage.this.m_patternValidator;
                    }

                    public boolean performFinish() {
                        WorkspaceProfileFilterWizardPage.this.updatePattern(selected, (WildcardPattern)new WildcardPatternExclude(null, this.getPattern()));
                        return true;
                    }
                };
            } else {
                assert (false) : "Unsupported class: " + selected.getClass().getName();
                return;
            }
            SonargraphWizardAdapter.createWizardDialog((Shell)this.getShell(), (SonargraphWizard)editWizard).open();
        } else assert (false) : "Unhandled source: " + String.valueOf(source);
        this.processModification();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        assert (event.getSource() == this.m_profileFilterTable.getTableViewer()) : "Unexpected source: " + String.valueOf(event.getSource());
        this.enableFilterWidgets(this.m_overrideWorkspaceFilter.getSelection());
    }

    private void updatePattern(WildcardPattern selected, WildcardPattern pattern) {
        assert (selected != null) : "Parameter 'selected' of method 'updatePattern' must not be null";
        assert (pattern != null) : "Parameter 'pattern' of method 'updatePattern' must not be null";
        List patterns = this.m_filterModification.getPatterns();
        int pos = patterns.indexOf(selected);
        patterns.set(pos, pattern);
        this.m_filterModification.setPatterns(patterns);
        this.processModification();
    }

    public class WildcardBeanAdapter
    extends BeanPropertyReader.BeanAdapter<WildcardPattern> {
        private WildcardPattern m_pattern;

        protected void setAdaptedObject(WildcardPattern adaptedObject) {
            this.m_pattern = adaptedObject;
        }

        public String getPattern() {
            return this.m_pattern.getName();
        }

        public Image getImage() {
            return UiResourceManager.getInstance().getImage(this.m_pattern.getImageResourceName());
        }
    }
}

