/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizards;

import com.hello2morrow.sonargraph.core.model.resolution.PatternBasedCycleIgnoreFilterData;
import com.hello2morrow.sonargraph.ui.standalone.wizards.ICycleGroupKindProvider;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

class PatternWizardPage
extends StandardWizardPage {
    private ICycleGroupKindProvider m_cycleGroupKindProvider;
    private Label m_kindLabel;
    private TableViewer m_includePatternTableViewer;
    private Button m_addIncludePattern;
    private Button m_removeIncludePattern;
    private TableViewer m_excludePatternTableViewer;
    private Button m_addExcludePattern;
    private Button m_removeExcludePattern;
    private List<PatternBasedCycleIgnoreFilterData.Pattern> m_includePatterns;
    private List<PatternBasedCycleIgnoreFilterData.Pattern> m_excludePatterns;

    PatternWizardPage(String pageName, ICycleGroupKindProvider cycleGroupKindProvider, List<PatternBasedCycleIgnoreFilterData.Pattern> includes, List<PatternBasedCycleIgnoreFilterData.Pattern> excludes) {
        super(pageName, "Ignore Patterns");
        assert (includes != null);
        assert (excludes != null);
        this.m_cycleGroupKindProvider = cycleGroupKindProvider;
        this.m_includePatterns = includes;
        this.m_excludePatterns = excludes;
    }

    protected void createContent(Composite composite) {
        this.m_kindLabel = new Label(composite, 0);
        this.m_kindLabel.setText("Ignore filter for: ");
        this.m_kindLabel.setLayoutData((Object)new GridData(1, 2, false, false, 3, 1));
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        Label explanation1 = new Label(composite, 0);
        explanation1.setText("A cycle group will be ignored when its members match all mandatory patterns. If there are no mandatory");
        explanation1.setLayoutData((Object)new GridData(1, 2, false, false, 3, 1));
        Label explanation2 = new Label(composite, 0);
        explanation2.setText("patterns it will match if any non-mandatory patterns are matching.");
        explanation2.setLayoutData((Object)new GridData(1, 2, false, false, 3, 1));
        Label explanationHelp = new Label(composite, 0);
        explanationHelp.setText("'**' matches anything, '*' matches anything except '/', '?' matches single letter.");
        explanationHelp.setLayoutData((Object)new GridData(1, 2, false, false, 3, 1));
        this.m_addIncludePattern = new Button(composite, 8);
        this.m_addIncludePattern.setText("Add Include Pattern");
        this.m_addIncludePattern.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.m_addIncludePattern.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PatternWizardPage.this.addIncludePattern();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PatternWizardPage.this.addIncludePattern();
            }
        });
        this.m_removeIncludePattern = new Button(composite, 8);
        this.m_removeIncludePattern.setText("Remove Include Pattern");
        this.m_removeIncludePattern.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.m_removeIncludePattern.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PatternWizardPage.this.removeIncludePattern();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PatternWizardPage.this.removeIncludePattern();
            }
        });
        this.m_includePatternTableViewer = new TableViewer(composite, 67584);
        Table includePatternTable = this.m_includePatternTableViewer.getTable();
        includePatternTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        includePatternTable.setHeaderVisible(true);
        includePatternTable.setLinesVisible(true);
        this.m_includePatternTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn includePatternColumn = new TableViewerColumn(this.m_includePatternTableViewer, 0);
        includePatternColumn.getColumn().setText("Include Patterns");
        includePatternColumn.getColumn().setWidth(400);
        includePatternColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                PatternBasedCycleIgnoreFilterData.Pattern pattern = (PatternBasedCycleIgnoreFilterData.Pattern)element;
                return pattern.getPattern();
            }
        });
        includePatternColumn.setEditingSupport((EditingSupport)new TextColumnEditingSupport(this.m_includePatternTableViewer));
        TableViewerColumn checkColumn = new TableViewerColumn(this.m_includePatternTableViewer, 0);
        checkColumn.getColumn().setText("Mandatory");
        checkColumn.getColumn().setWidth(100);
        checkColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                PatternBasedCycleIgnoreFilterData.Pattern pattern = (PatternBasedCycleIgnoreFilterData.Pattern)element;
                Image result = pattern.isMandatory() ? UiResourceManager.getInstance().getImage("CheckBoxChecked") : UiResourceManager.getInstance().getImage("CheckBoxUnchecked");
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError();
                }
                return result;
            }
        });
        checkColumn.setEditingSupport((EditingSupport)new CheckboxColumnEditingSupport(this.m_includePatternTableViewer));
        this.m_includePatternTableViewer.setInput(this.m_includePatterns);
        this.m_includePatternTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PatternWizardPage.this.updateState();
            }
        });
        Label explanation3 = new Label(composite, 0);
        explanation3.setText("A cycle group will not match the ignore filter if any exclude pattern matches.");
        explanation3.setLayoutData((Object)new GridData(1, 2, false, false, 3, 1));
        this.m_addExcludePattern = new Button(composite, 8);
        this.m_addExcludePattern.setText("Add Exclude Pattern");
        this.m_addExcludePattern.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.m_addExcludePattern.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PatternWizardPage.this.addExcludePattern();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PatternWizardPage.this.addExcludePattern();
            }
        });
        this.m_removeExcludePattern = new Button(composite, 8);
        this.m_removeExcludePattern.setText("Remove Exclude Pattern");
        this.m_removeExcludePattern.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.m_removeExcludePattern.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PatternWizardPage.this.removeExcludePattern();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PatternWizardPage.this.removeExcludePattern();
            }
        });
        this.m_excludePatternTableViewer = new TableViewer(composite, 67584);
        Table excludePatternTable = this.m_excludePatternTableViewer.getTable();
        excludePatternTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        excludePatternTable.setHeaderVisible(true);
        excludePatternTable.setLinesVisible(true);
        this.m_excludePatternTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn excludePatternColumn = new TableViewerColumn(this.m_excludePatternTableViewer, 0);
        excludePatternColumn.getColumn().setText("Exclude Patterns");
        excludePatternColumn.getColumn().setWidth(400);
        excludePatternColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                PatternBasedCycleIgnoreFilterData.Pattern pattern = (PatternBasedCycleIgnoreFilterData.Pattern)element;
                return pattern.getPattern();
            }
        });
        excludePatternColumn.setEditingSupport((EditingSupport)new TextColumnEditingSupport(this.m_excludePatternTableViewer));
        this.m_excludePatternTableViewer.setInput(this.m_excludePatterns);
        this.m_excludePatternTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PatternWizardPage.this.updateState();
            }
        });
        this.updateState();
    }

    private void addIncludePattern() {
        PatternBasedCycleIgnoreFilterData.Pattern pattern = new PatternBasedCycleIgnoreFilterData.Pattern(false, "Enter include pattern...");
        this.m_includePatterns.add(pattern);
        this.m_includePatternTableViewer.setInput(this.m_includePatterns);
        this.m_includePatternTableViewer.editElement((Object)pattern, 0);
        this.updateState();
    }

    private void removeIncludePattern() {
        IStructuredSelection selection = this.m_includePatternTableViewer.getStructuredSelection();
        assert (selection.size() == 1);
        this.m_includePatterns.remove(selection.getFirstElement());
        this.m_includePatternTableViewer.setInput(this.m_includePatterns);
        this.updateState();
    }

    private void addExcludePattern() {
        PatternBasedCycleIgnoreFilterData.Pattern pattern = new PatternBasedCycleIgnoreFilterData.Pattern(false, "Enter exclude pattern...");
        this.m_excludePatterns.add(pattern);
        this.m_excludePatternTableViewer.setInput(this.m_excludePatterns);
        this.m_excludePatternTableViewer.editElement((Object)pattern, 0);
        this.updateState();
    }

    private void removeExcludePattern() {
        IStructuredSelection selection = this.m_excludePatternTableViewer.getStructuredSelection();
        assert (selection.size() == 1);
        this.m_excludePatterns.remove(selection.getFirstElement());
        this.m_excludePatternTableViewer.setInput(this.m_excludePatterns);
        this.updateState();
    }

    private void updateState() {
        this.m_removeIncludePattern.setEnabled(!this.m_includePatternTableViewer.getStructuredSelection().isEmpty());
        this.m_removeExcludePattern.setEnabled(!this.m_excludePatternTableViewer.getStructuredSelection().isEmpty());
        this.setPageComplete(!this.m_includePatterns.isEmpty());
    }

    protected int getNumberOfColumns() {
        return 3;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.m_kindLabel.setText("Ignore filter for: " + this.m_cycleGroupKindProvider.getCycleGroupKind().getPresentationName() + " based on architecture filter names");
            this.updateState();
        }
        super.setVisible(visible);
    }

    public List<PatternBasedCycleIgnoreFilterData.Pattern> getIncludePatterns() {
        return this.m_includePatterns;
    }

    public List<PatternBasedCycleIgnoreFilterData.Pattern> getExcludePatterns() {
        return this.m_excludePatterns;
    }

    private final class CheckboxColumnEditingSupport
    extends EditingSupport {
        CellEditor m_editor;

        public CheckboxColumnEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.m_editor = new CheckboxCellEditor((Composite)viewer.getTable());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.m_editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((PatternBasedCycleIgnoreFilterData.Pattern)element).isMandatory();
        }

        protected void setValue(Object element, Object value) {
            assert (value instanceof Boolean);
            PatternBasedCycleIgnoreFilterData.Pattern pattern = (PatternBasedCycleIgnoreFilterData.Pattern)element;
            ((PatternBasedCycleIgnoreFilterData.Pattern)element).setMandatory(!pattern.isMandatory());
            this.getViewer().update(element, null);
        }
    }

    private final class TextColumnEditingSupport
    extends EditingSupport {
        private final CellEditor m_editor;

        public TextColumnEditingSupport(TableViewer tableViewer) {
            super((ColumnViewer)tableViewer);
            this.m_editor = new TextCellEditor((Composite)tableViewer.getTable());
            this.m_editor.setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    if (value instanceof String) {
                        String val = (String)value;
                        if (val.isBlank()) {
                            return "Value cannot be blank or empty";
                        }
                        return null;
                    }
                    return "Unexpected cell entry";
                }
            });
        }

        protected CellEditor getCellEditor(Object element) {
            return this.m_editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            if (element instanceof PatternBasedCycleIgnoreFilterData.Pattern) {
                return ((PatternBasedCycleIgnoreFilterData.Pattern)element).getPattern();
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof PatternBasedCycleIgnoreFilterData.Pattern) {
                ((PatternBasedCycleIgnoreFilterData.Pattern)element).setPattern((String)value);
                this.getViewer().update(element, null);
            }
        }
    }
}

