/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.update;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicense;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.system.INotificationProvider;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionCheck;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.foundation.utilities.URLUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.CloseCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.update.UpdateExecutionDialog;
import com.hello2morrow.sonargraph.ui.standalone.update.UpdateInfoDialog;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpdateSupport {
    public static final String DEFAULT_UPDATE_SITE_URL = "https://eclipse.hello2morrow.com/Sonargraph.site";
    public static final int DEFAULT_UPDATE_SITE_PORT = 443;
    private static final String UPDATE_SUPPORT_KEY = "UpdateSupport";
    private static final String UPDATE_SITE_URL_KEY = "updateSiteUrl";
    private static final String UPDATE_SITE_PORT_KEY = "updateSitePort";
    private static final String LAST_VERSION_KEY = "lastVersion";
    private static final String LAST_LICENSETYPE_FEATURES_LANGUAGES_KEY = "lastLicenseTypeFeaturesLanguages";
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateSupport.class);

    private UpdateSupport() {
    }

    public static StrictPair<String, Integer> getUpdateSiteUrlAndPort() {
        IEclipsePreferences preferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone", (String)UPDATE_SUPPORT_KEY);
        String updateSiteUrl = preferences.get(UPDATE_SITE_URL_KEY, DEFAULT_UPDATE_SITE_URL);
        int updateSitePort = preferences.getInt(UPDATE_SITE_PORT_KEY, 443);
        return new StrictPair((Object)updateSiteUrl, (Object)updateSitePort);
    }

    public static void saveUpdateSiteUrlAndPort(StrictPair<String, Integer> updateSiteUrlAndPort) {
        assert (updateSiteUrlAndPort != null) : "Parameter 'updateSiteUrlAndPort' of method 'saveUpdateSiteUrlAndPort' must not be null";
        IEclipsePreferences preferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone", (String)UPDATE_SUPPORT_KEY);
        preferences.put(UPDATE_SITE_URL_KEY, (String)updateSiteUrlAndPort.getFirst());
        preferences.putInt(UPDATE_SITE_PORT_KEY, ((Integer)updateSiteUrlAndPort.getSecond()).intValue());
        PreferencesUtility.save((IEclipsePreferences)preferences);
    }

    private static URL getUpdateSiteURL() {
        StrictPair<String, Integer> updateSiteUrlAndPort = UpdateSupport.getUpdateSiteUrlAndPort();
        try {
            return URLUtility.toURL((String)((String)updateSiteUrlAndPort.getFirst()), (int)((Integer)updateSiteUrlAndPort.getSecond()));
        }
        catch (MalformedURLException e) {
            assert (false) : "Update site info '" + String.valueOf(updateSiteUrlAndPort) + "' of method 'getUpdateSiteURL' must be valid: " + String.valueOf(e);
            return null;
        }
    }

    private static void setProxyState(ProxySettings proxySettings) {
        BundleContext bundleContext = FrameworkUtil.getBundle(UpdateSupport.class).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IProxyService.class);
        if (serviceReference == null) {
            LOGGER.warn("Could not get service reference to IProxyService, proxies will not work");
            return;
        }
        IProxyService proxyService = (IProxyService)bundleContext.getService(serviceReference);
        if (proxyService == null) {
            LOGGER.warn("Could not get IProxyService, proxies will not work");
            return;
        }
        if (proxySettings == null) {
            LOGGER.info("No proxy used for P2 operations");
            if (proxyService.isProxiesEnabled()) {
                proxyService.setProxiesEnabled(false);
            }
            bundleContext.ungetService(serviceReference);
            return;
        }
        IProxyData[] proxyData = proxyService.getProxyData();
        boolean success = false;
        IProxyData[] iProxyDataArray = proxyData;
        int n = proxyData.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData data = iProxyDataArray[n2];
            if ("HTTP".equals(data.getType()) || "HTTPS".equals(data.getType())) {
                data.setHost(proxySettings.getHost());
                data.setPort(proxySettings.getPort());
                LOGGER.info("Proxy for P2 operations ({}) successfully set to {}:{}", new Object[]{data.getType(), proxySettings.getHost(), proxySettings.getPort()});
                if (proxySettings.hasCredentials()) {
                    data.setUserid(proxySettings.getUserName());
                    data.setPassword(proxySettings.getPassword());
                } else {
                    data.setUserid(null);
                    data.setPassword(null);
                }
                success = true;
            } else {
                data.setHost(null);
                data.setPort(-1);
                data.setUserid(null);
                data.setPassword(null);
            }
            ++n2;
        }
        if (!success) {
            LOGGER.warn("There is no fitting IProxyData, proxies will not work");
            return;
        }
        proxyService.setSystemProxiesEnabled(false);
        proxyService.setProxiesEnabled(true);
        try {
            proxyService.setProxyData(proxyData);
        }
        catch (CoreException ex) {
            LOGGER.warn("Unable to set Proxy Data, proxies will not work", (Throwable)ex);
            return;
        }
        bundleContext.ungetService(serviceReference);
    }

    private static SonargraphInfo getAvailableSonargraphInfo(ProxySettings proxySettings) {
        String urlAsString;
        URL updateSiteUrl;
        SonargraphInfo info;
        block17: {
            SonargraphLicenseHandler licenseHandler = CommandRegistry.getInstance().getLicenseHandler();
            info = new SonargraphInfo(licenseHandler.getProductVersion(), licenseHandler.getLicense().getSupportExpirationDate());
            updateSiteUrl = UpdateSupport.getUpdateSiteURL();
            try {
                URL propertiesFileURL = URLUtility.appendPath((URL)updateSiteUrl, (String)"Sonargraph.properties");
                LOGGER.debug("Using properties file url: " + String.valueOf(propertiesFileURL));
                urlAsString = propertiesFileURL.toExternalForm();
                String propertiesFileContent = HttpConnectionCheck.getContent((String)urlAsString, (ProxySettings)proxySettings);
                if (propertiesFileContent == null || propertiesFileContent.isEmpty()) {
                    info.addErrorMessage("Unable to retrieve available Sonargraph properties: " + urlAsString);
                    break block17;
                }
                Properties sonargrapProperties = new Properties();
                try {
                    sonargrapProperties.load(new StringReader(propertiesFileContent));
                    String versionAsString = sonargrapProperties.getProperty("Version");
                    if (versionAsString == null || versionAsString.isEmpty()) {
                        info.addErrorMessage("Unable to retrieve available Sonargraph version.");
                    } else {
                        Version version = Version.create((String)versionAsString, (boolean)true);
                        if (version == null) {
                            info.addErrorMessage("Unable to parse available Sonargraph version: " + versionAsString);
                        } else {
                            info.setAvailableVersion(version);
                        }
                    }
                    String buildDateAsString = sonargrapProperties.getProperty("BuildDate");
                    if (buildDateAsString == null) {
                        info.addErrorMessage("Unable to retrieve available Sonargraph build date.");
                        break block17;
                    }
                    Date buildDate = Iso8601DateFormat.parseDate((String)buildDateAsString);
                    if (buildDate == null) {
                        info.addErrorMessage("Unable to parse available Sonargraph build date: " + buildDateAsString);
                        break block17;
                    }
                    info.setBuildDateOfAvailableVersion(buildDate);
                }
                catch (IOException e) {
                    info.addErrorMessage("Unable to read available Sonargraph properties: " + urlAsString);
                }
            }
            catch (MalformedURLException e) {
                assert (false) : "'updateInfoFileURL' of method 'getAvailableSonargraphInfo' must be valid: " + e.getLocalizedMessage();
                return null;
            }
        }
        try {
            URL updateInfoFileURL = URLUtility.appendPath((URL)updateSiteUrl, (String)"updateinfo.txt");
            LOGGER.debug("Using update info file url: " + String.valueOf(updateInfoFileURL));
            urlAsString = updateInfoFileURL.toExternalForm();
            String updateInfo = HttpConnectionCheck.getContent((String)urlAsString, (ProxySettings)proxySettings);
            if (updateInfo == null) {
                info.addErrorMessage("Unable to retrieve available update info file: " + urlAsString);
            } else {
                info.setUpdateInfo(updateInfo);
            }
        }
        catch (MalformedURLException e) {
            assert (false) : "'updateInfoFileURL' of method 'getUpdateInfoFileUrl' must be valid: " + String.valueOf(e);
            return null;
        }
        return info;
    }

    private static boolean performUpdate(final SonargraphInfo info, IStatus status, boolean onStartup) {
        boolean p2NothingToUpdate;
        assert (info != null) : "Parameter 'info' of method 'performUpdate' must not be null";
        assert (status != null) : "Parameter 'status' of method 'performUpdate' must not be null";
        final Version installedVersion = info.getInstalledVersion();
        final Version availableVersion = info.getAvailableVersion();
        Date supportExpirationDate = info.getSupportExpirationDate();
        Date buildDate = info.getBuildDateOfAvailableVersion();
        boolean bl = p2NothingToUpdate = status.getCode() == 10000;
        if (p2NothingToUpdate) {
            LOGGER.info("P2 update operation status is 'Nothing to update'.");
        }
        LOGGER.info("Sonargraph installed: " + installedVersion.toString() + " [support expiration date:" + Iso8601DateFormat.formatDate((Date)supportExpirationDate) + "]");
        LOGGER.info("Sonargraph available on update site: " + availableVersion.toString() + " [build date:" + Iso8601DateFormat.formatDate((Date)buildDate) + "]");
        if (p2NothingToUpdate || !availableVersion.isAfter(installedVersion)) {
            String msg = "Sonargraph is up to date.";
            if (onStartup) {
                ((INotificationProvider)WorkbenchRegistry.getInstance().getProvider().getInstallation().getExtension(INotificationProvider.class)).add("Sonargraph is up to date.", Severity.INFO, false);
            } else {
                UserInterfaceAdapter.getInstance().information("You already have the latest Sonargraph version: " + installedVersion.toString() + "!", null);
            }
            LOGGER.info("Sonargraph is up to date.");
            return false;
        }
        if (buildDate.after(supportExpirationDate)) {
            if (onStartup) {
                String msg = "There is a new version of Sonargraph available, but license is out of support.";
                LOGGER.info("There is a new version of Sonargraph available, but license is out of support.");
                ((INotificationProvider)WorkbenchRegistry.getInstance().getProvider().getInstallation().getExtension(INotificationProvider.class)).add("There is a new version of Sonargraph available, but license is out of support.", Severity.INFO, false);
            } else {
                UserInterfaceAdapter.getInstance().information("Support expired on '" + Iso8601DateFormat.formatDate((Date)supportExpirationDate) + "'.\nUpdate not covered by license.", null);
            }
            return false;
        }
        RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

            public void run() {
                UpdateInfoDialog updateInfoDialog = new UpdateInfoDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), installedVersion, availableVersion, info.getUpdateInfo());
                int install = updateInfoDialog.open();
                if (install == 0) {
                    this.setResult(Boolean.TRUE);
                } else {
                    this.setResult(Boolean.FALSE);
                }
            }
        };
        UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)runnable);
        if (!((Boolean)runnable.getResult()).booleanValue()) {
            LOGGER.info("User skipped the update");
            return false;
        }
        if (!onStartup && WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) {
            boolean update;
            if (UserInterfaceAdapter.getInstance().question("Close system and proceed?", false) == UserInterfaceAdapter.Feedback.CONFIRMED) {
                UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                    @Override
                    public void run() {
                        CloseSoftwareSystemCommand command = new CloseSoftwareSystemCommand(WorkbenchRegistry.getInstance().getProvider(), (CloseSoftwareSystemCommand.ICloseInteraction)new CloseCommandInteraction(true){

                            @Override
                            public boolean closeSoftwareSystem() {
                                return true;
                            }
                        });
                        UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
                    }
                });
            }
            boolean bl2 = update = !WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem();
            if (!update) {
                LOGGER.info("User skipped the update - system was opened");
            }
            return update;
        }
        return true;
    }

    public static void updateCheck(IWorkbench workbench, IProvisioningAgent agent, ProxySettings proxySettings, boolean onStartup) {
        block5: {
            assert (workbench != null) : "Parameter 'workbench' of method 'updateCheck' must not be null";
            assert (agent != null) : "Parameter 'agent' of method 'updateCheck' must not be null";
            try {
                URI uri = UpdateSupport.getUpdateSiteURL().toURI();
                LOGGER.info((onStartup ? "[Startup] " : "[User] ") + "Check for Sonargraph update on update site: " + uri.toString());
                Check check = new Check(uri, agent, proxySettings);
                BusyIndicator.showWhile((Display)WorkbenchRegistry.getInstance().getDisplay(), (Runnable)check);
                SonargraphInfo sonargraphInfo = check.getSonargraphInfo();
                if (sonargraphInfo != null && sonargraphInfo.isSuccess() && UpdateSupport.performUpdate(sonargraphInfo, check.getStatus(), onStartup)) {
                    LOGGER.info((onStartup ? "[Startup] " : "[User] ") + "Check for update - done [open update dialog]");
                    new UpdateExecutionDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), workbench, check.getUpdateOperation()).open();
                    return;
                }
            }
            catch (URISyntaxException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)("'updateSiteUri' of method 'perform' must be valid: " + String.valueOf(e)));
            }
        }
        LOGGER.info((onStartup ? "[Startup] " : "[User] ") + "Check for update - done [no update dialog opened]");
    }

    public static void processPersistedStateOnStartup(Set<String> specifiedLanguages) {
        assert (specifiedLanguages != null) : "Parameter 'specifiedLanguages' of method 'processPersistedStateOnStartup' must not be null";
        SonargraphLicenseHandler licenseHandler = CommandRegistry.getInstance().getLicenseHandler();
        String currentVersionAsString = licenseHandler.getProductVersion().toString();
        ArrayList<String> currentLicenseTypeFeaturesLanguages = new ArrayList<String>();
        currentLicenseTypeFeaturesLanguages.add(licenseHandler.getLicenseType());
        SonargraphLicense license = licenseHandler.getLicense();
        license.getFeatures().forEach(f -> {
            boolean bl = currentLicenseTypeFeaturesLanguages.add(f.getStandardName());
        });
        for (Language nextLanguage : license.getLicensedLanguages()) {
            String name = nextLanguage.getStandardName();
            if (!specifiedLanguages.contains(name.toLowerCase())) continue;
            currentLicenseTypeFeaturesLanguages.add(name);
        }
        String currentLicenseTypeFeaturesLanguagesAsString = StringUtility.concat((Collection)currentLicenseTypeFeaturesLanguages.stream().sorted().collect(Collectors.toList()), (String)", ");
        IEclipsePreferences preferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone", (String)UPDATE_SUPPORT_KEY);
        String lastVersionAsString = preferences.get(LAST_VERSION_KEY, "0.0.0.0");
        String lastLicenseTypeFeaturesLanguagesAsString = preferences.get(LAST_LICENSETYPE_FEATURES_LANGUAGES_KEY, "");
        boolean clearPersistedState = false;
        if (!currentVersionAsString.equals(lastVersionAsString)) {
            LOGGER.debug("New version detected on startup: " + lastVersionAsString + " -> " + currentVersionAsString);
            clearPersistedState = true;
        } else if (!currentLicenseTypeFeaturesLanguagesAsString.equals(lastLicenseTypeFeaturesLanguagesAsString)) {
            LOGGER.debug("New license type/features/languages detected on startup: " + lastLicenseTypeFeaturesLanguagesAsString + " -> " + currentLicenseTypeFeaturesLanguagesAsString);
            clearPersistedState = true;
        }
        if (clearPersistedState) {
            TFile userHomeDir = CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir();
            TFile systemsInUserHomeDir = new TFile((File)userHomeDir, SonargraphProduct.SONARGRAPH.getDirectoryName() + "/systems");
            ArrayList<TFile> analyerResultsDirectories = new ArrayList<TFile>();
            TFile[] files = systemsInUserHomeDir.listFiles();
            if (files != null) {
                TFile[] tFileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    TFile[] nestedFiles;
                    TFile nextFile = tFileArray[n2];
                    if (nextFile.isDirectory() && (nestedFiles = nextFile.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            if (!$assertionsDisabled && dir == null) {
                                throw new AssertionError((Object)"Parameter 'dir' of method 'processPersistedStateOnStartup' must not be null");
                            }
                            if (!$assertionsDisabled && name == null) {
                                throw new AssertionError((Object)"Parameter 'name' of method 'processPersistedStateOnStartup' must not be null");
                            }
                            return "AnalyzerResults".equals(name);
                        }
                    })) != null) {
                        TFile[] tFileArray2 = nestedFiles;
                        int n3 = nestedFiles.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TFile nextAnalyzerResultDirectory = tFileArray2[n4];
                            analyerResultsDirectories.add(nextAnalyzerResultDirectory);
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            if (!analyerResultsDirectories.isEmpty()) {
                LOGGER.info("Clearing persisted analyzer results (delete " + analyerResultsDirectories.size() + " 'AnalyzerResults' directories underneath: " + systemsInUserHomeDir.getNormalizedAbsolutePath() + ")");
                if (LOGGER.isDebugEnabled()) {
                    for (TFile next : analyerResultsDirectories) {
                        LOGGER.debug("Delete:  " + next.getNormalizedAbsolutePath());
                    }
                }
                for (TFile next : analyerResultsDirectories) {
                    try {
                        next.rm_r();
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to delete 'AnalyzerResults' directory: " + String.valueOf(next), (Throwable)e);
                    }
                }
            }
            TFile deleteMe = new TFile((File)RcpUtility.getRcpWorkspaceMetaDataDirectory(), ".plugins/org.eclipse.e4.workbench/workbench.xmi");
            LOGGER.info("Clearing persisted state (delete: " + deleteMe.getAbsolutePath() + ")");
            if (deleteMe.exists()) {
                try {
                    deleteMe.rm();
                }
                catch (IOException e) {
                    LOGGER.error("Could not delete workbench.xmi file:" + deleteMe.getAbsolutePath());
                }
            }
            LOGGER.debug("Save 'lastVersion=" + currentVersionAsString + "'");
            preferences.put(LAST_VERSION_KEY, currentVersionAsString);
            LOGGER.debug("Save 'lastLicenseTypeFeaturesLanguages=" + currentLicenseTypeFeaturesLanguagesAsString + "'");
            preferences.put(LAST_LICENSETYPE_FEATURES_LANGUAGES_KEY, currentLicenseTypeFeaturesLanguagesAsString);
            PreferencesUtility.save((IEclipsePreferences)preferences);
            TrueZipFacade.clear();
        }
    }

    static final class Check
    implements Runnable {
        private final URI m_uri;
        private final IProvisioningAgent m_agent;
        private final ProxySettings m_proxySettings;
        private SonargraphInfo m_sonargraphInfo;
        private UpdateOperation m_updateOperation;
        private IStatus m_status;

        Check(URI uri, IProvisioningAgent agent, ProxySettings proxySettings) {
            assert (uri != null) : "Parameter 'uri' of method 'Check' must not be null";
            assert (agent != null) : "Parameter 'agent' of method 'Check' must not be null";
            this.m_uri = uri;
            this.m_agent = agent;
            this.m_proxySettings = proxySettings;
        }

        @Override
        public void run() {
            this.m_sonargraphInfo = UpdateSupport.getAvailableSonargraphInfo(this.m_proxySettings);
            if (this.m_sonargraphInfo.isSuccess()) {
                UpdateSupport.setProxyState(this.m_proxySettings);
                this.m_updateOperation = new UpdateOperation(new ProvisioningSession(this.m_agent));
                this.m_updateOperation.getProvisioningContext().setArtifactRepositories(new URI[]{this.m_uri});
                this.m_updateOperation.getProvisioningContext().setMetadataRepositories(new URI[]{this.m_uri});
                this.m_status = this.m_updateOperation.resolveModal((IProgressMonitor)new NullProgressMonitor());
            } else {
                LOGGER.warn("Unable to retrieve Sonargraph info: " + this.m_sonargraphInfo.getErrorMessage());
            }
        }

        SonargraphInfo getSonargraphInfo() {
            return this.m_sonargraphInfo;
        }

        UpdateOperation getUpdateOperation() {
            assert (this.m_sonargraphInfo != null && this.m_sonargraphInfo.isSuccess());
            return this.m_updateOperation;
        }

        IStatus getStatus() {
            assert (this.m_sonargraphInfo != null && this.m_sonargraphInfo.isSuccess());
            return this.m_status;
        }
    }

    static final class NullProgressMonitor
    implements IProgressMonitor {
        NullProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }
    }

    static final class SonargraphInfo
    extends Result {
        private final Version m_installedVersion;
        private final Date m_supportExpirationDate;
        private Version m_availableVersion;
        private Date m_buildDateOfAvailableVersion;
        private String m_updateInfo;

        public SonargraphInfo(Version installedVersion, Date supportExpirationDate) {
            assert (installedVersion != null) : "Parameter 'installedVersion' of method 'SonargraphInfo' must not be null";
            assert (supportExpirationDate != null) : "Parameter 'supportExpirationDate' of method 'SonargraphInfo' must not be null";
            this.m_installedVersion = installedVersion;
            this.m_supportExpirationDate = supportExpirationDate;
        }

        Version getInstalledVersion() {
            return this.m_installedVersion;
        }

        Date getSupportExpirationDate() {
            return this.m_supportExpirationDate;
        }

        void setAvailableVersion(Version version) {
            assert (version != null) : "Parameter 'version' of method 'setAvailableVersion' must not be null";
            this.m_availableVersion = version;
        }

        void setBuildDateOfAvailableVersion(Date buildDate) {
            assert (buildDate != null) : "Parameter 'buildDate' of method 'setBuildDateOfAvailableVersion' must not be null";
            this.m_buildDateOfAvailableVersion = buildDate;
        }

        void setUpdateInfo(String updateInfo) {
            assert (updateInfo != null) : "Parameter 'updateInfo' of method 'setUpdateInfo' must not be null";
            this.m_updateInfo = updateInfo;
        }

        Version getAvailableVersion() {
            assert (this.m_availableVersion != null) : "'m_version' of method 'getAvailableVersion' must not be null";
            return this.m_availableVersion;
        }

        Date getBuildDateOfAvailableVersion() {
            assert (this.m_buildDateOfAvailableVersion != null) : "'m_buildDate' of method 'getBuildDateOfAvailableVersion' must not be null";
            return this.m_buildDateOfAvailableVersion;
        }

        String getUpdateInfo() {
            assert (this.m_updateInfo != null) : "'m_updateInfo' of method 'getUpdateInfo' must not be null";
            return this.m_updateInfo;
        }
    }
}

