/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.treemap.CreateTreeMapCommand;
import com.hello2morrow.sonargraph.core.command.system.treemap.EditTreeMapCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.treemap.ITreeMapProvider;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapProperties;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.Collections;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public final class TreeMapWizard
extends NonLazySonargraphWizard {
    private TreeMapWizardPage m_page;
    private final TreeMapProperties m_properties;
    private final TreeMapFile m_file;
    private final TreeMapWizardPage.Mode m_mode;

    public TreeMapWizard(TreeMapProperties properties) {
        super(TreeMapWizardPage.Mode.CREATE.getTitle());
        assert (properties != null) : "Parameter 'properties' of method 'TreeMapWizard' must not be null";
        this.m_mode = TreeMapWizardPage.Mode.CREATE;
        this.m_properties = properties;
        this.m_file = null;
    }

    public TreeMapWizard(TreeMapFile file) {
        super(TreeMapWizardPage.Mode.EDIT.getTitle());
        assert (file != null) : "Parameter 'file' of method 'TreeMapWizard' must not be null";
        this.m_mode = TreeMapWizardPage.Mode.EDIT;
        this.m_file = file;
        this.m_properties = new TreeMapProperties(file.getTreeMapProperties());
    }

    public int getPreferredHeight() {
        return 500;
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        SoftwareSystem softwareSystem = provider.getSoftwareSystem();
        this.m_page = new TreeMapWizardPage(((ITreeMapProvider)softwareSystem.getExtension(ITreeMapProvider.class)).getNameValidator(this.m_file), this.m_properties, this.m_mode);
        this.addPage((SonargraphWizardPage)this.m_page);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            assert (provider.hasSoftwareSystem()) : "No system available";
            switch (this.m_mode) {
                case CREATE: {
                    final CreateTreeMapInteraction interaction = new CreateTreeMapInteraction();
                    CreateTreeMapCommand command = new CreateTreeMapCommand(provider, (CreateTreeMapCommand.ICreateTreeMapInteraction)interaction);
                    UserInterfaceAdapter.getInstance().run((Command)command, new CommandResultConsumer(){

                        public void consume(CommandException exception) {
                            OperationResultWithOutcome<TreeMapFile> result;
                            if (exception == null && (result = interaction.getResult()) != null && result.isSuccess()) {
                                TreeMapFile representation = (TreeMapFile)result.getOutcome();
                                if (!$assertionsDisabled && representation == null) {
                                    throw new AssertionError((Object)"'representation' of method 'consume' must not be null");
                                }
                                ShowInViewSelectionAdapter.showInView((IEclipseContext)WorkbenchRegistry.getInstance().getEclipseContext(), (EPartService)WorkbenchRegistry.getInstance().getPartService(), (IViewId)ViewId.TREE_MAP_VIEW, (String)representation.getName(), Collections.emptyList(), Collections.singletonList(representation), (boolean)false);
                            }
                            super.consume(exception);
                        }
                    });
                    break;
                }
                case EDIT: {
                    EditTreeMapCommand command = new EditTreeMapCommand(provider, (EditTreeMapCommand.IEditTreeMapInteraction)new EditTreeMapInteraction());
                    UserInterfaceAdapter.getInstance().run((Command)command);
                    break;
                }
                default: {
                    assert (false) : "Unhandled mode: " + String.valueOf((Object)this.m_mode);
                    break;
                }
            }
            return true;
        }
        return true;
    }

    private final class CreateTreeMapInteraction
    implements CreateTreeMapCommand.ICreateTreeMapInteraction {
        private OperationResultWithOutcome<TreeMapFile> m_result;

        CreateTreeMapInteraction() {
        }

        public boolean collect(CreateTreeMapCommand.CreateTreeMapData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            data.setProperties(TreeMapWizard.this.m_page.getProperties());
            return true;
        }

        public void processCreateTreeMapResult(OperationResultWithOutcome<TreeMapFile> result) {
            assert (result != null) : "Parameter 'result' of method 'processCreateTreeMapResult' must not be null";
            UserInterfaceAdapter.getInstance().process(result);
            this.m_result = result;
        }

        OperationResultWithOutcome<TreeMapFile> getResult() {
            return this.m_result;
        }
    }

    private final class EditTreeMapInteraction
    implements EditTreeMapCommand.IEditTreeMapInteraction {
        EditTreeMapInteraction() {
        }

        public boolean collect(EditTreeMapCommand.EditTreeMapData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            assert (TreeMapWizard.this.m_file != null) : "'m_file' of method 'collect' must not be null";
            data.setData(TreeMapWizard.this.m_file, TreeMapWizard.this.m_page.getProperties());
            return true;
        }

        public void processEditTreeMapResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processEditTreeMapResult' must not be null";
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

