/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.treemap.LeafNodeColor;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapNodeData;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.RGB;

abstract class TreeMapNodeView {
    private final TreeMapNode<NamedElement, TreeMapNodeData> m_node;
    private boolean m_isSelected;

    TreeMapNodeView(TreeMapNode<NamedElement, TreeMapNodeData> node) {
        assert (node != null) : "Parameter 'node' of method 'TreeMapNodeView' must not be null";
        this.m_node = node;
    }

    final RGB getRGB(boolean greyNonSelected) {
        if (this.isSelected()) {
            return UiResourceManager.getInstance().getTreeMapNodeSelectionRGB();
        }
        if (this.m_node.isLeaf()) {
            if (greyNonSelected) {
                return UiResourceManager.getInstance().getTreeMapNodeGreyedRGB();
            }
            TreeMapNodeData data = (TreeMapNodeData)this.m_node.getAssociatedData();
            assert (data != null) : "'data' of method 'getColor' must not be null";
            LeafNodeColor leafNodeColor = data.getLeafColor();
            assert (leafNodeColor != null) : "'leafNodeColor' of method 'getColor' must not be null";
            return UiResourceManager.getInstance().getTreeMapLeafRGB(leafNodeColor);
        }
        return UiResourceManager.getInstance().getTreeMapNestingRGB(this.m_node.getLevel());
    }

    final TreeMapNode<NamedElement, TreeMapNodeData> getNode() {
        return this.m_node;
    }

    final void setIsSelected(boolean isSelected) {
        this.m_isSelected = isSelected;
    }

    final boolean isSelected() {
        return this.m_isSelected;
    }
}

