/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ModuleBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

final class ModuleSelectionDialog
extends StandardDialog
implements ISelectionChangedListener {
    private PropertyTableViewer<Module> m_viewer;
    private final List<Module> m_modules;
    private final List<Module> m_selectedModules;

    ModuleSelectionDialog(Shell shell, List<Module> modules) {
        super(shell, "Module Selection");
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'ModuleSelectionDialog' must not be empty";
        this.m_modules = new ArrayList<Module>(modules);
        this.m_selectedModules = new ArrayList<Module>();
    }

    protected void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        this.m_viewer = new PropertyTableViewer(composite, (BeanPropertyReader.BeanAdapter)new ModuleBeanAdapter(), "name", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_viewer.addColumn("Module", "name", "name", "image", 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_viewer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_viewer.showData(this.m_modules);
        this.m_viewer.select(this.m_modules);
        this.m_selectedModules.addAll(this.m_modules);
        this.m_viewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void applyData() {
        this.getButton(0).setEnabled(true);
        super.applyData();
    }

    protected Point getPreferredSize() {
        return new Point(500, 700);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        this.m_selectedModules.clear();
        for (Object next : event.getStructuredSelection().toList()) {
            assert (next != null && next instanceof Module) : "Unexpected class in method 'selectionChanged': " + String.valueOf(next);
            this.m_selectedModules.add((Module)next);
        }
        this.getButton(0).setEnabled(!this.m_selectedModules.isEmpty());
    }

    List<Module> getModules() {
        return Collections.unmodifiableList(this.m_selectedModules);
    }
}

