/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.ui.standalone.treemap.Vertex;

public final class Matrix {
    final double[][] m;

    Matrix(double[][] m) {
        assert (m != null) : "Parameter 'values' of method 'Matrix' must not be null";
        assert (m.length == 4 && m[0].length == 4) : "Not a 4x4 matrix";
        this.m = m;
    }

    public Matrix createdMultiplied(Matrix other) {
        assert (other != null) : "Parameter 'other' of method 'createdMultiplied' must not be null";
        double[][] values = new double[4][4];
        int r = 0;
        while (r < 4) {
            int c = 0;
            while (c < 4) {
                int n = 0;
                while (n < 4) {
                    double[] dArray = values[r];
                    int n2 = c;
                    dArray[n2] = dArray[n2] + this.m[r][n] * other.m[n][c];
                    ++n;
                }
                ++c;
            }
            ++r;
        }
        return new Matrix(values);
    }

    public Vertex createTransformed(Vertex vertex) {
        assert (vertex != null) : "Parameter 'vertex' of method 'transform' must not be null";
        double x = vertex.x * this.m[0][0] + vertex.y * this.m[0][1] + vertex.z * this.m[0][2] + vertex.w * this.m[0][3];
        double y = vertex.x * this.m[1][0] + vertex.y * this.m[1][1] + vertex.z * this.m[1][2] + vertex.w * this.m[1][3];
        double z = vertex.x * this.m[2][0] + vertex.y * this.m[2][1] + vertex.z * this.m[2][2] + vertex.w * this.m[2][3];
        double w = vertex.x * this.m[3][0] + vertex.y * this.m[3][1] + vertex.z * this.m[3][2] + vertex.w * this.m[3][3];
        return new Vertex(x, y, z, w);
    }

    public void transform(Vertex vertex) {
        assert (vertex != null) : "Parameter 'vertex' of method 'transform' must not be null";
        double x = vertex.x * this.m[0][0] + vertex.y * this.m[0][1] + vertex.z * this.m[0][2] + vertex.w * this.m[0][3];
        double y = vertex.x * this.m[1][0] + vertex.y * this.m[1][1] + vertex.z * this.m[1][2] + vertex.w * this.m[1][3];
        double z = vertex.x * this.m[2][0] + vertex.y * this.m[2][1] + vertex.z * this.m[2][2] + vertex.w * this.m[2][3];
        double w = vertex.x * this.m[3][0] + vertex.y * this.m[3][1] + vertex.z * this.m[3][2] + vertex.w * this.m[3][3];
        vertex.x = x;
        vertex.y = y;
        vertex.z = z;
        vertex.w = w;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int r = 0;
        while (r < this.m.length) {
            int c = 0;
            while (c < this.m[r].length) {
                if (c > 0) {
                    builder.append("\t");
                }
                builder.append(this.m[r][c]);
                ++c;
            }
            builder.append("\n");
            ++r;
        }
        builder.delete(builder.length() - 1, builder.length());
        return builder.toString();
    }

    public static Matrix createAxisXRotationMatrix(double radians) {
        return new Matrix(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, Math.cos(radians), Math.sin(radians), 0.0}, {0.0, -Math.sin(radians), Math.cos(radians), 0.0}, {0.0, 0.0, 0.0, 1.0}});
    }

    public static Matrix createAxisYRotationMatrix(double radians) {
        return new Matrix(new double[][]{{Math.cos(radians), 0.0, -Math.sin(radians), 0.0}, {0.0, 1.0, 0.0, 0.0}, {Math.sin(radians), 0.0, Math.cos(radians), 0.0}, {0.0, 0.0, 0.0, 1.0}});
    }

    public static Matrix createAxisZRotationMatrix(double radians) {
        return new Matrix(new double[][]{{Math.cos(radians), Math.sin(radians), 0.0, 0.0}, {-Math.sin(radians), Math.cos(radians), 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}});
    }

    public static Matrix createTranslationMatrix(double dx, double dy, double dz) {
        return new Matrix(new double[][]{{1.0, 0.0, 0.0, dx}, {0.0, 1.0, 0.0, dy}, {0.0, 0.0, 1.0, dz}, {0.0, 0.0, 0.0, 1.0}});
    }

    public static Matrix createPerspectiveMatrix(double a, double fov, double zn, double zf) {
        double f = 1.0 / Math.tan(fov / 2.0);
        return new Matrix(new double[][]{{a * f, 0.0, 0.0, 0.0}, {0.0, f, 0.0, 0.0}, {0.0, 0.0, zf / (zf - zn), -(zf * zn / (zf - zn))}, {0.0, 0.0, 1.0, 0.0}});
    }
}

