/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMap;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapNodeData;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapCuboid;
import java.util.ArrayList;
import java.util.List;

final class CuboidCreator
implements TreeMapNode.IVisitor<NamedElement, TreeMapNodeData> {
    private final List<TreeMapCuboid> m_cuboids = new ArrayList<TreeMapCuboid>(1000);
    private int m_height;
    private TreeMapCuboid m_root;

    CuboidCreator() {
    }

    public boolean visitNode(TreeMapNode<NamedElement, TreeMapNodeData> node) {
        int height;
        assert (node != null) : "Parameter 'node' of method 'visitNode' must not be null";
        int altitude = (1 + node.getLevel()) * 2;
        if (node.isLeaf()) {
            TreeMapNodeData data = (TreeMapNodeData)node.getAssociatedData();
            height = data.getLeafHeight();
        } else {
            height = 2;
        }
        TreeMapCuboid cuboid = new TreeMapCuboid(node, node.getAbsoluteX(), node.getAbsoluteY(), altitude, node.getWidth(), node.getHeight(), height);
        if (node instanceof TreeMap) {
            this.m_root = cuboid;
        }
        this.m_cuboids.add(cuboid);
        this.m_height = Math.max(this.m_height, altitude + height);
        return true;
    }

    List<TreeMapCuboid> getCuboids() {
        return this.m_cuboids;
    }

    int getHeight() {
        return this.m_height;
    }

    TreeMapCuboid getRoot() {
        return this.m_root;
    }
}

