/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise;

import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

final class SnapshotActionWizardPage
extends StandardWizardPage {
    private static final IDialogId ID = CoreDialogId.SNAPSHOT_ACTION_PAGE;
    private Button m_openSnapshot;
    private Button m_attachSnapshot;
    private Button m_doNothing;
    private SnapshotAction m_selectedAction;
    private TFile m_snapshot;

    SnapshotActionWizardPage() {
        super(ID.getStandardName(), ID.getPresentationName());
    }

    protected void createContent(Composite parent) {
        assert (parent != null) : "Parameter 'composite' of method 'createContent' must not be null";
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.getSource() == SnapshotActionWizardPage.this.m_openSnapshot) {
                    SnapshotActionWizardPage.this.m_selectedAction = SnapshotAction.OPEN_FROM_SNAPSHOT;
                } else if (event.getSource() == SnapshotActionWizardPage.this.m_attachSnapshot) {
                    SnapshotActionWizardPage.this.m_selectedAction = SnapshotAction.ATTACH_SNAPSHOT;
                } else if (event.getSource() == SnapshotActionWizardPage.this.m_doNothing) {
                    SnapshotActionWizardPage.this.m_selectedAction = SnapshotAction.DO_NOTHING;
                } else if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected source: " + String.valueOf(event.getSource())));
                }
                SnapshotActionWizardPage.this.setPageComplete(SnapshotActionWizardPage.this.isPageComplete());
            }
        };
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 128, true, true));
        composite.setLayout((Layout)new FillLayout(512));
        this.m_openSnapshot = new Button(composite, 16);
        this.m_openSnapshot.setText("Open System From Snapshot");
        this.m_openSnapshot.addSelectionListener((SelectionListener)selectionAdapter);
        this.m_attachSnapshot = new Button(composite, 16);
        this.m_attachSnapshot.setText("Attach Snapshot");
        this.m_attachSnapshot.addSelectionListener((SelectionListener)selectionAdapter);
        this.m_attachSnapshot.setEnabled(false);
        this.m_doNothing = new Button(composite, 16);
        this.m_doNothing.setText("Nothing (Snapshot saved for later use.)");
        this.m_doNothing.addSelectionListener((SelectionListener)selectionAdapter);
    }

    public boolean isPageComplete() {
        return this.m_snapshot != null;
    }

    void setTargetFile(TFile snapshot) {
        assert (snapshot != null) : "Parameter 'snapshot' of method 'setTargetFile' must not be null";
        this.m_snapshot = snapshot;
    }

    protected int getNumberOfColumns() {
        return 1;
    }

    SnapshotAction getSelectedAction() {
        return this.m_selectedAction;
    }

    void enableAttachSnapshotAction(boolean enableAttach, SnapshotAction preferredAction) {
        assert (preferredAction != null) : "Parameter 'preferredAction' of method 'enableAttachSnapshotAction' must not be null";
        this.m_attachSnapshot.setEnabled(enableAttach);
        this.m_selectedAction = preferredAction;
        switch (this.m_selectedAction) {
            case OPEN_FROM_SNAPSHOT: {
                this.m_openSnapshot.setSelection(true);
                break;
            }
            case ATTACH_SNAPSHOT: {
                assert (enableAttach) : "Attach snapshot cannot be set if attaching is disabled";
                this.m_attachSnapshot.setSelection(true);
                break;
            }
            case DO_NOTHING: {
                this.m_doNothing.setSelection(true);
                break;
            }
            default: {
                assert (false) : "Unsupported action " + String.valueOf((Object)this.m_selectedAction);
                break;
            }
        }
    }

    static enum SnapshotAction implements IStandardEnumeration
    {
        OPEN_FROM_SNAPSHOT,
        ATTACH_SNAPSHOT,
        DO_NOTHING;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }

        public static SnapshotAction fromStandardName(String standardName) {
            SnapshotAction[] snapshotActionArray = SnapshotAction.values();
            int n = snapshotActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                SnapshotAction next = snapshotActionArray[n2];
                if (next.getStandardName().equals(standardName)) {
                    return next;
                }
                ++n2;
            }
            return null;
        }
    }
}

