/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemModifiedEvent;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOnDemand;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ExplorationViewShowInViewRequest;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public final class StandaloneActions {
    static final String DD_NOT_OPEN_PRESENTATION_NAME = "Do Not Open";
    static final String DO_NOT_OPEN_IMAGE_RESOURCE_NAME = "DoNotOpen";
    static final String EXPLORATION_VIEW_IMAGE_RESOURCE_NAME = "ExplorationView";
    private static final String DO_NOT_OPEN_STANDARD_NAME = "DoNotOpen";
    private static final String OPEN_EXPLORATION_VIEW_AUTOMATICALLY = "OpenExplorationViewAutomatically";
    private static StandaloneActions s_instance;
    private ExplorationViewStructureMode m_structureMode;

    private StandaloneActions() {
        if (CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.ARCHITECTURE)) {
            EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemModifiedEvent>(SoftwareSystemModifiedEvent.class, (Object)this){

                public void handleEvent(SoftwareSystemModifiedEvent event) {
                    if (!$assertionsDisabled && event == null) {
                        throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                    }
                    SoftwareSystem softwareSystem = event.getProvider().getSoftwareSystem();
                    StandaloneActions.this.handleExplorationViewConnection(softwareSystem, event.getModification());
                }
            });
            this.updateActions();
        }
    }

    ExplorationViewStructureMode getOpenExplorationViewAutomatically() {
        this.updateActions();
        return this.m_structureMode;
    }

    private void updateActions() {
        SoftwareSystem softwareSystem = WorkbenchRegistry.getInstance().getSoftwareSystem();
        if (softwareSystem != null) {
            if (this.m_structureMode != null && !this.m_structureMode.isAvailableFor((Collection)softwareSystem.getUsedLanguages())) {
                this.m_structureMode = null;
            }
        } else {
            IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone");
            String structureModeStandardName = eclipsePreferences.get(OPEN_EXPLORATION_VIEW_AUTOMATICALLY, "DoNotOpen");
            if ("DoNotOpen".equals(structureModeStandardName)) {
                this.m_structureMode = null;
            } else {
                try {
                    this.m_structureMode = ExplorationViewStructureMode.fromStandardName((String)structureModeStandardName);
                }
                catch (IllegalArgumentException ex) {
                    this.m_structureMode = null;
                }
            }
        }
    }

    private void handleExplorationViewConnection(SoftwareSystem softwareSystem, EnumSet<Modification> modifications) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'handleExplorationViewConnection' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'handleExplorationViewConnection' must not be null";
        this.updateActions();
        if (this.m_structureMode != null && softwareSystem.isClearable() && modifications.contains(Modification.PARSER_MODEL_MODIFIED) && !((IArchitecturalViewProvider)softwareSystem.getExtension(IArchitecturalViewProvider.class)).hasLoadedArchitecturalViews(true)) {
            this.openExplorationView(softwareSystem, this.m_structureMode);
        }
    }

    void setOpenExplorationViewAutomatically(ExplorationViewStructureMode structureMode) {
        if (structureMode != this.m_structureMode) {
            this.m_structureMode = structureMode;
            IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone");
            eclipsePreferences.put(OPEN_EXPLORATION_VIEW_AUTOMATICALLY, this.m_structureMode == null ? "DoNotOpen" : this.m_structureMode.getStandardName());
            PreferencesUtility.save((IEclipsePreferences)eclipsePreferences);
        }
    }

    void openExplorationView(SoftwareSystem softwareSystem, ExplorationViewStructureMode structureMode) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'openExplorationView' must not be null";
        assert (structureMode != null) : "Parameter 'structureMode' of method 'openExplorationView' must not be null";
        ExplorationViewOnDemand onDemand = ((IArchitecturalViewProvider)softwareSystem.getExtension(IArchitecturalViewProvider.class)).isLoadable(structureMode);
        if (onDemand != null) {
            ShowInViewSelectionAdapter.showInView((IEclipseContext)WorkbenchRegistry.getInstance().getEclipseContext(), (EPartService)WorkbenchRegistry.getInstance().getPartService(), (IViewId)ViewId.EXPLORATION_VIEW, (String)onDemand.getId(), Collections.singletonList(new ExplorationViewShowInViewRequest(ExplorationViewShowInViewRequest.Type.ON_DEMAND, null, onDemand)), Collections.singletonList(onDemand), (boolean)false);
        }
    }

    public static void createInstance() {
        assert (s_instance == null) : "'s_instance' of method 'createInstance' must  be null";
        s_instance = new StandaloneActions();
    }

    public static StandaloneActions getInstance() {
        assert (s_instance != null) : "'s_instance' of method 'getInstance' must not be null";
        return s_instance;
    }

    public static void delete() {
        if (s_instance != null) {
            EventManager.getInstance().detach(SoftwareSystemModifiedEvent.class, (Object)s_instance);
            s_instance = null;
        }
    }
}

