/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.IBoxCompositeContribution;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.StackedBarWidget;
import com.hello2morrow.sonargraph.ui.swt.base.DetailsSeparatorWidget;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.ArrayList;
import java.util.function.Function;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public final class SourceFileDiscrimination
implements IBoxCompositeContribution {
    private final Label m_label;
    private final StackedBarWidget m_stackedBarWidget;
    private final GridData m_gridDataLabel;
    private final GridData m_gridDataBarWidget;
    private final Label m_filler;
    private final GridData m_gridDataFiller;

    public SourceFileDiscrimination(Composite parent, int firstColumnWidth) {
        this.m_label = new Label(parent, 0);
        this.m_label.setText("Source file discrimination: ");
        this.m_label.setToolTipText("Discrimination of the code base into \n(1) files that are fully analyzed,\n(2) files that only parser problems and architecture violations are reported for,\n(3) files marked as test code and\n(4) excluded files.");
        this.m_gridDataLabel = new GridData(4, 0x1000000, false, false);
        this.m_gridDataLabel.widthHint = firstColumnWidth;
        this.m_label.setLayoutData((Object)this.m_gridDataLabel);
        this.m_label.setForeground(UiResourceManager.getInstance().getColor(LABEL_COLOR));
        this.m_stackedBarWidget = new StackedBarWidget(parent, 0, StackedBarWidget.ValueType.NUMERIC_AND_PERCENT, "Source File Discrimination");
        this.m_gridDataBarWidget = new GridData(4, 4, false, false);
        this.m_gridDataBarWidget.heightHint = 12;
        this.m_gridDataBarWidget.widthHint = 140;
        this.m_stackedBarWidget.setLayoutData(this.m_gridDataBarWidget);
        this.m_filler = SwtUtility.createFillerForGridLayoutCell((Composite)parent, (int)2, (int)1);
        this.m_gridDataFiller = (GridData)this.m_filler.getLayoutData();
        this.setDiscriminationValues(0, 0, 0, 0);
    }

    public void setDiscriminationValues(int fullyAnalyzed, int issueIgnoring, int test, int excluded) {
        int total = fullyAnalyzed + issueIgnoring + test + excluded;
        if (total == 0) {
            this.m_stackedBarWidget.reset();
            return;
        }
        ArrayList<StackedBarWidget.BarPartInfo> parts = new ArrayList<StackedBarWidget.BarPartInfo>(4);
        Function<Integer, Float> percent = a -> Float.valueOf((float)a.intValue() * 100.0f / (float)total);
        parts.add(new StackedBarWidget.BarPartInfo("Fully Analyzed", fullyAnalyzed, percent.apply(fullyAnalyzed), UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_BLUE), "dark blue", true));
        parts.add(new StackedBarWidget.BarPartInfo("Issue Ignoring", issueIgnoring, percent.apply(issueIgnoring), UiResourceManager.getInstance().getColor(UiResourceManager.VERY_LIGHT_BLUE), "blue", true));
        parts.add(new StackedBarWidget.BarPartInfo("Test", test, percent.apply(test), UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_GREY), "grey", true));
        parts.add(new StackedBarWidget.BarPartInfo("Excluded", excluded, percent.apply(excluded), UiResourceManager.getInstance().getColor(UiResourceManager.DARK_GREY), "dark grey", true));
        this.m_stackedBarWidget.setPartInfos(parts);
    }

    public void changeExpansionState(DetailsSeparatorWidget.ExpansionState expansionState, String identifier) {
        assert (expansionState != null) : "Parameter 'expansionState' of method 'changeExpansionState' must not be null";
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'changeExpansionState' must not be empty";
        boolean visible = expansionState == DetailsSeparatorWidget.ExpansionState.EXPANDED;
        this.m_label.setVisible(visible);
        this.m_gridDataLabel.exclude = !visible;
        this.m_stackedBarWidget.setVisible(visible);
        this.m_gridDataBarWidget.exclude = !visible;
        this.m_filler.setVisible(visible);
        this.m_gridDataFiller.exclude = !visible;
    }
}

