/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemAsCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.SoftwareSystemDialog;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SaveCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SoftwareSystemBasedHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class SaveSoftwareSystemAsHandler
extends SoftwareSystemBasedHandler {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.SAVE_SOFTWARE_SYSTEM_AS;
    }

    @CanExecute
    public boolean canExecute(@Optional MMenuItem menuItem) {
        if (this.isAvailable(menuItem)) {
            return WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED});
        }
        return false;
    }

    @Execute
    public void execute() {
        UserInterfaceAdapter.getInstance().run((Command)new SaveSoftwareSystemAsCommand(WorkbenchRegistry.getInstance().getProvider(), (SaveSoftwareSystemAsCommand.IInteraction)new SaveAsCommandInteraction()));
    }

    static final class SaveAsCommandInteraction
    extends SaveCommandInteraction
    implements SaveSoftwareSystemAsCommand.IInteraction {
        SaveAsCommandInteraction() {
            super(true);
        }

        @Override
        protected boolean askToProceedInCaseOfFailure() {
            return true;
        }

        public boolean collect(final SaveSoftwareSystemAsCommand.SaveAsData data) {
            RunnableWithResult<Boolean> result = new RunnableWithResult<Boolean>(){

                public void run() {
                    ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
                    SoftwareSystem softwareSystem = provider.getSoftwareSystem();
                    SoftwareSystemDialog dialog = new SoftwareSystemDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "Save System As", SaveSoftwareSystemAsCommand.getNameValidator((ISoftwareSystemProvider)provider), SaveSoftwareSystemAsCommand.getPathValidator((ISoftwareSystemProvider)provider), softwareSystem.getDirectoryFile(), softwareSystem.getName());
                    if (dialog.open() == 0) {
                        data.setName(dialog.getName());
                        data.setDirectory(dialog.getDirectory());
                        this.setResult(Boolean.TRUE);
                    } else {
                        this.setResult(Boolean.FALSE);
                    }
                }
            };
            return (Boolean)UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)result);
        }

        public void processSavedAsResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }

        public boolean confirmSaveOnSaveAs(String message) {
            assert (message != null && message.length() > 0) : "Parameter 'message' of method 'confirmSaveOnSaveAs' must not be empty";
            return UserInterfaceAdapter.getInstance().question(message, false) == UserInterfaceAdapter.Feedback.CONFIRMED;
        }

        public boolean confirmOverwrite(String message) {
            assert (message != null && message.length() > 0) : "Parameter 'message' of method 'confirmOverwrite' must not be empty";
            return UserInterfaceAdapter.getInstance().question(message, false) == UserInterfaceAdapter.Feedback.CONFIRMED;
        }
    }
}

