/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.EditSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.EditSystemDialog;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SaveCommandInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.HashMap;
import java.util.List;

public final class EditSoftwareSystemCommandAdapter
extends CompositeCommandAdapter {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.EDIT_SOFTWARE_SYSTEM;
    }

    public CompositeCommandAdapter.Type getType() {
        return CompositeCommandAdapter.Type.EDIT;
    }

    public CompositeCommandAdapter.Applicable applicable(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'applicable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'applicable' must not be null";
        if (elements.size() == 0) {
            return new CompositeCommandAdapter.Applicable();
        }
        if (elements.size() == 1) {
            SoftwareSystem softwareSystem = (SoftwareSystem)CommandHandler.getSingleSelection(SoftwareSystem.class, elements, (boolean)false);
            if (softwareSystem != null) {
                return new CompositeCommandAdapter.Applicable();
            }
            SoftwareSystemFile softwareSystemFile = (SoftwareSystemFile)CommandHandler.getSingleSelection(SoftwareSystemFile.class, elements, (boolean)false);
            if (softwareSystemFile != null) {
                return new CompositeCommandAdapter.Applicable();
            }
        }
        return null;
    }

    public void apply(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'apply' must not be null";
        UserInterfaceAdapter.getInstance().run((Command)new EditSoftwareSystemCommand(WorkbenchRegistry.getInstance().getProvider(), (EditSoftwareSystemCommand.IInteraction)new EditCommandInteraction()));
    }

    public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> elements) {
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'showInContectMenu' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'showInContectMenu' must not be null";
        return workbenchView.getViewId() == ViewId.NAVIGATION_VIEW || workbenchView.getViewId() == ViewId.LOGICAL_NAMESPACES_VIEW || workbenchView.getViewId() == ViewId.FILES_VIEW;
    }

    static final class EditCommandInteraction
    extends SaveCommandInteraction
    implements EditSoftwareSystemCommand.IInteraction {
        public EditCommandInteraction() {
            super(true);
        }

        @Override
        protected boolean askToProceedInCaseOfFailure() {
            return true;
        }

        public boolean collect(final EditSoftwareSystemCommand.EditData data) {
            RunnableWithResult<Boolean> result = new RunnableWithResult<Boolean>(){

                public void run() {
                    ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
                    SoftwareSystem softwareSystem = provider.getSoftwareSystem();
                    HashMap<String, String> metaData = new HashMap<String, String>();
                    ISoftwareSystem.KnownMetaDataKeys[] knownMetaDataKeysArray = ISoftwareSystem.KnownMetaDataKeys.values();
                    int n = knownMetaDataKeysArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISoftwareSystem.KnownMetaDataKeys key = knownMetaDataKeysArray[n2];
                        String val = softwareSystem.getMetaData(key.name());
                        if (val != null && !val.isEmpty()) {
                            metaData.put(key.name(), val);
                        }
                        ++n2;
                    }
                    EditSystemDialog dialog = new EditSystemDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "Edit System", EditSoftwareSystemCommand.getNameValidator((ISoftwareSystemProvider)provider), softwareSystem.getName(), softwareSystem.getDescription(), metaData);
                    if (dialog.open() == 0) {
                        data.setName(dialog.getName());
                        data.setDescription(dialog.getDescription());
                        ISoftwareSystem.KnownMetaDataKeys[] knownMetaDataKeysArray2 = ISoftwareSystem.KnownMetaDataKeys.values();
                        int n3 = knownMetaDataKeysArray2.length;
                        n = 0;
                        while (n < n3) {
                            ISoftwareSystem.KnownMetaDataKeys key = knownMetaDataKeysArray2[n];
                            String val = dialog.getMetaData(key);
                            if (val != null) {
                                data.setMetaData(key.name(), val);
                            }
                            ++n;
                        }
                        this.setResult(Boolean.TRUE);
                    } else {
                        this.setResult(Boolean.FALSE);
                    }
                }
            };
            return (Boolean)UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)result);
        }

        public void processEditResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }

        public boolean confirmSaveOnEdit() {
            return UserInterfaceAdapter.getInstance().question("The system directory is about to change and system files will be saved immediately." + StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR + "Do you want to proceed?", false) == UserInterfaceAdapter.Feedback.CONFIRMED;
        }
    }
}

