/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerData;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.DecoratingImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.Image;

final class ScriptRunnerDataBeanAdapter
extends BeanPropertyReader.BeanAdapter<ScriptRunnerData> {
    private final ScriptRunnerConfiguration m_configuration;
    private ScriptRunnerData m_data;

    ScriptRunnerDataBeanAdapter(ScriptRunnerConfiguration configuration) {
        assert (configuration != null) : "Parameter 'configuration' of method 'ScriptRunnerDataBeanAdapter' must not be null";
        this.m_configuration = configuration;
    }

    protected void setAdaptedObject(ScriptRunnerData data) {
        this.m_data = data;
    }

    public String getScript() {
        assert (this.m_data != null) : "'m_data' of method 'getIdentifyingScriptPath' must not be null";
        return this.m_data.getIdentifyingScriptPath();
    }

    public Image getScriptImage() {
        assert (this.m_data != null) : "'m_data' of method 'getScriptImage' must not be null";
        if (this.m_configuration.getWarning(this.m_data.getIdentifyingScriptPath(), this.m_data.getRunConfigurationName()) != null) {
            CompositeImageDescriptor descriptor = new CompositeImageDescriptor("GroovyScript");
            descriptor.addMarker(DecoratingImageDescriptor.Corner.LOWER_RIGHT, "WarningMarker");
            return UiResourceManager.getInstance().getImage(descriptor);
        }
        return UiResourceManager.getInstance().getImage("GroovyScript");
    }

    public String getScriptTooltip() {
        assert (this.m_data != null) : "'m_data' of method 'getScriptTooltip' must not be null";
        return this.m_configuration.getWarning(this.m_data.getIdentifyingScriptPath(), this.m_data.getRunConfigurationName());
    }

    public String getRunConfiguration() {
        assert (this.m_data != null) : "'m_data' of method 'getIdentifyingScriptPath' must not be null";
        return this.m_data.getRunConfigurationName();
    }

    public Image getRunConfigurationImage() {
        return UiResourceManager.getInstance().getImage("RunConfiguration");
    }
}

