/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class OptionConfigurationEntryWidget
extends Composite {
    private final AnalyzerConfiguration.IOptionConfigurationEntryDescriptor m_property;
    private final IValueListener m_listener;
    private final Combo m_combo;

    public OptionConfigurationEntryWidget(Composite parent, AnalyzerConfiguration.IOptionConfigurationEntryDescriptor property, String value, IValueListener listener) {
        super(parent, 0);
        assert (parent != null) : "Parameter 'parent' of method 'OptionConfigurationEntryWidget' must not be null";
        assert (property != null) : "Parameter 'property' of method 'OptionConfigurationEntryWidget' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'OptionConfigurationEntryWidget' must not be null";
        this.m_property = property;
        this.m_listener = listener;
        String[] strings = property.getPresentationName().split(":");
        assert (strings.length == 2) : "Expected 2:" + property.getPresentationName();
        String propertyTitle = strings[0];
        assert (propertyTitle != null && propertyTitle.length() > 0) : "'propertyTitle' of method 'OptionConfigurationEntryWidget' must not be empty";
        String propertyExplanation = strings[1];
        assert (propertyExplanation != null && propertyExplanation.length() > 0) : "'propertyExplanation' of method 'OptionConfigurationEntryWidget' must not be empty";
        this.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        Group group = new Group((Composite)this, 4);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 600;
        group.setLayoutData((Object)gridData);
        group.setText(propertyTitle);
        group.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        Label label = new Label((Composite)group, 64);
        label.setText(propertyExplanation.trim());
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_combo = new Combo((Composite)group, 2056);
        this.m_combo.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_combo.setItems(this.m_property.getOptions());
        this.m_combo.setText(value);
        GridData spinnerLayoutData = new GridData(1, 2, false, false);
        Point computedSize = this.m_combo.computeSize(-1, -1);
        spinnerLayoutData.widthHint = computedSize.x;
        this.m_combo.setLayoutData((Object)spinnerLayoutData);
        this.m_combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OptionConfigurationEntryWidget.this.m_listener.valueChanged(OptionConfigurationEntryWidget.this, OptionConfigurationEntryWidget.this.m_combo.getText());
            }
        });
    }

    public String getValue() {
        return this.m_combo.getText();
    }

    public void setValue(String value) {
        this.m_combo.setText(value);
    }

    public void setEnabled(boolean enabled) {
        this.m_combo.setEnabled(enabled);
    }

    public static interface IValueListener {
        public void valueChanged(OptionConfigurationEntryWidget var1, String var2);
    }
}

