/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.settings.AnalyzerPropertyPage;
import com.hello2morrow.sonargraph.ui.standalone.settings.IntegerConfigurationEntryWidget;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public final class DuplicateCodePropertyPage
extends AnalyzerPropertyPage<DuplicateCodeAnalyzerConfiguration>
implements IntegerConfigurationEntryWidget.IValueListener {
    private IntegerConfigurationEntryWidget m_minimalLineLength;
    private IntegerConfigurationEntryWidget m_minimalBlockLength;
    private IntegerConfigurationEntryWidget m_maxNumOfCopies;
    private IntegerConfigurationEntryWidget m_maxTolerancePerEdit;
    private IntegerConfigurationEntryWidget m_maxRelativeTolerancePercentage;

    public DuplicateCodePropertyPage() {
        super((IAnalyzerId)CoreAnalyzerId.DUPLICATE_CODE, true);
    }

    @Override
    public IDialogId getDialogId() {
        return CoreDialogId.DUPLICATECODE_ANALYZER_PROPERTY_PAGE;
    }

    @Override
    protected void restoreDefaults() {
        this.m_minimalLineLength.setValue(DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MINIMAL_LINE_LENGTH.getDefaultValue());
        this.m_minimalBlockLength.setValue(DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MINIMAL_BLOCK_LENGTH.getDefaultValue());
        this.m_maxNumOfCopies.setValue(DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_NUMBER_OF_COPIES.getDefaultValue());
        this.m_maxTolerancePerEdit.setValue(DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_TOLERANCE_PER_EDIT.getDefaultValue());
        this.m_maxRelativeTolerancePercentage.setValue(DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_RELATIVE_TOLERANCE_PERCENTAGE.getDefaultValue());
    }

    @Override
    protected boolean enableRestoreDefaultsButton(DuplicateCodeAnalyzerConfiguration configuration) {
        if (configuration != null) {
            if (configuration.getMinimalLineLength() != DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MINIMAL_LINE_LENGTH.getDefaultValue().intValue()) {
                return true;
            }
            if (configuration.getMinimalBlockLength() != DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MINIMAL_BLOCK_LENGTH.getDefaultValue().intValue()) {
                return true;
            }
            if (configuration.getMaximumNumberOfCopies() != DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_NUMBER_OF_COPIES.getDefaultValue().intValue()) {
                return true;
            }
            if (configuration.getMaximalTolerancePerEdit() != DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_TOLERANCE_PER_EDIT.getDefaultValue().intValue()) {
                return true;
            }
            if (configuration.getMaximumRelativeTolerancePercentage() != DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_RELATIVE_TOLERANCE_PERCENTAGE.getDefaultValue().intValue()) {
                return true;
            }
        } else {
            if (this.m_minimalLineLength.getValue() != DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MINIMAL_LINE_LENGTH.getDefaultValue().intValue()) {
                return true;
            }
            if (this.m_minimalBlockLength.getValue() != DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MINIMAL_BLOCK_LENGTH.getDefaultValue().intValue()) {
                return true;
            }
            if (this.m_maxNumOfCopies.getValue() != DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_NUMBER_OF_COPIES.getDefaultValue().intValue()) {
                return true;
            }
            if (this.m_maxTolerancePerEdit.getValue() != DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_TOLERANCE_PER_EDIT.getDefaultValue().intValue()) {
                return true;
            }
            if (this.m_maxRelativeTolerancePercentage.getValue() != DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_RELATIVE_TOLERANCE_PERCENTAGE.getDefaultValue().intValue()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean applyChanges(DuplicateCodeAnalyzerConfiguration configuration) {
        assert (configuration != null) : "Parameter 'configuration' of method 'applyChanges' must not be null";
        DuplicateCodeAnalyzerConfiguration original = configuration.copy();
        int value = this.m_maxRelativeTolerancePercentage.getValue();
        configuration.setValue(DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_RELATIVE_TOLERANCE_PERCENTAGE.getStandardName(), (Object)value);
        value = this.m_maxTolerancePerEdit.getValue();
        configuration.setValue(DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_TOLERANCE_PER_EDIT.getStandardName(), (Object)value);
        value = this.m_maxNumOfCopies.getValue();
        configuration.setValue(DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_NUMBER_OF_COPIES.getStandardName(), (Object)value);
        value = this.m_minimalLineLength.getValue();
        configuration.setValue(DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MINIMAL_LINE_LENGTH.getStandardName(), (Object)value);
        value = this.m_minimalBlockLength.getValue();
        configuration.setValue(DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MINIMAL_BLOCK_LENGTH.getStandardName(), (Object)value);
        return !original.equals((Object)configuration);
    }

    @Override
    protected void fillDialogArea(Composite composite, DuplicateCodeAnalyzerConfiguration configuration, boolean readOnly) {
        assert (composite != null) : "Parameter 'parent' of method 'fillDialogArea' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'fillDialogArea' must not be null";
        this.m_minimalLineLength = new IntegerConfigurationEntryWidget(composite, (AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor)DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MINIMAL_LINE_LENGTH, configuration.getMinimalLineLength(), this);
        this.m_minimalLineLength.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.m_minimalBlockLength = new IntegerConfigurationEntryWidget(composite, (AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor)DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MINIMAL_BLOCK_LENGTH, configuration.getMinimalBlockLength(), this);
        this.m_minimalBlockLength.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.m_maxNumOfCopies = new IntegerConfigurationEntryWidget(composite, (AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor)DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_NUMBER_OF_COPIES, configuration.getMaximumNumberOfCopies(), this);
        this.m_maxNumOfCopies.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.m_maxTolerancePerEdit = new IntegerConfigurationEntryWidget(composite, (AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor)DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_TOLERANCE_PER_EDIT, configuration.getMaximalTolerancePerEdit(), this);
        this.m_maxTolerancePerEdit.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.m_maxRelativeTolerancePercentage = new IntegerConfigurationEntryWidget(composite, (AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor)DuplicateCodeAnalyzerConfiguration.ConfigurationEntryDescriptor.MAXIMAL_RELATIVE_TOLERANCE_PERCENTAGE, configuration.getMaximumRelativeTolerancePercentage(), this);
        this.m_maxRelativeTolerancePercentage.setLayoutData(new GridData(4, 0x1000000, true, false));
        if (readOnly) {
            this.m_minimalLineLength.setEnabled(false);
            this.m_minimalBlockLength.setEnabled(false);
            this.m_maxNumOfCopies.setEnabled(false);
            this.m_maxRelativeTolerancePercentage.setEnabled(false);
            this.m_maxTolerancePerEdit.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(IntegerConfigurationEntryWidget source, int value) {
        this.updateRestoreDefaultsButton();
    }
}

