/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ComboWithImages;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractFileEntryDialog<T extends ModifiableFile>
extends StandardDialog
implements ComboWithImages.IItemSelectionListener {
    private final IDataProvider<T> m_provider;
    private ComboWithImages m_combo;
    private T m_current;
    private final String m_filePresentationName;

    public AbstractFileEntryDialog(Shell shell, String title, IDataProvider<T> provider, String fileTypePresentationName) {
        super(shell, title);
        assert (provider != null) : "Parameter 'provider' of method 'AbstractFileEntryDialog' must not be null";
        this.m_provider = provider;
        this.m_filePresentationName = fileTypePresentationName;
    }

    protected Point getMinimumSize() {
        return new Point(350, 100);
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        Label label = new Label(composite, 0);
        label.setText(this.m_filePresentationName + ":");
        List<T> files = this.m_provider.getAvailableFiles();
        assert (files != null && files.size() > 0) : "'files' of method 'fillDialogArea' must not be empty";
        this.m_combo = new ComboWithImages(composite, -1, "Select " + this.m_filePresentationName, new ComboWithImages.ILabelProvider(){

            public String getText(Object item) {
                return ((ModifiableFile)item).getIdentifyingPath();
            }

            public Image getImage(Object item) {
                return UiResourceManager.getInstance().getImage((Element)((ModifiableFile)item));
            }
        });
        this.m_current = (ModifiableFile)files.get(0);
        this.m_combo.setItems(files, this.m_current);
        this.m_combo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.m_combo.setSelectionListener((ComboWithImages.IItemSelectionListener)this);
    }

    protected void applyData() {
        this.getButton(0).setEnabled(true);
    }

    public void itemSelected(ComboWithImages source, Object item) {
        assert (source != null) : "Parameter 'source' of method 'itemSelected' must not be null";
        assert (item != null) : "Parameter 'item' of method 'itemSelected' must not be null";
        if (source == this.m_combo) {
            this.m_current = (ModifiableFile)item;
        } else assert (false) : "Unhandled source: " + String.valueOf(source);
    }

    T getFile() {
        assert (this.m_current != null) : "'m_current' of method 'getArchitectureFile' must not be null";
        return this.m_current;
    }

    public static interface IDataProvider<T> {
        public List<T> getAvailableFiles();
    }
}

