/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.scriptview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.script.IGroovyProvider;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ScriptContent;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.LanguageControl;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.ParameterDefinitionBuilderBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.ParameterDefinitionDialog;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class ScriptWizardPage
extends NameAndDescriptionWizardPage
implements ISelectionChangedListener,
SelectionListener {
    private final IGroovyProvider m_groovyProvider;
    private final ScriptContent.Builder m_scriptContentBuilder;
    private final Set<Language> m_languages;
    private PropertyTableViewer<ParameterDefinition.Builder> m_parameterDefinitions;
    private Button m_add;
    private Button m_delete;
    private Button m_edit;
    private Button m_up;
    private Button m_down;
    private final List<ParameterDefinition.Builder> m_current = new ArrayList<ParameterDefinition.Builder>();

    public ScriptWizardPage(IGroovyProvider groovyProvider, ScriptContent.Builder scriptContentBuilder, String title, String nameFieldLabel, Set<Language> languages, ITextValidator nameValidator, String name) {
        super("SCRIPT_PAGE", title, nameFieldLabel, nameValidator, name, scriptContentBuilder != null ? scriptContentBuilder.getDescription() : "");
        assert (languages != null && languages.size() > 0) : "'Parameter 'languages' must not be empty";
        assert (groovyProvider != null) : "Parameter 'groovyProvider' of method 'ScriptWizardPage' must not be null";
        assert (scriptContentBuilder != null) : "Parameter 'scriptContentBuilder' of method 'ScriptWizardPage' must not be null";
        this.m_groovyProvider = groovyProvider;
        this.m_scriptContentBuilder = scriptContentBuilder;
        this.m_languages = languages;
    }

    @Override
    protected void addWidgetsToDialogAreaAfter(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogAreaAfter' must not be null";
        Label languagesLabel = new Label(composite, 0);
        languagesLabel.setText("Languages: ");
        languagesLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        LanguageControl languageControl = new LanguageControl(composite, new LanguageControl.IConsumer(){

            @Override
            public void setValue(Set<Language> selectedLanguages) {
                if (!$assertionsDisabled && selectedLanguages == null) {
                    throw new AssertionError((Object)"Parameter 'selectedLanguages' of method 'setValue' must not be null");
                }
                ScriptWizardPage.this.m_scriptContentBuilder.languages(selectedLanguages);
                ScriptWizardPage.this.validate();
            }
        }, this.m_languages, this.m_scriptContentBuilder.getLanguages(), this.m_languages);
        languageControl.setLayoutData(new GridData(4, 2, true, false, 2, 1));
        this.m_parameterDefinitions = new PropertyTableViewer(composite, (BeanPropertyReader.BeanAdapter)new ParameterDefinitionBuilderBeanAdapter(), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_parameterDefinitions.addColumn("Parameter", "parameter", "parameter", "parameterImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_parameterDefinitions.addColumn("Type", "type", "type", null, 10, PropertyTableViewer.ColumnType.TEXT);
        this.m_parameterDefinitions.addColumn("Description", "description", "description", null, 45, PropertyTableViewer.ColumnType.TEXT);
        this.m_parameterDefinitions.addColumn("Default Value", "defaultValue", "defaultValue", null, 10, PropertyTableViewer.ColumnType.TEXT);
        this.m_parameterDefinitions.addColumn("Possible Values", "possibleValues", "possibleValues", null, 15, PropertyTableViewer.ColumnType.TEXT);
        this.m_parameterDefinitions.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite buttonRow = new Composite(composite, 0);
        buttonRow.setLayoutData((Object)new GridData(1, 4, false, true));
        buttonRow.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1));
        this.m_add = new Button(buttonRow, 8);
        this.m_add.setImage(UiResourceManager.getInstance().getImage("New"));
        this.m_add.addSelectionListener((SelectionListener)this);
        this.m_delete = new Button(buttonRow, 8);
        this.m_delete.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_delete.addSelectionListener((SelectionListener)this);
        this.m_edit = new Button(buttonRow, 8);
        this.m_edit.setImage(UiResourceManager.getInstance().getImage("Edit"));
        this.m_edit.addSelectionListener((SelectionListener)this);
        this.m_up = new Button(buttonRow, 8);
        this.m_up.setImage(UiResourceManager.getInstance().getImage("ArrowUp"));
        this.m_up.addSelectionListener((SelectionListener)this);
        this.m_down = new Button(buttonRow, 8);
        this.m_down.setImage(UiResourceManager.getInstance().getImage("ArrowDown"));
        this.m_down.addSelectionListener((SelectionListener)this);
        this.m_add.setEnabled(true);
        this.m_delete.setEnabled(false);
        this.m_edit.setEnabled(false);
        this.m_up.setEnabled(false);
        this.m_down.setEnabled(false);
        this.m_current.addAll(this.m_scriptContentBuilder.getParameterDefinitions());
        this.m_parameterDefinitions.showData(this.m_current);
        this.m_parameterDefinitions.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    @Override
    protected void updatePageCompletion(boolean hasValidData) {
        this.m_scriptContentBuilder.description(this.getElementDescription());
        super.updatePageCompletion(hasValidData);
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.SCRIPT_DIALOG;
    }

    private void applyModification(ParameterDefinition.Builder select) {
        this.m_scriptContentBuilder.parameterDefinitions(this.m_current);
        this.m_parameterDefinitions.showData(this.m_current);
        this.m_parameterDefinitions.getTableViewer().setSelection((ISelection)(select == null ? new StructuredSelection() : new StructuredSelection((Object)select)));
        this.validate();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        assert (event.getSource() == this.m_parameterDefinitions.getTableViewer()) : "Unexpected source: " + String.valueOf(event.getSelectionProvider());
        List selected = this.m_parameterDefinitions.getSelected();
        if (selected.size() == 0) {
            this.m_add.setEnabled(true);
            this.m_delete.setEnabled(false);
            this.m_edit.setEnabled(false);
            this.m_up.setEnabled(false);
            this.m_down.setEnabled(false);
        } else if (selected.size() == 1) {
            this.m_add.setEnabled(true);
            this.m_delete.setEnabled(!((ParameterDefinition.Builder)selected.get(0)).isPredefined());
            this.m_edit.setEnabled(true);
            int pos = this.m_current.indexOf(selected.get(0));
            this.m_up.setEnabled(pos > 0);
            this.m_down.setEnabled(pos < this.m_current.size() - 1);
        } else {
            this.m_add.setEnabled(true);
            boolean enableDelete = true;
            for (ParameterDefinition.Builder next : selected) {
                if (!next.isPredefined()) continue;
                enableDelete = false;
                break;
            }
            this.m_delete.setEnabled(enableDelete);
            this.m_edit.setEnabled(false);
            this.m_up.setEnabled(false);
            this.m_down.setEnabled(false);
        }
    }

    public void widgetSelected(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
        List selected = this.m_parameterDefinitions.getSelected();
        Object source = event.getSource();
        if (source == this.m_add) {
            ParameterDefinitionDialog dialog = new ParameterDefinitionDialog(this.getShell(), this.m_groovyProvider, this.m_current, null);
            if (dialog.open() == 0) {
                ParameterDefinition.Builder added = dialog.getParameterDefinition();
                this.m_current.add(added);
                this.applyModification(null);
            }
        } else if (source == this.m_edit) {
            ParameterDefinition.Builder toBeEdited = (ParameterDefinition.Builder)selected.get(0);
            ParameterDefinitionDialog dialog = new ParameterDefinitionDialog(this.getShell(), this.m_groovyProvider, this.m_scriptContentBuilder.getParameterDefinitions(), toBeEdited);
            if (dialog.open() == 0) {
                ParameterDefinition.Builder edited = dialog.getParameterDefinition();
                int index = this.m_current.indexOf(toBeEdited);
                this.m_current.set(index, edited);
                this.applyModification(edited);
            }
        } else if (source == this.m_delete) {
            this.m_current.removeAll(selected);
            this.applyModification(null);
        } else if (source == this.m_up) {
            assert (selected.size() == 1) : "Only one selected element expected";
            ParameterDefinition.Builder move = (ParameterDefinition.Builder)selected.get(0);
            int pos = this.m_current.indexOf(move);
            ParameterDefinition.Builder replaced = this.m_current.set(pos - 1, move);
            this.m_current.set(pos, replaced);
            this.applyModification(move);
        } else if (source == this.m_down) {
            assert (selected.size() == 1) : "Only one selected element expected";
            ParameterDefinition.Builder move = (ParameterDefinition.Builder)selected.get(0);
            int pos = this.m_current.indexOf(move);
            ParameterDefinition.Builder replaced = this.m_current.set(pos + 1, move);
            this.m_current.set(pos, replaced);
            this.applyModification(move);
        } else assert (false) : "Unhandled source: " + String.valueOf(source);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }
}

