/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.qualitygateview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.qualitygate.CreateQualityGateCommand;
import com.hello2morrow.sonargraph.core.command.system.qualitygate.EditQualityGateCoreInfoCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.common.StandardCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collections;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public final class QualityGateWizard
extends NonLazySonargraphWizard {
    private final QualityGate m_toBeEdited;
    private NameAndDescriptionWizardPage m_page;

    public QualityGateWizard() {
        super("New Quality Gate File");
        this.m_toBeEdited = null;
    }

    public QualityGateWizard(QualityGate toBeEdited) {
        super("Edit Quality Gate File");
        assert (toBeEdited != null) : "Parameter 'toBeEdited' of method 'QualityGateWizard' must not be null";
        this.m_toBeEdited = toBeEdited;
    }

    public int getPreferredWidth() {
        return 900;
    }

    public int getPreferredHeight() {
        return 500;
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        IQualityGateProvider qualityGateProvider = (IQualityGateProvider)provider.getSoftwareSystem().getExtension(IQualityGateProvider.class);
        ITextValidator nameValidator = qualityGateProvider.getNameValidator();
        String name = this.m_toBeEdited != null ? FileUtility.getFileNameWithoutExtension((TFile)this.m_toBeEdited.getFile()) : "";
        String description = this.m_toBeEdited != null ? this.m_toBeEdited.getDescription() : "";
        this.m_page = new NameAndDescriptionWizardPage("NameAndDescription", "Specify name and description", "Name:", nameValidator, name, description);
        this.addPage((SonargraphWizardPage)this.m_page);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            if (this.m_toBeEdited != null) {
                EditQualityGateCoreInfoCommand modifyCommand = new EditQualityGateCoreInfoCommand(provider, (EditQualityGateCoreInfoCommand.IEditInteraction)new EditInteraction());
                UserInterfaceAdapter.getInstance().run((Command)modifyCommand);
            } else {
                final CreateQualityGateCommand createCommand = new CreateQualityGateCommand(provider, (CreateQualityGateCommand.IQualityGateInteraction)new CreateInteraction());
                UserInterfaceAdapter.getInstance().run((Command)createCommand, new CommandResultConsumer(){

                    public void consume(CommandException exception) {
                        super.consume(exception);
                        if (exception == null) {
                            UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                                @Override
                                public void run() {
                                    QualityGate qualityGate = createCommand.getQualityGate();
                                    if (qualityGate != null) {
                                        ShowInViewSelectionAdapter.showInView((IEclipseContext)WorkbenchRegistry.getInstance().getEclipseContext(), (EPartService)WorkbenchRegistry.getInstance().getPartService(), (IViewId)ViewId.QUALITY_GATE_VIEW, (String)qualityGate.getFileId(), Collections.emptyList(), Collections.singletonList(qualityGate), (boolean)false);
                                    }
                                }
                            });
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    final class CreateInteraction
    extends StandardCommandInteraction
    implements CreateQualityGateCommand.IQualityGateInteraction {
        CreateInteraction() {
        }

        public boolean collect(CreateQualityGateCommand.QualityGateInteractionData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            data.setName(QualityGateWizard.this.m_page.getElementName());
            data.setDescription(QualityGateWizard.this.m_page.getElementDescription());
            return true;
        }

        public void handleResult(OperationResultWithOutcome<QualityGate> result) {
            UserInterfaceAdapter.getInstance().process(result);
        }
    }

    final class EditInteraction
    extends StandardCommandInteraction
    implements EditQualityGateCoreInfoCommand.IEditInteraction {
        EditInteraction() {
        }

        public boolean collect(EditQualityGateCoreInfoCommand.EditInteractionData data) {
            data.setQualityGate(QualityGateWizard.this.m_toBeEdited);
            data.setName(QualityGateWizard.this.m_page.getElementName());
            data.setDescription(QualityGateWizard.this.m_page.getElementDescription());
            return true;
        }

        public boolean confirmSaveOnEdit() {
            return UserInterfaceAdapter.getInstance().question("The quality gate file has changes and will be saved immediately to a new file." + StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR + "Do you want to proceed?", false) == UserInterfaceAdapter.Feedback.CONFIRMED;
        }

        public void processResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'process' must not be null";
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

