/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.presentationmodeview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.StructureMode;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchMasterView;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PresentationModeView
extends WorkbenchMasterView {
    private static final Logger LOGGER = LoggerFactory.getLogger(PresentationModeView.class);
    private final String m_modeKey = this.getViewId().getStandardName() + ".presentationMode";
    private PresentationMode m_presentationMode;

    public PresentationModeView() {
        IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone");
        String modeStandardName = eclipsePreferences.get(this.m_modeKey, PresentationMode.MIXED.getStandardName());
        try {
            this.m_presentationMode = PresentationMode.fromStandardName((String)modeStandardName);
            assert (!this.m_presentationMode.equals((Object)PresentationMode.NONE)) : "Unsupported presentation mode: " + String.valueOf(this.m_presentationMode);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Unrecognized presentation mode from preferences: " + modeStandardName);
            this.m_presentationMode = PresentationMode.MIXED;
        }
    }

    public final PresentationMode getPresentationMode() {
        return this.m_presentationMode;
    }

    protected abstract void presentationModeChanged();

    public final void setPresentationMode(PresentationMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'setPresentationMode' must not be null";
        assert (!mode.equals((Object)PresentationMode.NONE)) : "Unsupported presentation mode: " + String.valueOf(mode);
        if (!this.m_presentationMode.equals((Object)mode)) {
            this.removeListeners();
            this.m_presentationMode = mode;
            this.presentationModeChanged();
            this.createAndAddNavigationState(NavigationState.Type.VIEW_OPTIONS_CHANGED);
            this.getTreeViewer().refresh();
            this.addListeners();
            IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone");
            eclipsePreferences.put(this.m_modeKey, this.m_presentationMode.getStandardName());
            PreferencesUtility.save((IEclipsePreferences)eclipsePreferences);
        }
    }

    public final StructureMode getStructureMode() {
        PresentationMode presentationMode = this.getPresentationMode();
        switch (this.m_presentationMode) {
            case FLAT: {
                return StructureMode.NON_RECURSIVE;
            }
            case HIERARCHICAL: 
            case MIXED: {
                return StructureMode.RECURSIVE;
            }
        }
        assert (false) : "Unhandled presentation mode: " + String.valueOf(presentationMode);
        return StructureMode.UNSPECIFIED;
    }

    protected void aboutToRestoreNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'aboutToRestoreNavigationState' must not be null";
        PresentationMode presentationModeInState = (PresentationMode)state.getConstant((IStateData)StateData.PRESENTATION_MODE);
        assert (presentationModeInState != null) : "Parameter 'presentationModeInState' of method 'aboutToRestoreNavigationState' must not be null";
        if (!this.m_presentationMode.equals((Object)presentationModeInState)) {
            this.m_presentationMode = presentationModeInState;
            this.presentationModeChanged();
        }
    }

    public List<IStandardEnumeration> getAdditionalShowInViewOptions() {
        ArrayList<IStandardEnumeration> options = new ArrayList<IStandardEnumeration>(1);
        options.add((IStandardEnumeration)this.getPresentationMode());
        return options;
    }

    protected void collectViewDataForState(Map<IStateData, Object> viewData) {
        assert (viewData != null) : "Parameter 'viewData' of method 'collectViewDataForState' must not be null";
        viewData.put(StateData.PRESENTATION_MODE, this.getPresentationMode());
        super.collectViewDataForState(viewData);
    }

    static enum StateData implements IStateData
    {
        PRESENTATION_MODE;

    }
}

