/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.markersview;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.ContextsModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.export.IExportProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.SimpleWorkbenchAuxiliaryView;
import com.hello2morrow.sonargraph.ui.standalone.markersview.MarkersViewIssueBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IContextWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewerBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class MarkersView
extends SimpleWorkbenchAuxiliaryView
implements IContextWorkbenchView {
    private PropertyTableViewer<Issue> m_issuesViewer;
    private IContextWorkbenchView.ContextAndElement<FilePath> m_currentlyDisplayed;
    private PropertyTableViewerBasedTextSearchHandler m_textSearchHandler;

    public IViewId getViewId() {
        return ViewId.MARKERS_VIEW;
    }

    public IContext getContext() {
        if (this.m_currentlyDisplayed != null) {
            return this.m_currentlyDisplayed.getContext();
        }
        return super.getContext();
    }

    protected boolean canConnect(WorkbenchView view, boolean force) {
        assert (view != null) : "Parameter 'view' of method 'canConnect' must not be null";
        IViewId viewId = view.getViewId();
        return ViewId.SOURCE_VIEW.equals((Object)viewId) || ViewId.SCRIPT_VIEW.equals((Object)viewId) || ViewId.ARCHITECTURE_FILE_VIEW.equals((Object)viewId);
    }

    protected void disconnect() {
        this.displayOrReset(null);
        super.disconnect();
    }

    protected synchronized void createViewContent(Composite viewContentArea) {
        this.m_issuesViewer = new PropertyTableViewer(viewContentArea, (BeanPropertyReader.BeanAdapter)new MarkersViewIssueBeanAdapter(), "lineNumber", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_issuesViewer.addColumn("Name", "issueName", "issueName", "issueImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_issuesViewer.addColumn("Line", "lineNumber", "lineNumber", null, 5, PropertyTableViewer.ColumnType.TEXT);
        this.m_issuesViewer.addColumn("Description", "description", "description", null, 60, PropertyTableViewer.ColumnType.TEXT);
        this.m_issuesViewer.addColumnValueMapper("lineNumber", (Object)-1, "n/a");
        this.m_issuesViewer.addColumn("Provider", "provider", "provider", null, 15, PropertyTableViewer.ColumnType.TEXT);
        this.m_textSearchHandler = new PropertyTableViewerBasedTextSearchHandler(this.m_issuesViewer, this.getViewId().getPresentationName());
        this.initialize();
        EventManager.getInstance().attach((EventHandler)new EventHandler<ContextsModifiedEvent>(ContextsModifiedEvent.class, (Object)this){

            public void handleEvent(ContextsModifiedEvent event) {
                if (MarkersView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && MarkersView.this.m_currentlyDisplayed != null && !MarkersView.this.m_currentlyDisplayed.isValid()) {
                    MarkersView.this.displayOrReset(null);
                }
            }
        });
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(ContextsModifiedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    private void refresh() {
        if (this.m_currentlyDisplayed != null) {
            this.displayOrReset(this.m_currentlyDisplayed.isValid() ? this.m_currentlyDisplayed : null);
        }
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        this.refresh();
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.ISSUE_MODIFIED)) {
            this.refresh();
        }
        super.analyzerModification(modification, analyzerId);
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.displayOrReset(null);
    }

    private FilePath getFilePath(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getFilePath' must not be null";
        if (elements.size() == 1) {
            Element element = elements.get(0);
            if (element instanceof Issue) {
                element = ((Issue)element).getAffectedElement();
            }
            if (element instanceof ParserDependency) {
                element = ((ParserDependency)element).getFrom();
            }
            if (element instanceof FilePath) {
                return (FilePath)element;
            }
            return this.getSourceForElement(element);
        }
        return null;
    }

    protected void handleSelection(WorkbenchView connectedView, List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'handleSelection' must not be null";
        FilePath filePath = this.getFilePath(elements);
        this.displayOrReset((IContextWorkbenchView.ContextAndElement<FilePath>)(filePath != null ? new IContextWorkbenchView.ContextAndElement(connectedView.getContext(), (Element)filePath) : null));
    }

    private void displayOrReset(IContextWorkbenchView.ContextAndElement<FilePath> display) {
        this.m_issuesViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_textSearchHandler.requestNewFindInfo();
        this.m_currentlyDisplayed = display;
        if (this.m_currentlyDisplayed != null) {
            this.setTitleTooltip("[" + this.getConnectedView().getViewId().getPresentationName() + " View] " + ((FilePath)this.m_currentlyDisplayed.getElement()).getPresentationName(false));
            this.m_issuesViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
            this.m_issuesViewer.showData((Collection)this.getContext().collectIssues((ElementWithIssues)this.m_currentlyDisplayed.getElement(), true));
            this.m_issuesViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            this.setTitleTooltip(null);
            this.m_issuesViewer.showData(null);
        }
        this.m_issuesViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private FilePath getSourceForElement(Element element) {
        NamedElement namedElement;
        Language usedLanguage;
        if (element instanceof NamedElement && (usedLanguage = (namedElement = (NamedElement)element).getLanguage()) != null) {
            ILanguageProvider languageProvider = this.getSoftwareSystemProvider().getLanguageProvider(usedLanguage);
            return languageProvider.getSourceFile(namedElement);
        }
        return null;
    }

    public void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        this.m_issuesViewer.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
    }

    @Override
    protected PropertyTableViewer<? extends Element> getViewer() {
        return this.m_issuesViewer;
    }

    public List<Element> getSelectedElements() {
        assert (this.m_issuesViewer != null) : "'m_issuesViewer' of method 'getSelection' must not be null";
        return SelectionProviderAdapter.getElementsFromSelection((IStructuredSelection)this.m_issuesViewer.getSelection());
    }

    public boolean supportsExcelExport() {
        return this.getSoftwareSystemProvider().hasSoftwareSystem() && this.m_issuesViewer != null && !this.m_issuesViewer.isDisposed() && !this.m_issuesViewer.getFilteredInputData().isEmpty();
    }

    public List<ExportData> getExportData(IWorkerContext workerContext) {
        return ((IExportProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IExportProvider.class)).getIssues(this.m_issuesViewer.getFilteredInputData());
    }

    public boolean supportsCopy() {
        return !this.getSelectedElements().isEmpty();
    }

    public String copy() {
        return this.m_issuesViewer.getCopyToClipboardData();
    }

    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchHandler;
    }
}

