/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.filesview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.script.DeleteGroovyScriptElementsCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.IFile;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.script.IGroovyProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.Collection;
import java.util.List;

public final class DeleteGroovyScriptElementsCommandAdapter
extends CompositeCommandAdapter {
    public CompositeCommandAdapter.Type getType() {
        return CompositeCommandAdapter.Type.DELETE;
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.DELETE_GROOVY_SCRIPT_ELEMENTS;
    }

    public CompositeCommandAdapter.Applicable applicable(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'applicable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'applicable' must not be null";
        if (!elements.isEmpty() && DeleteGroovyScriptElementsCommand.areDeletableScriptElements((ISoftwareSystemProvider)provider, elements)) {
            if (elements.size() > 1) {
                return new CompositeCommandAdapter.Applicable("Script Elements");
            }
            Element element = elements.get(0);
            if (element instanceof IFile) {
                return new CompositeCommandAdapter.Applicable(element.getPresentationKind() + " [" + ((IFile)element).getIdentifyingPath() + "]", element.getPresentationKind());
            }
            return new CompositeCommandAdapter.Applicable(elements.get(0).getPresentationKind());
        }
        return null;
    }

    public void apply(final ISoftwareSystemProvider provider, final List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'apply' must not be empty";
        DeleteGroovyScriptElementsCommand.IInteraction interaction = new DeleteGroovyScriptElementsCommand.IInteraction(){

            public boolean confirmDeletion(Collection<String> affected, boolean historyCleared) {
                if (!$assertionsDisabled && affected == null) {
                    throw new AssertionError((Object)"Parameter 'affected' of method 'confirmDeletion' must not be null");
                }
                StringBuilder message = new StringBuilder();
                message.append("Deleting scripts, run configurations and/or directories cannot be undone.");
                message.append(StringUtility.LINE_SEPARATOR).append(StringUtility.LINE_SEPARATOR);
                if (!affected.isEmpty()) {
                    String configurationFileName = ((IGroovyProvider)provider.getSoftwareSystem().getExtension(IGroovyProvider.class)).getScriptRunnerConfigurationFileName();
                    message.append("The following automated script entries will be removed from '").append(configurationFileName).append("':").append(StringUtility.LINE_SEPARATOR);
                    for (String nextAffected : affected) {
                        message.append("- ").append(nextAffected);
                        message.append(StringUtility.LINE_SEPARATOR);
                    }
                    if (historyCleared) {
                        message.append(StringUtility.LINE_SEPARATOR);
                        message.append("All history entries for '").append(configurationFileName).append("' will be cleared.").append(StringUtility.LINE_SEPARATOR);
                    }
                }
                message.append(StringUtility.LINE_SEPARATOR).append("Do you want to continue?");
                return UserInterfaceAdapter.getInstance().question(message.toString(), false) == UserInterfaceAdapter.Feedback.CONFIRMED;
            }

            public INavigationState getNavigationState() {
                return ViewNavigationManager.getInstance().getCurrentNavigationState();
            }

            public void processDeletionResult(OperationResult result) {
                UserInterfaceAdapter.getInstance().process(result);
            }

            public List<Element> getElements() {
                return elements;
            }
        };
        DeleteGroovyScriptElementsCommand cmd = new DeleteGroovyScriptElementsCommand(provider, interaction);
        UserInterfaceAdapter.getInstance().run((Command)cmd);
    }
}

