/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.ui.standalone.diffview.DiffTabFolderViewOptions;
import com.hello2morrow.sonargraph.ui.standalone.diffview.TreeViewerDeltaChangeFilter;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

final class TreeBasedViewOptions
extends DiffTabFolderViewOptions {
    private static final boolean HIDE_UNMODIFIED_ELEMENTS_DEFAULT = true;
    private final String m_hideUnmodifiedPrefKey;
    private boolean m_hideUnmodifiedElements;
    private final String m_menuLabel;
    private MenuItem m_hideUnmodifiedElementsMenu;

    public TreeBasedViewOptions(DiffTabFolderViewOptions.IViewerFilterProvider filterProvider, IEclipsePreferences preferences, String preferencesPrefix, String menuLabel, Class<?> rootElementClass) {
        super(filterProvider, preferencesPrefix, preferences, true, rootElementClass);
        assert (menuLabel != null && menuLabel.length() > 0) : "Parameter 'menuLabel' of method 'HideUnmodifiedElementViewOptions' must not be empty";
        this.m_hideUnmodifiedPrefKey = preferencesPrefix + "hideUnmodifiedElements";
        this.m_hideUnmodifiedElements = preferences.getBoolean(this.m_hideUnmodifiedPrefKey, true);
        this.m_menuLabel = menuLabel;
    }

    @Override
    protected void createAdditionalMenuItems(Menu menu) {
        this.m_hideUnmodifiedElementsMenu = new MenuItem(menu, 32);
        this.m_hideUnmodifiedElementsMenu.setText(this.m_menuLabel);
        this.m_hideUnmodifiedElementsMenu.setImage(UiResourceManager.getInstance().getImage("IssueDiffUnmodified"));
        this.m_hideUnmodifiedElementsMenu.setSelection(this.m_hideUnmodifiedElements);
        this.m_hideUnmodifiedElementsMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TreeBasedViewOptions.this.m_hideUnmodifiedElementsMenu.getSelection() != TreeBasedViewOptions.this.m_hideUnmodifiedElements) {
                    TreeBasedViewOptions.this.m_hideUnmodifiedElements = TreeBasedViewOptions.this.m_hideUnmodifiedElementsMenu.getSelection();
                    TreeBasedViewOptions.this.updateFilters();
                }
            }
        });
    }

    @Override
    protected void updateCustomFilters(List<ViewerFilter> filters, IEclipsePreferences preferences) {
        assert (filters != null) : "Parameter 'filters' of method 'updateCustomFilters' must not be null";
        assert (preferences != null) : "Parameter 'preferences' of method 'updateCustomFilters' must not be null";
        TreeViewerDeltaChangeFilter unmodifiedFilter = filters.stream().filter(f -> f instanceof TreeViewerDeltaChangeFilter).map(f -> (TreeViewerDeltaChangeFilter)((Object)f)).filter(f -> f.getChangeToHide() == IDiffElement.Change.UNMODIFIED).findFirst().orElse(null);
        if (this.m_hideUnmodifiedElements) {
            if (unmodifiedFilter == null) {
                filters.add(new TreeViewerDeltaChangeFilter(IDiffElement.Change.UNMODIFIED));
            }
        } else if (unmodifiedFilter != null) {
            filters.remove((Object)unmodifiedFilter);
        }
        preferences.putBoolean(this.m_hideUnmodifiedPrefKey, this.m_hideUnmodifiedElements);
    }

    @Override
    protected void handleDefaultMenuItemSelection() {
        this.m_hideUnmodifiedElements = true;
        this.m_hideUnmodifiedElementsMenu.setSelection(false);
    }
}

