/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.diff.DeleteLocalBaselineConfigurationCommand;
import com.hello2morrow.sonargraph.core.command.system.diff.EnableBaselineCommand;
import com.hello2morrow.sonargraph.core.command.system.diff.SetBaselineCommand;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffConfiguration;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ui.standalone.analyzersview.DeleteAnalyzerConfigurationCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class SystemDiffViewConfiguration
extends Composite {
    private static final String SYSTEM_BASELINE = "System Baseline";
    private static final String LOCAL_BASELINE = "Local Baseline";
    private static final String ACTIVE = " (Active)";
    private static final String INACTIVE = " (Inactive)";
    private final CTabItem m_tabItem;
    private final Composite m_content;
    private TFile m_systemBaselineFile;
    private final Group m_systemGroup;
    private final Text m_systemFile;
    private final Text m_systemDescription;
    private final Label m_systemTimestamp;
    private final Button m_systemEnabled;
    private final Button m_systemActivate;
    private final Button m_systemDelete;
    private TFile m_localBaselineFile;
    private final Group m_localGroup;
    private final Text m_localFile;
    private final Text m_localDescription;
    private final Label m_localTimestamp;
    private final Button m_localEnabled;
    private final Button m_localActivate;
    private final Button m_localDelete;

    SystemDiffViewConfiguration(CTabFolder parent) {
        super((Composite)parent, 0);
        this.m_content = new Composite((Composite)parent, 0);
        this.m_tabItem = new CTabItem(parent, 0);
        this.m_tabItem.setText("Configuration");
        this.m_tabItem.setImage(UiResourceManager.getInstance().getImage("SoftwareSystemConfiguration"));
        this.m_tabItem.setControl((Control)this.m_content);
        this.m_content.setLayout((Layout)new GridLayout(1, false));
        this.m_systemGroup = new Group(this.m_content, 0);
        this.m_systemGroup.setText(SYSTEM_BASELINE);
        this.m_systemGroup.setToolTipText("A system baseline is meant to be useful for all Sonargraph users and clients and is usually located within the software system's baselines directory and committed into the version control system.");
        this.m_systemGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_systemGroup.setLayout((Layout)new GridLayout(3, false));
        Label systemBaselineLabel = new Label((Composite)this.m_systemGroup, 0);
        systemBaselineLabel.setText("File:");
        systemBaselineLabel.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_systemFile = new Text((Composite)this.m_systemGroup, 64);
        this.m_systemFile.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.m_systemFile.setText("");
        this.m_systemFile.setEditable(false);
        Label labelSystemContext = new Label((Composite)this.m_systemGroup, 0);
        labelSystemContext.setText("Description:");
        labelSystemContext.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_systemDescription = new Text((Composite)this.m_systemGroup, 64);
        this.m_systemDescription.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.m_systemDescription.setText("");
        this.m_systemDescription.setEditable(false);
        Label labelSystemBaselineTimestamp = new Label((Composite)this.m_systemGroup, 0);
        labelSystemBaselineTimestamp.setText("Timestamp:");
        labelSystemBaselineTimestamp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_systemTimestamp = new Label((Composite)this.m_systemGroup, 0);
        this.m_systemTimestamp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.m_systemTimestamp.setText("");
        Label labelSystemBaselineEnabledValue = new Label((Composite)this.m_systemGroup, 0);
        labelSystemBaselineEnabledValue.setText("Enabled:");
        labelSystemBaselineEnabledValue.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_systemEnabled = new Button((Composite)this.m_systemGroup, 32);
        this.m_systemEnabled.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.m_systemEnabled.setSelection(false);
        this.m_systemEnabled.setEnabled(false);
        this.m_systemEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemDiffViewConfiguration.this.enableBaseline(BaselineType.SYSTEM, SystemDiffViewConfiguration.this.m_systemEnabled.getSelection());
            }
        });
        new Label((Composite)this.m_systemGroup, 0);
        this.m_systemActivate = new Button((Composite)this.m_systemGroup, 0x800008);
        this.m_systemActivate.setImage(UiResourceManager.getInstance().getImage("ActivateBaseline"));
        this.m_systemActivate.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_systemActivate.setToolTipText("Activate system baseline");
        this.m_systemActivate.setEnabled(false);
        this.m_systemActivate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemDiffViewConfiguration.this.activateBaseline(SystemDiffViewConfiguration.this.m_systemBaselineFile, BaselineType.SYSTEM);
            }
        });
        this.m_systemDelete = new Button((Composite)this.m_systemGroup, 0x800008);
        this.m_systemDelete.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_systemDelete.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_systemDelete.setToolTipText("Delete system baseline entry (deletes System Diff analyzer configuration file)");
        this.m_systemDelete.setEnabled(false);
        this.m_systemDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemDiffViewConfiguration.this.deleteSystemBaselineConfiguration();
            }
        });
        this.m_localGroup = new Group(this.m_content, 0);
        this.m_localGroup.setText(LOCAL_BASELINE);
        this.m_localGroup.setToolTipText("A local baseline is normally only useful for this machine. It is not necessarily located within the software system's baselines directory and not necessarily committed into the version control system.");
        this.m_localGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_localGroup.setLayout((Layout)new GridLayout(3, false));
        Label labelLocalBaseline = new Label((Composite)this.m_localGroup, 0);
        labelLocalBaseline.setText("File:");
        labelLocalBaseline.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_localFile = new Text((Composite)this.m_localGroup, 64);
        this.m_localFile.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.m_localFile.setText("");
        this.m_localFile.setEditable(false);
        Label localLabelContext = new Label((Composite)this.m_localGroup, 0);
        localLabelContext.setText("Description:");
        localLabelContext.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_localDescription = new Text((Composite)this.m_localGroup, 64);
        this.m_localDescription.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.m_localDescription.setText("");
        this.m_localDescription.setEditable(false);
        Label labelLocalBaselineTimestamp = new Label((Composite)this.m_localGroup, 0);
        labelLocalBaselineTimestamp.setText("Timestamp:");
        labelLocalBaselineTimestamp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_localTimestamp = new Label((Composite)this.m_localGroup, 0);
        this.m_localTimestamp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.m_localTimestamp.setText("");
        Label labelLocalBaselineEnabledValue = new Label((Composite)this.m_localGroup, 0);
        labelLocalBaselineEnabledValue.setText("Enabled:");
        labelLocalBaselineEnabledValue.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_localEnabled = new Button((Composite)this.m_localGroup, 32);
        this.m_localEnabled.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.m_localEnabled.setSelection(false);
        this.m_localEnabled.setEnabled(false);
        this.m_localEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemDiffViewConfiguration.this.enableBaseline(BaselineType.LOCAL, SystemDiffViewConfiguration.this.m_localEnabled.getSelection());
            }
        });
        new Label((Composite)this.m_localGroup, 0);
        this.m_localActivate = new Button((Composite)this.m_localGroup, 0x800008);
        this.m_localActivate.setImage(UiResourceManager.getInstance().getImage("ActivateBaseline"));
        this.m_localActivate.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_localActivate.setToolTipText("Activate local baseline");
        this.m_localActivate.setEnabled(false);
        this.m_localActivate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemDiffViewConfiguration.this.activateBaseline(SystemDiffViewConfiguration.this.m_localBaselineFile, BaselineType.LOCAL);
            }
        });
        this.m_localDelete = new Button((Composite)this.m_localGroup, 0x800008);
        this.m_localDelete.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_localDelete.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_localDelete.setToolTipText("Delete local baseline entry");
        this.m_localDelete.setEnabled(false);
        this.m_localDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemDiffViewConfiguration.this.deleteLocalBaselineConfiguration();
            }
        });
    }

    CTabItem getTabItem() {
        return this.m_tabItem;
    }

    Control getControl() {
        return this.m_tabItem.getControl();
    }

    private void activateBaseline(final TFile baseline, final BaselineType type) {
        assert (baseline != null) : "Parameter 'baseline' of method 'activateBaseline' must not be null";
        assert (type != null) : "Parameter 'type' of method 'activateBaseline' must not be null";
        SetBaselineCommand setBaseline = new SetBaselineCommand(WorkbenchRegistry.getInstance().getProvider(), new SetBaselineCommand.SetBaselineCommandInteraction(){

            public boolean collect(SetBaselineCommand.SetBaselineInteractionData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setData(type, baseline);
                return true;
            }

            public void processResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processResult' must not be null");
                }
                if (result.isFailure()) {
                    UserInterfaceAdapter.getInstance().process(result);
                }
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)setBaseline);
    }

    private void enableBaseline(final BaselineType baselineType, final boolean enable) {
        assert (baselineType != null) : "Parameter 'baselineType' of method 'enableBaseline' must not be null";
        EnableBaselineCommand command = new EnableBaselineCommand(WorkbenchRegistry.getInstance().getProvider(), new EnableBaselineCommand.EnableBaselineCommandInteraction(){

            public boolean collect(EnableBaselineCommand.EnableBaselineInteractionData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setData(baselineType, enable);
                return true;
            }

            public void processResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processResult' must not be null");
                }
                if (result.isFailure()) {
                    UserInterfaceAdapter.getInstance().process(result);
                }
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)command);
    }

    private void deleteSystemBaselineConfiguration() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        DeleteAnalyzerConfigurationCommandAdapter.perform(WorkbenchRegistry.getInstance().getProvider(), ((ISystemDiffProvider)provider.getSoftwareSystem().getExtension(ISystemDiffProvider.class)).getSystemDiffAnalyzerConfigurationFile());
    }

    private void deleteLocalBaselineConfiguration() {
        String question = "This will delete the local baseline entry in the system properties in the hidden data directory.\nThis cannot be undone. Continue?";
        if (UserInterfaceAdapter.getInstance().question("This will delete the local baseline entry in the system properties in the hidden data directory.\nThis cannot be undone. Continue?", false) == UserInterfaceAdapter.Feedback.CONFIRMED) {
            DeleteLocalBaselineConfigurationCommand command = new DeleteLocalBaselineConfigurationCommand(WorkbenchRegistry.getInstance().getProvider(), new DeleteLocalBaselineConfigurationCommand.DeleteBaselineConfigurationCommandInteraction(){

                public void processResult(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processResult' must not be null");
                    }
                    if (result.isFailure()) {
                        UserInterfaceAdapter.getInstance().process(result);
                    }
                }
            });
            UserInterfaceAdapter.getInstance().run((Command)command);
        }
    }

    void show(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'show' must not be null";
        ISystemDiffProvider diffProvider = (ISystemDiffProvider)softwareSystem.getExtension(ISystemDiffProvider.class);
        SystemDiffConfiguration diffConfiguration = diffProvider.getSystemDiffConfiguration();
        BaselineType baselineType = diffConfiguration.getBaselineType();
        TFile systemBaseline = diffConfiguration.getSystemBaseline();
        if (systemBaseline != null) {
            this.m_systemBaselineFile = systemBaseline;
            String relPath = FileUtility.calculateRelativePath((TFile)this.m_systemBaselineFile, (TFile)softwareSystem.getSystemDirectoryFile());
            String absPath = FileUtility.getCanonicalFilePath((TFile)this.m_systemBaselineFile);
            this.m_systemFile.setText(relPath);
            this.m_systemFile.setToolTipText(absPath);
            List systemIssues = diffProvider.getSystemBaselineNotAccessibleIssues();
            if (!systemIssues.isEmpty()) {
                this.m_localDescription.setText("Baseline not accessible (see tooltip for details)!");
                StringBuilder builder = new StringBuilder();
                for (Issue next : systemIssues) {
                    builder.append(next.getDescription()).append("\n");
                }
                builder.deleteCharAt(builder.length() - 1);
                this.m_systemDescription.setToolTipText(builder.toString());
                this.m_systemTimestamp.setText("");
            } else {
                OperationResultWithOutcome systemBaselineInfoResult = diffProvider.getBaselineInfo(this.m_systemBaselineFile);
                if (systemBaselineInfoResult.isSuccess()) {
                    BaselineInfo systemBaselineInfo = (BaselineInfo)systemBaselineInfoResult.getOutcome();
                    this.m_systemDescription.setText(systemBaselineInfo.getDescription());
                    this.m_systemTimestamp.setText(Iso8601DateFormat.formatDateAndTime((Date)systemBaselineInfo.getCreationTime()));
                } else {
                    this.m_systemDescription.setText("");
                    this.m_systemTimestamp.setText("");
                }
                this.m_systemDescription.setToolTipText(null);
            }
            this.m_systemEnabled.setSelection(diffConfiguration.isSystemBaselineEnabled());
            this.m_systemEnabled.setEnabled(true);
            boolean isSystemBaselineActive = baselineType != null && baselineType == BaselineType.SYSTEM;
            this.m_systemGroup.setText(SYSTEM_BASELINE + (isSystemBaselineActive ? ACTIVE : INACTIVE));
            this.m_systemGroup.setFont(isSystemBaselineActive ? UiResourceManager.getInstance().getFont(1) : UiResourceManager.getInstance().getFont(0));
            this.m_systemActivate.setEnabled(!isSystemBaselineActive);
            this.m_systemDelete.setEnabled(true);
        } else {
            this.m_systemBaselineFile = null;
            this.m_systemGroup.setText(SYSTEM_BASELINE);
            this.m_systemGroup.setFont(UiResourceManager.getInstance().getFont(0));
            this.m_systemFile.setText("");
            this.m_systemFile.setToolTipText(null);
            this.m_systemDescription.setText("");
            this.m_systemDescription.setToolTipText(null);
            this.m_systemTimestamp.setText("");
            this.m_systemEnabled.setSelection(false);
            this.m_systemEnabled.setEnabled(false);
            this.m_systemActivate.setEnabled(false);
            this.m_systemDelete.setEnabled(false);
        }
        TFile localBaseline = diffConfiguration.getLocalBaseline();
        if (localBaseline != null) {
            this.m_localBaselineFile = localBaseline;
            String relPath = FileUtility.calculateRelativePath((TFile)this.m_localBaselineFile, (TFile)softwareSystem.getSystemDirectoryFile());
            String absPath = FileUtility.getCanonicalFilePath((TFile)this.m_localBaselineFile);
            this.m_localFile.setText(relPath);
            this.m_localFile.setToolTipText(absPath);
            List localIssues = diffProvider.getLocalBaselineNotAccessibleIssues();
            if (!localIssues.isEmpty()) {
                this.m_localDescription.setText("Baseline not accessible (see tooltip for details)!");
                StringBuilder builder = new StringBuilder();
                for (Issue next : localIssues) {
                    builder.append(next.getDescription()).append("\n");
                }
                builder.deleteCharAt(builder.length() - 1);
                this.m_localDescription.setToolTipText(builder.toString());
                this.m_localTimestamp.setText("");
            } else {
                OperationResultWithOutcome localBaselineInfoResult = diffProvider.getBaselineInfo(this.m_localBaselineFile);
                if (localBaselineInfoResult.isSuccess()) {
                    BaselineInfo localBaselineInfo = (BaselineInfo)localBaselineInfoResult.getOutcome();
                    this.m_localDescription.setText(localBaselineInfo.getDescription());
                    this.m_localTimestamp.setText(Iso8601DateFormat.formatDateAndTime((Date)localBaselineInfo.getCreationTime()));
                } else {
                    this.m_localDescription.setText("");
                    this.m_localTimestamp.setText("");
                }
                this.m_localDescription.setToolTipText(null);
            }
            this.m_localEnabled.setSelection(diffConfiguration.isLocalBaselineEnabled());
            this.m_localEnabled.setEnabled(true);
            boolean isLocalBaselineActive = baselineType != null && baselineType == BaselineType.LOCAL;
            this.m_localGroup.setText(LOCAL_BASELINE + (isLocalBaselineActive ? ACTIVE : INACTIVE));
            this.m_localGroup.setFont(isLocalBaselineActive ? UiResourceManager.getInstance().getFont(1) : UiResourceManager.getInstance().getFont(0));
            this.m_localActivate.setEnabled(!isLocalBaselineActive);
            this.m_localDelete.setEnabled(true);
        } else {
            this.m_localBaselineFile = null;
            this.m_localGroup.setText(LOCAL_BASELINE);
            this.m_localGroup.setFont(UiResourceManager.getInstance().getFont(0));
            this.m_localFile.setText("");
            this.m_localFile.setToolTipText(null);
            this.m_localDescription.setText("");
            this.m_localDescription.setToolTipText(null);
            this.m_localTimestamp.setText("");
            this.m_localEnabled.setSelection(false);
            this.m_localEnabled.setEnabled(false);
            this.m_localActivate.setEnabled(false);
            this.m_localDelete.setEnabled(false);
        }
        this.m_content.layout(true, true);
        this.m_content.getParent().layout(true, true);
    }

    void clear() {
        this.m_systemBaselineFile = null;
        this.m_systemGroup.setText(SYSTEM_BASELINE);
        this.m_systemGroup.setFont(UiResourceManager.getInstance().getFont(0));
        this.m_systemFile.setText("");
        this.m_systemDescription.setText("");
        this.m_systemTimestamp.setText("");
        this.m_systemEnabled.setSelection(false);
        this.m_systemEnabled.setEnabled(false);
        this.m_systemActivate.setEnabled(false);
        this.m_systemDelete.setEnabled(false);
        this.m_localBaselineFile = null;
        this.m_localGroup.setText(LOCAL_BASELINE);
        this.m_localGroup.setFont(UiResourceManager.getInstance().getFont(0));
        this.m_localFile.setText("");
        this.m_localFile.setToolTipText(null);
        this.m_localDescription.setText("");
        this.m_localTimestamp.setText("");
        this.m_localEnabled.setSelection(false);
        this.m_localEnabled.setEnabled(false);
        this.m_localActivate.setEnabled(false);
        this.m_localDelete.setEnabled(false);
        this.m_systemFile.requestLayout();
        this.m_systemDescription.requestLayout();
        this.m_localFile.requestLayout();
        this.m_localDescription.requestLayout();
        this.m_content.layout(true, true);
        this.m_content.getParent().layout(true, true);
    }
}

