/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricValueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.ui.standalone.diffview.AbstractTableViewerBasedDiffTab;
import com.hello2morrow.sonargraph.ui.standalone.diffview.MetricValueDiffBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;

final class MetricValueDiffTab
extends AbstractTableViewerBasedDiffTab<MetricValueDiff> {
    protected MetricValueDiffTab(CTabFolder parent) {
        super(parent, "System Metrics", "Metrics", "metricName");
        PropertyTableViewer tableViewer = this.getPropertyTableViewer();
        tableViewer.addColumn("Metric", "metricName", "metricName", "image", 200, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Categories", "category", "category", null, 200, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Change", "change", "change", "changeImage", 150, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Value Diff", "valueDiffAbsolute", "valueDiffAbsolute", null, 150, PropertyTableViewer.ColumnType.NUMBER);
        tableViewer.addColumn("Value Diff (%)", "valueDiffRelative", "valueDiffRelative", null, 150, PropertyTableViewer.ColumnType.NUMBER);
        tableViewer.addColumn("Details", "changeDetails", "changeDetails", null, 350, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.setCellColorProvider((PropertyTableViewer.ICellColorProvider)new PropertyTableViewer.ICellColorProvider<MetricValueDiff>(){

            public Color getCellColor(PropertyTableViewer<MetricValueDiff> viewer, MetricValueDiff object, String propertyName) {
                return null;
            }

            public Color getForeground(PropertyTableViewer<MetricValueDiff> viewer, MetricValueDiff diff, String propertyName) {
                Number valueDiff;
                if (propertyName.equals("valueDiffAbsolute")) {
                    valueDiff = diff.getValueDiffAbsolute();
                } else if (propertyName.equals("valueDiffRelative")) {
                    valueDiff = diff.getValueDiffRelative();
                } else {
                    return null;
                }
                if (valueDiff == null) {
                    return null;
                }
                float roundedDiff = Math.abs(valueDiff.floatValue());
                if (Float.compare(roundedDiff, 0.01f) < 0) {
                    return null;
                }
                switch (diff.getChange()) {
                    case ADDED: 
                    case MODIFIED: 
                    case RESOLUTION_ADDED: 
                    case RESOLUTION_REMOVED: 
                    case REMOVED: 
                    case UNMODIFIED: {
                        return null;
                    }
                    case IMPROVED: {
                        return UiResourceManager.getInstance().getColor(UiResourceManager.GREEN);
                    }
                    case WORSENED: {
                        return UiResourceManager.getInstance().getColor(UiResourceManager.RED);
                    }
                }
                return null;
            }
        });
    }

    MetricValueDiffBeanAdapter createBeanAdapter() {
        return new MetricValueDiffBeanAdapter();
    }

    @Override
    void show(SoftwareSystemDiff systemDiff) {
        assert (systemDiff != null) : "Parameter 'systemDiff' of method 'show' must not be null";
        MetricsDiff metricsDiff = (MetricsDiff)systemDiff.getUniqueExistingChild(MetricsDiff.class);
        List metricDiffs = metricsDiff.getChildren(MetricValueDiff.class).stream().filter(d -> d.getChange() != IDiffElement.Change.UNMODIFIED).collect(Collectors.toList());
        this.getPropertyTableViewer().showData(metricDiffs);
        this.setExclamationMarkInTabTitle(metricsDiff.getChange() != IDiffElement.Change.UNMODIFIED);
    }
}

