/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssuesDiff;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.diffview.AbstractTableViewerBasedDiffTab;
import com.hello2morrow.sonargraph.ui.standalone.diffview.DiffTabFolderViewOptions;
import com.hello2morrow.sonargraph.ui.standalone.diffview.IssueDiffBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.AggregatingViewerFilter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;

final class IssueDiffTab
extends AbstractTableViewerBasedDiffTab<IIssueDiff>
implements DiffTabFolderViewOptions.IViewerFilterProvider {
    private static final String PREFERENCES_PREFIX = "issueDiffTab.";
    private final DiffTabFolderViewOptions m_tabFolderViewOptions;

    public IssueDiffTab(CTabFolder parent, IEclipsePreferences preferences) {
        super(parent, "Issues", "Issue", "change");
        assert (preferences != null) : "Parameter 'preferences' of method 'IssueDiffTab' must not be null";
        PropertyTableViewer tableViewer = this.getPropertyTableViewer();
        tableViewer.addColumn("Issue", "issuePresentationName", "issuePresentationName", "issueImage", 200, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Severity", "severity", "severity", "severityImage", 100, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Category", "issueCategory", "issueCategory", null, 150, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Element", "elementOrFrom", "elementOrFrom", "elementOrFromImage", 200, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Change", "change", "change", "changeImage", 150, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Details", "changeDetails", "changeDetails", null, 350, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Provider", "provider", "provider", null, 150, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Resolution", "resolution", "resolution", "resolutionImage", 120, PropertyTableViewer.ColumnType.TEXT);
        this.m_tabFolderViewOptions = new DiffTabFolderViewOptions(this, PREFERENCES_PREFIX, preferences, false, IIssueDiff.class);
    }

    @Override
    void show(SoftwareSystemDiff systemDiff) {
        IssuesDiff issuesDiff = (IssuesDiff)systemDiff.getUniqueExistingChild(IssuesDiff.class);
        this.getPropertyTableViewer().showData((Collection)issuesDiff.getChildren(IIssueDiff.class).stream().filter(i -> i.getChange() != IDiffElement.Change.UNMODIFIED).collect(Collectors.toList()));
        this.setExclamationMarkInTabTitle(issuesDiff.getChange() != IDiffElement.Change.UNMODIFIED);
        this.m_tabFolderViewOptions.updateFilters();
    }

    @Override
    BeanPropertyReader.BeanAdapter<IIssueDiff> createBeanAdapter() {
        return new IssueDiffBeanAdapter();
    }

    @Override
    public DiffTabFolderViewOptions getViewOptions() {
        return this.m_tabFolderViewOptions;
    }

    @Override
    public List<ViewerFilter> getFilters() {
        return Arrays.asList(this.getPropertyTableViewer().getFilters());
    }

    @Override
    public void setFilters(AggregatingViewerFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'setFilters' must not be null";
        PropertyTableViewer viewer = this.getPropertyTableViewer();
        viewer.setFilters(filter.getFilters().toArray(new ViewerFilter[0]));
    }
}

