/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DependencyIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.NamedElementIssueDiff;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.diffview.IssueDiffResourceProvider;
import com.hello2morrow.sonargraph.ui.standalone.issuesview.IssueBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.Image;

public final class IssueDiffBeanAdapter
extends BeanPropertyReader.BeanAdapter<IIssueDiff> {
    private IIssueDiff m_issueDiff;

    protected void setAdaptedObject(IIssueDiff issueDiff) {
        this.m_issueDiff = issueDiff;
    }

    public String getIssuePresentationName() {
        return IssueDiffBeanAdapter.getIssuePresentationName(this.m_issueDiff);
    }

    public static String getIssuePresentationName(IIssueDiff issueDiff) {
        assert (issueDiff != null) : "Parameter 'issueDiff' of method 'getIssuePresentationName' must not be null";
        return issueDiff.getPresentationName(true);
    }

    public Image getIssueImage() {
        return IssueDiffBeanAdapter.getIssueImage(this.m_issueDiff);
    }

    public static Image getIssueImage(IIssueDiff issueDiff) {
        assert (issueDiff != null) : "Parameter 'issueDiff' of method 'getIssueImage' must not be null";
        if (issueDiff instanceof NamedElementIssueDiff) {
            return UiResourceManager.getInstance().getImage("ElementIssue");
        }
        if (issueDiff instanceof DependencyIssueDiff) {
            return UiResourceManager.getInstance().getImage("DependencyIssue");
        }
        if (issueDiff instanceof CycleGroupIssueDiff) {
            return UiResourceManager.getInstance().getImage("CycleGroup");
        }
        if (issueDiff instanceof DuplicateCodeBlockIssueDiff) {
            return UiResourceManager.getInstance().getImage("DuplicateCodeBlock");
        }
        assert (false) : "Unexpected class: " + issueDiff.getClass().getName();
        return null;
    }

    public String getChange() {
        return IssueDiffBeanAdapter.getChange(this.m_issueDiff);
    }

    public static String getChange(IIssueDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getChange' must not be null";
        return diff.getChange().getPresentationName();
    }

    public Image getChangeImage() {
        return IssueDiffBeanAdapter.getChangeImage(this.m_issueDiff);
    }

    public static Image getChangeImage(IIssueDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getChangeImage' must not be null";
        switch (diff.getChange()) {
            case RESOLUTION_ADDED: 
            case RESOLUTION_REMOVED: {
                return IssueDiffResourceProvider.getInstance().getChangeImage(diff.getChange());
            }
        }
        String imageResourceName = "IssueDiff" + diff.getChange().getPresentationName();
        return UiResourceManager.getInstance().getImage(imageResourceName);
    }

    public String getSeverity() {
        return IssueDiffBeanAdapter.getSeverity(this.m_issueDiff);
    }

    public static String getSeverity(IIssueDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getSeverity' must not be null";
        return diff.getSeverity().getPresentationName();
    }

    public Image getSeverityImage() {
        return IssueDiffBeanAdapter.getSeverityImage(this.m_issueDiff);
    }

    public static Image getSeverityImage(IIssueDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getSeverityImage' must not be null";
        return IssueBeanAdapter.getImage(diff.getSeverity());
    }

    public String getIssueCategory() {
        return IssueDiffBeanAdapter.getIssueCategory(this.m_issueDiff);
    }

    public static String getIssueCategory(IIssueDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getIssueCategory' must not be null";
        return diff.getIssueCategoryPresentationName();
    }

    public String getElementOrFrom() {
        return IssueDiffBeanAdapter.getElementOrFrom(this.m_issueDiff);
    }

    public static String getElementOrFrom(IIssueDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getElementOrFrom' must not be null";
        return diff.getAffectedElementPresentationName(true);
    }

    public String getChangeDetails() {
        return IssueDiffBeanAdapter.getChangeDetails(this.m_issueDiff);
    }

    public static String getChangeDetails(IIssueDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getChangeDetails' must not be null";
        return diff.getChangeDescription();
    }

    public Image getElementOrFromImage() {
        return IssueDiffBeanAdapter.getElementOrFromImage(this.m_issueDiff);
    }

    public static Image getElementOrFromImage(IIssueDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getElementOrFromImage' must not be null";
        return IssueDiffResourceProvider.getInstance().getImage(diff);
    }

    public String getElementOrFromTooltip() {
        return IssueDiffBeanAdapter.getElementOrFromTooltip(this.m_issueDiff);
    }

    public static String getElementOrFromTooltip(IIssueDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getElementOrFromTooltip' must not be null";
        return diff.getAffectedElementPresentationName(false);
    }

    public String getProvider() {
        return IssueDiffBeanAdapter.getProvider(this.m_issueDiff);
    }

    public static String getProvider(IIssueDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getProvider' must not be null";
        return diff.getProviderPresentationName();
    }

    public String getResolution() {
        if (this.m_issueDiff.getCurrent() != null) {
            IResolution resolution = this.m_issueDiff.getCurrent().getResolution();
            if (resolution != null) {
                return ((Resolution)resolution).getKind().getPresentationName();
            }
        } else if (this.m_issueDiff.getBaseline().hasResolution()) {
            return this.m_issueDiff.getBaseline().getResolutionType().getPresentationName();
        }
        return "None";
    }

    public Image getResolutionImage() {
        String imageResourceName = "None";
        if (this.m_issueDiff.getCurrent() != null) {
            IResolution resolution = this.m_issueDiff.getCurrent().getResolution();
            if (resolution != null) {
                imageResourceName = resolution.getImageResourceName();
            }
        } else if (this.m_issueDiff.getBaseline().hasResolution()) {
            imageResourceName = this.m_issueDiff.getBaseline().getResolutionType().getPresentationName();
        }
        return UiResourceManager.getInstance().getImage(imageResourceName);
    }
}

