/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockOccurrenceDiff;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

final class DuplicatesDiffBasedViewerComparator
extends ViewerComparator {
    private Sort m_sort = Sort.BLOCK_LENGTH;
    private boolean m_ascending = true;

    DuplicatesDiffBasedViewerComparator() {
    }

    public void setSort(Sort sort) {
        assert (sort != null) : "Parameter 'sort' of method 'setSort' must not be null";
        if (this.m_sort.equals((Object)sort)) {
            this.m_ascending = !this.m_ascending;
        } else {
            this.m_sort = sort;
        }
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        assert (viewer != null) : "Parameter 'viewer' of method 'compare' must not be null";
        assert (o1 != null && o1 instanceof NamedElement) : "Unexpected class in method 'compare': " + String.valueOf(o1);
        assert (o2 != null && o2 instanceof NamedElement) : "Unexpected class in method 'compare': " + String.valueOf(o2);
        NamedElement namedElement1 = (NamedElement)o1;
        NamedElement namedElement2 = (NamedElement)o2;
        assert (namedElement1 != namedElement2) : "Same elements";
        int result = -1;
        switch (this.m_sort) {
            case NAME: {
                if (namedElement1 instanceof DuplicateCodeBlockOccurrenceDiff && namedElement2 instanceof DuplicateCodeBlockOccurrenceDiff) {
                    DuplicateCodeBlockOccurrenceDiff occ1 = (DuplicateCodeBlockOccurrenceDiff)namedElement1;
                    DuplicateCodeBlockOccurrenceDiff occ2 = (DuplicateCodeBlockOccurrenceDiff)namedElement2;
                    result = occ1.getIdentifyingPath().compareTo(occ2.getIdentifyingPath());
                    if (result == 0) {
                        result = Integer.compare(occ1.getBlockStart(), occ2.getBlockStart());
                    }
                }
                result = this.compareName(namedElement1, namedElement2);
                break;
            }
            case OCCURRENCES: {
                if (!(namedElement1 instanceof DuplicateCodeBlockIssueDiff) || !(namedElement2 instanceof DuplicateCodeBlockIssueDiff)) break;
                DuplicateCodeBlockIssueDiff duplicate1 = (DuplicateCodeBlockIssueDiff)namedElement1;
                DuplicateCodeBlockIssueDiff duplicate2 = (DuplicateCodeBlockIssueDiff)namedElement2;
                result = Integer.compare(duplicate1.getNumberOfOccurrences(), duplicate2.getNumberOfOccurrences());
                if (result == 0) {
                    result = this.compareName((NamedElement)duplicate1, (NamedElement)duplicate2);
                }
                return result;
            }
            case CHANGE: {
                if (namedElement1 instanceof DuplicateCodeBlockIssueDiff && namedElement2 instanceof DuplicateCodeBlockIssueDiff) {
                    DuplicateCodeBlockIssueDiff duplicate1 = (DuplicateCodeBlockIssueDiff)namedElement1;
                    DuplicateCodeBlockIssueDiff duplicate2 = (DuplicateCodeBlockIssueDiff)namedElement2;
                    result = Integer.compare(duplicate1.getChange().ordinal(), duplicate2.getChange().ordinal());
                    if (result == 0) {
                        result = this.compareName((NamedElement)duplicate1, (NamedElement)duplicate2);
                    }
                    return result;
                }
                if (!(namedElement1 instanceof DuplicateCodeBlockOccurrenceDiff) || !(namedElement2 instanceof DuplicateCodeBlockOccurrenceDiff)) break;
                DuplicateCodeBlockOccurrenceDiff occ1 = (DuplicateCodeBlockOccurrenceDiff)namedElement1;
                DuplicateCodeBlockOccurrenceDiff occ2 = (DuplicateCodeBlockOccurrenceDiff)namedElement2;
                result = Integer.compare(occ1.getChange().ordinal(), occ2.getChange().ordinal());
                if (result != 0) break;
                result = this.compareName((NamedElement)occ1, (NamedElement)occ1);
                break;
            }
            case DETAILS: {
                IDiffElement diff1 = (IDiffElement)namedElement1;
                IDiffElement diff2 = (IDiffElement)namedElement2;
                result = diff1.getChangeDescription().compareTo(diff2.getChangeDescription());
                break;
            }
            case RANGE: {
                if (!(namedElement1 instanceof DuplicateCodeBlockOccurrenceDiff) || !(namedElement2 instanceof DuplicateCodeBlockOccurrenceDiff)) break;
                DuplicateCodeBlockOccurrenceDiff occ1 = (DuplicateCodeBlockOccurrenceDiff)namedElement1;
                DuplicateCodeBlockOccurrenceDiff occ2 = (DuplicateCodeBlockOccurrenceDiff)namedElement2;
                result = Integer.compare(occ1.getBlockStart(), occ2.getBlockStart());
                break;
            }
            case BLOCK_LENGTH: {
                if (namedElement1 instanceof DuplicateCodeBlockIssueDiff && namedElement2 instanceof DuplicateCodeBlockIssueDiff) {
                    DuplicateCodeBlockIssueDiff duplicate1 = (DuplicateCodeBlockIssueDiff)namedElement1;
                    DuplicateCodeBlockIssueDiff duplicate2 = (DuplicateCodeBlockIssueDiff)namedElement2;
                    result = Integer.compare(duplicate1.getBlockSize(), duplicate2.getBlockSize());
                    if (result != 0) break;
                    result = this.compareName((NamedElement)duplicate1, (NamedElement)duplicate2);
                    break;
                }
                if (!(namedElement1 instanceof DuplicateCodeBlockOccurrenceDiff) || !(namedElement2 instanceof DuplicateCodeBlockOccurrenceDiff)) break;
                DuplicateCodeBlockOccurrenceDiff occ1 = (DuplicateCodeBlockOccurrenceDiff)namedElement1;
                DuplicateCodeBlockOccurrenceDiff occ2 = (DuplicateCodeBlockOccurrenceDiff)namedElement2;
                result = Integer.compare(occ1.getBlockSize(), occ2.getBlockSize());
                if (result != 0) break;
                result = this.compareName((NamedElement)occ1, (NamedElement)occ1);
                break;
            }
            case TOLERANCE: {
                if (!(namedElement1 instanceof DuplicateCodeBlockOccurrenceDiff) || !(namedElement2 instanceof DuplicateCodeBlockOccurrenceDiff)) break;
                DuplicateCodeBlockOccurrenceDiff occ1 = (DuplicateCodeBlockOccurrenceDiff)namedElement1;
                DuplicateCodeBlockOccurrenceDiff occ2 = (DuplicateCodeBlockOccurrenceDiff)namedElement2;
                result = Integer.compare(occ1.getTolerance(), occ2.getTolerance());
                if (result != 0) break;
                result = this.compareName((NamedElement)occ1, (NamedElement)occ1);
                break;
            }
            case RESOLUTION: {
                if (!(namedElement1 instanceof DuplicateCodeBlockIssueDiff) || !(namedElement2 instanceof DuplicateCodeBlockIssueDiff)) break;
                DuplicateCodeBlockIssueDiff duplicate1 = (DuplicateCodeBlockIssueDiff)namedElement1;
                DuplicateCodeBlockIssueDiff duplicate2 = (DuplicateCodeBlockIssueDiff)namedElement2;
                ResolutionKind resolutionKind1 = duplicate1.getCurrentResolutionKind();
                ResolutionKind resolutionKind2 = duplicate2.getCurrentResolutionKind();
                if (resolutionKind1 != null && resolutionKind2 != null) {
                    String resolution1 = resolutionKind1.getPresentationName();
                    String resolution2 = resolutionKind2.getPresentationName();
                    result = resolution1.compareTo(resolution2);
                    break;
                }
                if (resolutionKind1 == null && resolutionKind2 == null) {
                    result = this.compareName((NamedElement)duplicate1, (NamedElement)duplicate2);
                    break;
                }
                if (resolutionKind1 == null) {
                    result = -1;
                    break;
                }
                if (resolutionKind2 != null) break;
                result = 1;
                break;
            }
            default: {
                assert (false) : "Unandled sort: " + String.valueOf((Object)this.m_sort);
                break;
            }
        }
        return this.m_ascending ? result * -1 : result;
    }

    private int compareName(NamedElement element1, NamedElement element2) {
        assert (element1 != null) : "Parameter 'element1' of method 'compareResults' must not be null";
        assert (element2 != null) : "Parameter 'element2' of method 'compareResults' must not be null";
        return element1.getPresentationName(false).compareTo(element2.getPresentationName(false));
    }

    static enum Sort {
        NAME,
        OCCURRENCES,
        CHANGE,
        DETAILS,
        RANGE,
        BLOCK_LENGTH,
        TOLERANCE,
        RESOLUTION;

    }
}

