/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IDefinedInSystemDefinitionFile;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;

final class DiffViewUtility {
    private DiffViewUtility() {
    }

    public static NamedElement getLinkNamedElement(Element element) {
        Issue current;
        if (element instanceof IIssueDiff && (current = ((IIssueDiff)element).getCurrent()) != null) {
            return DiffViewUtility.getAffectedElement(current);
        }
        if (element instanceof IDiffElement && element.getElement() != null) {
            Element currentElement;
            IDiffElement diff = (IDiffElement)element;
            if (diff.getCurrentElement() != null && (currentElement = diff.getCurrentElement()) instanceof NamedElement) {
                return (NamedElement)currentElement;
            }
            return (NamedElement)element.getElement();
        }
        return null;
    }

    private static NamedElement getAffectedElement(Issue currentIssue) {
        Dependency dependency;
        assert (currentIssue != null) : "Parameter 'currentIssue' of method 'getAffectedElement' must not be null";
        NamedElement linkNamedElement = null;
        if (currentIssue instanceof NamedElementIssue) {
            linkNamedElement = (NamedElement)currentIssue.getAffectedElement();
        } else if (currentIssue instanceof DependencyIssue && (dependency = (Dependency)currentIssue.getAffectedElement()).getFrom() instanceof NamedElement) {
            linkNamedElement = (NamedElement)dependency.getFrom();
        }
        if (linkNamedElement != null) {
            FilePath definingFile;
            if (linkNamedElement instanceof IDefinedInSystemDefinitionFile && (definingFile = ((IDefinedInSystemDefinitionFile)linkNamedElement).getDefiningFile()) != null) {
                linkNamedElement = definingFile;
            }
            return linkNamedElement.getRepresentative();
        }
        return null;
    }
}

