/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CyclicElementDiff;
import com.hello2morrow.sonargraph.ui.standalone.diffview.IssueDiffResourceProvider;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;

final class CycleDiffColumLabelProvider
extends ColumnLabelProvider {
    private final int m_columnIndex;

    public CycleDiffColumLabelProvider(int columnIndex) {
        this.m_columnIndex = columnIndex;
    }

    public String getText(Object element) {
        assert (element != null && element instanceof IDiffElement) : "Unexpected class in method 'getText': " + String.valueOf(element);
        assert (element != null && element instanceof NamedElement) : "Unexpected class in method 'getText': " + String.valueOf(element);
        NamedElement namedElement = (NamedElement)element;
        IDiffElement deltaElement = (IDiffElement)element;
        switch (this.m_columnIndex) {
            case 0: {
                return namedElement.getPresentationName(true);
            }
            case 1: {
                if (element instanceof CycleGroupIssueDiff) {
                    return "" + ((CycleGroupIssueDiff)element).getNumberOfCyclicElements();
                }
                if (!(element instanceof CyclicElementDiff)) break;
                return null;
            }
            case 2: {
                if (element instanceof CycleGroupIssueDiff) {
                    return ((CycleGroupIssueDiff)element).getScope();
                }
                if (!(element instanceof CyclicElementDiff)) break;
                return null;
            }
            case 3: {
                return deltaElement.getChange().getPresentationName();
            }
            case 4: {
                return deltaElement.getChangeDescription();
            }
            case 5: {
                if (element instanceof CycleGroupIssueDiff) {
                    CycleGroupIssueDiff diff = (CycleGroupIssueDiff)element;
                    ResolutionKind resolutionKind = deltaElement.getCurrentElement() != null ? diff.getCurrentResolutionKind() : diff.getBaselineResolutionKind();
                    return resolutionKind != null ? resolutionKind.getPresentationName() : "None";
                }
                return null;
            }
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        assert (element != null && element instanceof IDiffElement) : "Unexpected class in method 'getText': " + String.valueOf(element);
        assert (element != null && element instanceof NamedElement) : "Unexpected class in method 'getText': " + String.valueOf(element);
        NamedElement namedElement = (NamedElement)element;
        switch (this.m_columnIndex) {
            case 0: {
                return UiResourceManager.getInstance().getImage(namedElement.getImageResourceName());
            }
            case 1: {
                break;
            }
            case 2: {
                if (!(element instanceof CycleGroupIssueDiff)) break;
                CycleGroupIssueDiff cycleDiff = (CycleGroupIssueDiff)element;
                return UiResourceManager.getInstance().getImage(cycleDiff.getScopeImageResourceName());
            }
            case 3: {
                if (!(element instanceof IDiffElement)) break;
                IDiffElement diff = (IDiffElement)element;
                return IssueDiffResourceProvider.getInstance().getChangeImage(diff.getChange());
            }
            case 4: {
                break;
            }
            case 5: {
                if (!(element instanceof CycleGroupIssueDiff)) break;
                CycleGroupIssueDiff diff = (CycleGroupIssueDiff)element;
                ResolutionKind resolutionKind = diff.getCurrent() != null ? diff.getCurrentResolutionKind() : diff.getBaselineResolutionKind();
                if (resolutionKind != null) {
                    return UiResourceManager.getInstance().getImage(resolutionKind.getStandardName());
                }
                return UiResourceManager.getInstance().getImage("None");
            }
        }
        return super.getImage(element);
    }
}

