/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

final class CycleDiffBasedViewerComparator
extends ViewerComparator {
    private Sort m_sort = Sort.SIZE;
    private boolean m_ascending = true;

    CycleDiffBasedViewerComparator() {
    }

    public void setSort(Sort sort) {
        assert (sort != null) : "Parameter 'sort' of method 'setSort' must not be null";
        if (this.m_sort.equals((Object)sort)) {
            this.m_ascending = !this.m_ascending;
        } else {
            this.m_sort = sort;
        }
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        assert (viewer != null) : "Parameter 'viewer' of method 'compare' must not be null";
        assert (o1 != null && o1 instanceof NamedElement) : "Unexpected class in method 'compare': " + String.valueOf(o1);
        assert (o2 != null && o2 instanceof NamedElement) : "Unexpected class in method 'compare': " + String.valueOf(o2);
        NamedElement namedElement1 = (NamedElement)o1;
        NamedElement namedElement2 = (NamedElement)o2;
        assert (namedElement1 != namedElement2) : "Same elements";
        int result = -1;
        switch (this.m_sort) {
            case NAME: {
                result = this.compareName(namedElement1, namedElement2);
                break;
            }
            case CHANGE: {
                if (!(namedElement1 instanceof CycleGroupIssueDiff) || !(namedElement2 instanceof CycleGroupIssueDiff)) break;
                CycleGroupIssueDiff group1 = (CycleGroupIssueDiff)namedElement1;
                CycleGroupIssueDiff group2 = (CycleGroupIssueDiff)namedElement2;
                result = Integer.compare(group1.getChange().ordinal(), group2.getChange().ordinal());
                if (result == 0) {
                    result = this.compareName((NamedElement)group1, (NamedElement)group2);
                }
                return result;
            }
            case SIZE: {
                if (!(namedElement1 instanceof CycleGroupIssueDiff) || !(namedElement2 instanceof CycleGroupIssueDiff)) break;
                CycleGroupIssueDiff group1 = (CycleGroupIssueDiff)namedElement1;
                CycleGroupIssueDiff group2 = (CycleGroupIssueDiff)namedElement2;
                result = Integer.compare(group1.getNumberOfCyclicElements(), group2.getNumberOfCyclicElements());
                if (result != 0) break;
                result = this.compareName((NamedElement)group1, (NamedElement)group2);
                break;
            }
            case SCOPE: {
                if (!(namedElement1 instanceof CycleGroupIssueDiff) || !(namedElement2 instanceof CycleGroupIssueDiff)) break;
                CycleGroupIssueDiff group1 = (CycleGroupIssueDiff)namedElement1;
                CycleGroupIssueDiff group2 = (CycleGroupIssueDiff)namedElement2;
                String scope1 = group1.getScope();
                String scope2 = group2.getScope();
                if (scope1 == null || scope2 == null) break;
                result = scope1.compareTo(scope2);
                break;
            }
            case RESOLUTION: {
                if (!(namedElement1 instanceof CycleGroupIssueDiff) || !(namedElement2 instanceof CycleGroupIssueDiff)) break;
                CycleGroupIssueDiff group1 = (CycleGroupIssueDiff)namedElement1;
                CycleGroupIssueDiff group2 = (CycleGroupIssueDiff)namedElement2;
                ResolutionKind resolutionKind1 = group1.getCurrentResolutionKind();
                ResolutionKind resolutionKind2 = group2.getCurrentResolutionKind();
                if (resolutionKind1 != null && resolutionKind2 != null) {
                    String resolution1 = resolutionKind1.getPresentationName();
                    String resolution2 = resolutionKind2.getPresentationName();
                    result = resolution1.compareTo(resolution2);
                    break;
                }
                if (resolutionKind1 == null && resolutionKind2 == null) {
                    result = this.compareName((NamedElement)group1, (NamedElement)group2);
                    break;
                }
                if (resolutionKind1 == null) {
                    result = -1;
                    break;
                }
                if (resolutionKind2 != null) break;
                result = 1;
                break;
            }
            default: {
                assert (false) : "Unandled sort: " + String.valueOf((Object)this.m_sort);
                break;
            }
        }
        return this.m_ascending ? result * -1 : result;
    }

    private int compareName(NamedElement element1, NamedElement element2) {
        assert (element1 != null) : "Parameter 'element1' of method 'compareResults' must not be null";
        assert (element2 != null) : "Parameter 'element2' of method 'compareResults' must not be null";
        return element1.getPresentationName(false).compareTo(element2.getPresentationName(false));
    }

    static enum Sort {
        NAME,
        CHANGE,
        SIZE,
        SCOPE,
        RESOLUTION;

    }
}

