/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.dependenciesview;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureBaseElement;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureAssignmentElement;
import com.hello2morrow.sonargraph.core.model.architecture.RecursiveElementComponentContainer;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.BalancedDependency;
import com.hello2morrow.sonargraph.core.model.workspace.ComponentContainer;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.ui.standalone.dependenciesview.DependencyColumnId;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;

abstract class DependenciesColumnLabelProvider
extends ColumnLabelProvider {
    private static final String PLACEHOLDER_OPEN = "<";
    private static final String PLACEHOLDER_CLOSE = ">";
    private final DependencyColumnId m_column;

    public DependenciesColumnLabelProvider(DependencyColumnId column) {
        this.m_column = column;
    }

    public final String getText(Object element) {
        assert (element instanceof BalancedDependency) : "Unexpected class: " + element.getClass().getName();
        BalancedDependency dependency = (BalancedDependency)element;
        String text = "";
        switch (this.m_column) {
            case TO: {
                text = this.getTextForTo(dependency);
                break;
            }
            case ICON: {
                break;
            }
            case DEPENDENCY_TYPE: {
                text = this.getDependencyTypeText(dependency);
                break;
            }
            case FROM: {
                text = this.getTextForFrom(dependency);
                break;
            }
            case FROM_SCOPE: 
            case TO_SCOPE: {
                text = this.getScopeText(dependency);
                break;
            }
            case NUMBER_OF_DEPENDENCIES: {
                text = this.getNumberOfDependenciesText(dependency);
                break;
            }
            default: {
                assert (false) : "Unexpected column in 'update'";
                break;
            }
        }
        return text;
    }

    public final Image getImage(Object element) {
        assert (element instanceof BalancedDependency) : "Unexpected class: " + element.getClass().getName();
        BalancedDependency dependency = (BalancedDependency)element;
        Image image = null;
        switch (this.m_column) {
            case TO: {
                image = this.getImageForTo(dependency);
                break;
            }
            case ICON: {
                image = this.getIconImage(dependency);
                break;
            }
            case DEPENDENCY_TYPE: {
                break;
            }
            case FROM: {
                image = this.getImageForFrom(dependency);
                break;
            }
            case FROM_SCOPE: 
            case TO_SCOPE: {
                image = this.getScopeImage(dependency);
                break;
            }
            case NUMBER_OF_DEPENDENCIES: {
                break;
            }
            default: {
                assert (false) : "Unexpected column in 'update'";
                break;
            }
        }
        return image;
    }

    protected String getScopeText(BalancedDependency dependency) {
        assert (false) : "Column 'Scope' not available for this table";
        assert (dependency != null) : "Parameter 'dependency' of method 'getScopeText' must not be null";
        return null;
    }

    protected Image getScopeImage(BalancedDependency dependency) {
        assert (false) : "Column 'Scope' not available for this table";
        assert (dependency != null) : "Parameter 'dependency' of method 'getScopeImage' must not be null";
        return null;
    }

    protected final DependencyColumnId getColumn() {
        return this.m_column;
    }

    protected final Image getImageForFrom(BalancedDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'getImageForFrom' must not be null";
        if (dependency.getBalanceMode() == BalancedDependency.BalanceMode.UNBALANCED_IN_FROM) {
            return UiResourceManager.getInstance().getImage("UpwardPlaceHolder");
        }
        return UiResourceManager.getInstance().getImage((Element)dependency.getFromEndPoint());
    }

    protected final Image getImageForTo(BalancedDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'getImageForTo' must not be null";
        if (dependency.getBalanceMode() == BalancedDependency.BalanceMode.UNBALANCED_IN_TO) {
            return UiResourceManager.getInstance().getImage("UpwardPlaceHolder");
        }
        return UiResourceManager.getInstance().getImage((Element)dependency.getToEndPoint());
    }

    public final String getTextForFrom(BalancedDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'getTextForFrom' must not be null";
        NamedElement from = dependency.getFromEndPoint();
        String text = this.getTextForNamedElement(from);
        if (dependency.usesFromPlaceHolder()) {
            return PLACEHOLDER_OPEN + text + PLACEHOLDER_CLOSE;
        }
        return text;
    }

    protected final String getTextForTo(BalancedDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'getTextForTo' must not be null";
        NamedElement to = dependency.getToEndPoint();
        String text = this.getTextForNamedElement(to);
        if (dependency.usesToPlaceHolder()) {
            return PLACEHOLDER_OPEN + text + PLACEHOLDER_CLOSE;
        }
        return text;
    }

    private final String getTextForNamedElement(NamedElement element) {
        Object text;
        assert (element != null) : "Parameter 'to' of method 'getTextForNamedElement' must not be null";
        if (element instanceof PhysicalRecursiveElement || element instanceof LogicalNamespace || element instanceof RecursiveElementComponentContainer || element instanceof Artifact) {
            text = element.getPresentationName(false);
            if (((String)text).startsWith("./")) {
                text = ((String)text).substring(2, ((String)text).length());
            }
        } else {
            text = element.getPresentationName(true);
            NamedElement parent = null;
            if (element instanceof ProgrammingElement && ((ProgrammingElement)element).isMember()) {
                parent = (NamedElement)element.getParent(ProgrammingElement.class, ParentMode.FIRST_PARENT);
            } else if (element instanceof LogicalProgrammingElement && ((LogicalProgrammingElement)element).getPrimaryProgrammingElement().isMember()) {
                parent = (NamedElement)element.getParent(LogicalProgrammingElement.class, ParentMode.FIRST_PARENT);
            }
            if (parent != null) {
                text = parent.getPresentationName(true) + "." + (String)text;
            }
        }
        return text;
    }

    protected final String getNumberOfDependenciesText(BalancedDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'getNumberOfDependenciesText' must not be null";
        return NumberUtility.format((Number)dependency.getNumberOfParserDependencies());
    }

    protected final String getDependencyTypeText(BalancedDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'getIconText' must not be null";
        return dependency.getDependencyInfo();
    }

    protected final NamedElement getContainer(NamedElement element) {
        assert (element != null) : "Parameter 'from' of method 'getContainer' must not be null";
        NamedElement container = null;
        container = element instanceof LogicalNamespaceRoot || element instanceof LogicalNamespace || element instanceof LogicalProgrammingElement ? (NamedElement)element.getParent(LogicalNamespaceRoot.class, ParentMode.SELF_OR_FIRST_PARENT) : (element instanceof ArchitectureBaseElement || element instanceof IArchitectureAssignmentElement ? (NamedElement)element.getParent(ArchitectureBaseElement.class, ParentMode.SELF_OR_FIRST_PARENT) : (NamedElement)element.getParent(ComponentContainer.class, ParentMode.SELF_OR_FIRST_PARENT));
        return container;
    }

    protected final Image getIconImage(BalancedDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'getIconImage' must not be null";
        return UiResourceManager.getInstance().getImage((Element)dependency, true);
    }
}

