/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler.remoting;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.remoting.DetermineNamedElementsToSelectCommand;
import com.hello2morrow.sonargraph.core.model.remoting.IRemoteSelectionProvider;
import com.hello2morrow.sonargraph.core.model.remoting.SelectionData;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public final class StandaloneRevealRemoteSelectionHandler
extends CommandHandlerWithCorrespondingCommand {
    @CanExecute
    public boolean canExecute() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        if (!provider.hasSoftwareSystem()) {
            return false;
        }
        if (provider.getSoftwareSystem().isClearable()) {
            return ((IRemoteSelectionProvider)provider.getInstallation().getExtension(IRemoteSelectionProvider.class)).hasRemoteSelection();
        }
        return false;
    }

    @Execute
    public void execute(final IEclipseContext eclipseContext, final EPartService partService) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'execute' must not be null";
        assert (partService != null) : "Parameter 'partService' of method 'execute' must not be null";
        DetermineNamedElementsToSelectCommand command = new DetermineNamedElementsToSelectCommand(WorkbenchRegistry.getInstance().getProvider(), new DetermineNamedElementsToSelectCommand.IInteraction(){

            public void handleSelection(OperationResultWithOutcome<StrictPair<List<SelectionData>, List<String>>> result) {
                if (result.isFailure()) {
                    UserInterfaceAdapter.getInstance().process(result);
                    return;
                }
                StrictPair elements = (StrictPair)result.getOutcome();
                if (!((List)elements.getSecond()).isEmpty()) {
                    UserInterfaceAdapter.getInstance().warning("Missing Elements", "Elements from remote selection request could not be found in Sonargraph system:\n" + ((List)elements.getSecond()).stream().collect(Collectors.joining(",\n")));
                }
                if (!((List)elements.getFirst()).isEmpty()) {
                    UserInterfaceAdapter.getInstance().displayUiElement(() -> {
                        List toSelect = ((List)elements.getFirst()).stream().map(e -> e.getElementToSelect()).collect(Collectors.toList());
                        ShowInViewSelectionAdapter.showInView((IEclipseContext)eclipseContext, (EPartService)partService, (IViewId)ViewId.NAVIGATION_VIEW, null, Collections.emptyList(), toSelect, (boolean)false);
                    });
                }
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)command);
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.DETERMINE_ELEMENTS_TO_SELECT;
    }
}

