/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler;

import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.WizardRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.inject.Named;
import java.util.Collections;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class RunWizardMenuItem {
    public static final String MENU_ITEM_SUFFIX = "...";

    private String getWizardName(MMenuItem menuItem) {
        assert (menuItem != null) : "Parameter 'menuItem' of method 'getWizardName' must not be null";
        String menuItemLabel = menuItem.getLabel();
        assert (menuItemLabel.endsWith(MENU_ITEM_SUFFIX)) : "Inccorect menu item label: " + menuItemLabel;
        return menuItemLabel.substring(0, menuItemLabel.length() - MENU_ITEM_SUFFIX.length());
    }

    @CanExecute
    public boolean canExecute(MMenuItem menuItem, @Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (menuItem != null) : "Parameter 'menuItem' of method 'canExecute' must not be null";
        String wizardName = this.getWizardName(menuItem);
        SonargraphWizardAdapter wizardAdapter = WizardRegistry.getInstance().getWizardAdapter(wizardName);
        return wizardAdapter.isAvailable() && wizardAdapter.isEnabled(WorkbenchRegistry.getInstance().getProvider(), selection != null ? selection.getElements() : Collections.emptyList());
    }

    @Execute
    public void execute(ECommandService commandService, EHandlerService handlerService, MMenuItem menuItem) {
        assert (commandService != null) : "Parameter 'commandService' of method 'execute' must not be null";
        assert (handlerService != null) : "Parameter 'handlerService' of method 'execute' must not be null";
        assert (menuItem != null) : "Parameter 'menuItem' of method 'execute' must not be null";
        String wizardName = this.getWizardName(menuItem);
        ParameterizedCommand command = commandService.createCommand("com.hello2morrow.sonargraph.standalone.command.runWizard", Collections.singletonMap("com.hello2morrow.sonargraph.standalone.command.runWizard.wizardId", wizardName));
        handlerService.executeHandler(command);
    }
}

