/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.RedoCommand;
import com.hello2morrow.sonargraph.core.command.system.RestoreCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.history.IUndoRedoEntry;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.IViewWithUndoRedo;
import com.hello2morrow.sonargraph.ui.standalone.commandhandler.RestoreHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;

public final class RedoHandler
extends RestoreHandler {
    private static final String MENU_ITEM = "com.hello2morrow.sonargraph.standalone.handledmenuitem.redo";
    private static final String TOOL_ITEM = "com.hello2morrow.sonargraph.standalone.handledtoolitem.redo";
    private static final String INITIAL_LABEL = "Redo";

    public final ICommandId getCorrespondingCommandId() {
        return CoreCommandId.REDO;
    }

    @Override
    protected String getMenuItem() {
        return MENU_ITEM;
    }

    @Override
    protected String getToolItem() {
        return TOOL_ITEM;
    }

    @Override
    protected String getInitialLabel() {
        return INITIAL_LABEL;
    }

    @Override
    protected IUndoRedoEntry getEntry(MPart part) {
        assert (part != null) : "Parameter 'part' of method 'getEntry' must not be null";
        IUndoRedoEntry entry = null;
        IViewWithUndoRedo viewWithUndoRedo = (IViewWithUndoRedo)RcpUtility.getWorkbenchView((MPart)part, IViewWithUndoRedo.class);
        if (viewWithUndoRedo != null) {
            entry = viewWithUndoRedo.isRedoPossible();
        }
        if (entry == null) {
            entry = RedoCommand.getNextEntryForRedo((ISoftwareSystemProvider)WorkbenchRegistry.getInstance().getProvider());
        }
        return entry;
    }

    @Override
    protected void performExecute(MPart part) {
        IViewWithUndoRedo viewWithUndoRedo = (IViewWithUndoRedo)RcpUtility.getWorkbenchView((MPart)part, IViewWithUndoRedo.class);
        if (viewWithUndoRedo != null && viewWithUndoRedo.isRedoPossible() != null) {
            viewWithUndoRedo.redo();
            return;
        }
        IUndoRedoEntry entry = RedoCommand.getNextEntryForRedo((ISoftwareSystemProvider)WorkbenchRegistry.getInstance().getProvider());
        if (entry != null) {
            UserInterfaceAdapter.getInstance().run((Command)new RedoCommand(WorkbenchRegistry.getInstance().getProvider(), (RestoreCommand.IRestoreInteraction)new RestoreHandler.Interaction()));
            return;
        }
        assert (false) : "Redo not possible";
    }
}

