/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler;

import com.hello2morrow.sonargraph.ui.standalone.commandhandler.RunWizardMenuItem;
import com.hello2morrow.sonargraph.ui.swt.base.ISonargraphUIContribution;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.WizardRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NewWizardsSubMenu
implements ISonargraphUIContribution {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewWizardsSubMenu.class);
    private static final String MENU_ROOT = "com.hello2morrow.sonargraph.standalone.menu.newWizards";

    public static void removeEntries(IEclipseContext eclipseContext, MWindow mainApplicationWindow) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'removeEntries' must not be null";
        MMenu found = (MMenu)RcpUtility.findUniqueModelElement((IEclipseContext)eclipseContext, (MUIElement)mainApplicationWindow.getMainMenu(), (String)MENU_ROOT, MMenu.class);
        if (found != null) {
            ArrayList<MMenuElement> toBeRemoved = new ArrayList<MMenuElement>();
            for (MMenuElement next : found.getChildren()) {
                if (next instanceof MDynamicMenuContribution) continue;
                toBeRemoved.add(next);
            }
            found.getChildren().removeAll(toBeRemoved);
        }
    }

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items) {
        assert (items != null) : "Parameter 'items' of method 'aboutToShow' must not be null";
        List wizardAdapters = WizardRegistry.getInstance().getWizardAdapters();
        LOGGER.debug("NewWizardsSubMenu gets {} wizards from registry", (Object)wizardAdapters.size());
        SonargraphWizardAdapter.Category currentCategory = null;
        String currentBundleId = null;
        MMenu currentSubMenu = null;
        for (SonargraphWizardAdapter nextWizardAdapter : wizardAdapters) {
            LOGGER.debug("Check wizard {}...", (Object)nextWizardAdapter.getName());
            if (nextWizardAdapter.isAvailable()) {
                LOGGER.debug("...available");
                if (currentCategory == null || nextWizardAdapter.getCategory() != currentCategory) {
                    currentSubMenu = MMenuFactory.INSTANCE.createMenu();
                    currentCategory = nextWizardAdapter.getCategory();
                    currentSubMenu.setLabel(currentCategory.getPresentationName());
                    LOGGER.debug("Added new category {}", (Object)currentCategory.getPresentationName());
                    currentSubMenu.setIconURI("platform:/plugin/com.hello2morrow.sonargraph.standalone/images/" + currentCategory.getImageResource() + ".gif");
                    items.add((MMenuElement)currentSubMenu);
                    currentBundleId = null;
                }
                assert (currentSubMenu != null) : "Parameter 'currentSubMenu' of method 'aboutToShow' must not be null";
                if (currentBundleId != null && !nextWizardAdapter.getBundleId().equals(currentBundleId)) {
                    currentSubMenu.getChildren().add(MMenuFactory.INSTANCE.createMenuSeparator());
                    LOGGER.debug("Added separator");
                }
                currentBundleId = nextWizardAdapter.getBundleId();
                MDirectMenuItem nextItem = MMenuFactory.INSTANCE.createDirectMenuItem();
                nextItem.setLabel(nextWizardAdapter.getName() + "...");
                LOGGER.debug("Added new menu item {}", (Object)nextWizardAdapter.getName());
                nextItem.setContributorURI("platform:/plugin/com.hello2morrow.sonargraph.standalone");
                nextItem.setContributionURI("bundleclass://com.hello2morrow.sonargraph.standalone/" + RunWizardMenuItem.class.getName());
                nextItem.setIconURI("platform:/plugin/" + nextWizardAdapter.getBundleId() + "/images/" + nextWizardAdapter.getImageResource() + ".gif");
                currentSubMenu.getChildren().add(nextItem);
                continue;
            }
            LOGGER.debug("...not available");
        }
    }
}

