/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecture.ExportArchitectureToXmlFileCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.SelectionBasedCommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.swt.widgets.FileDialog;

public final class ExportArchitectureToXmlHandler
extends SelectionBasedCommandHandler {
    private ArchitectureFile m_architectureFile;

    public IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> currentSelection) {
                if (currentSelection.size() != 1) {
                    return false;
                }
                Element selected = currentSelection.get(0);
                if (selected instanceof ArchitectureFile) {
                    ArchitectureFile architectureFile = (ArchitectureFile)selected;
                    return architectureFile.isChecked();
                }
                return false;
            }
        };
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.EXPORT_ARCHITECTURE_FILE_TO_XML;
    }

    private ArchitectureFile extractSelection(WorkbenchViewSelection selection) {
        if (selection == null) {
            return null;
        }
        List selectedElements = selection.getElements();
        if (selectedElements.size() != 1) {
            return null;
        }
        Element selectedElement = (Element)selectedElements.get(0);
        if (selectedElement instanceof ArchitectureFile) {
            ArchitectureFile architectureFile = (ArchitectureFile)selectedElement;
            return architectureFile;
        }
        return null;
    }

    protected boolean internalCanExecute(IEclipseContext eclipseContext, MMenuItem menuItem, WorkbenchViewSelection selection) {
        ArchitectureFile architectureFile = this.extractSelection(selection);
        return architectureFile != null && architectureFile.isChecked();
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        this.m_architectureFile = this.extractSelection(selection);
        if (this.m_architectureFile == null) {
            return;
        }
        ExportArchitectureToXmlFileCommand cmd = new ExportArchitectureToXmlFileCommand(WorkbenchRegistry.getInstance().getProvider(), (ExportArchitectureToXmlFileCommand.IExportArchitectureToXmlFileInteraction)new ExportArchitectureInteraction());
        UserInterfaceAdapter.getInstance().run((Command)cmd);
    }

    private final class ExportArchitectureInteraction
    implements ExportArchitectureToXmlFileCommand.IExportArchitectureToXmlFileInteraction {
        private ExportArchitectureInteraction() {
        }

        public boolean collect(final ExportArchitectureToXmlFileCommand.ExportArchitectureToXmlFileData data) {
            assert (ExportArchitectureToXmlHandler.this.m_architectureFile != null);
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            data.setArchitectureFile(ExportArchitectureToXmlHandler.this.m_architectureFile);
            final String proposedName = FileUtility.removeExtension((String)ExportArchitectureToXmlHandler.this.m_architectureFile.getShortName());
            ExportArchitectureToXmlHandler.this.m_architectureFile = null;
            RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

                public void run() {
                    FileDialog saveDialog = new FileDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), 8192);
                    saveDialog.setFilterNames(new String[]{"XML (*.xml)"});
                    saveDialog.setFilterExtensions(new String[]{"*.xml"});
                    saveDialog.setFileName(proposedName);
                    saveDialog.setFilterPath(WorkbenchRegistry.getInstance().getProvider().getLocation("ExportArchitecture"));
                    String filePathName = saveDialog.open();
                    if (filePathName == null || filePathName.trim().length() == 0) {
                        this.setResult(false);
                        return;
                    }
                    if (!filePathName.endsWith(".xml")) {
                        filePathName = filePathName.concat(".xml");
                    }
                    data.setFilePath(filePathName);
                    this.setResult(true);
                    WorkbenchRegistry.getInstance().getProvider().setLocation("ExportArchitecture", saveDialog.getFilterPath());
                }
            };
            return (Boolean)UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)runnable);
        }

        public boolean confirmOverwrite(String fileName) {
            return UserInterfaceAdapter.getInstance().question("Do you want to overwrite '" + fileName + "'!", false) == UserInterfaceAdapter.Feedback.CONFIRMED;
        }

        public void processExportArchitectureResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

