/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.EditModuleCommand;
import com.hello2morrow.sonargraph.core.command.system.SimpleSoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IFixedNameElement;
import com.hello2morrow.sonargraph.core.model.element.INamedElementNode;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionDialog;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.List;

public abstract class EditModuleCommandAdapter<T extends Module>
extends CompositeCommandAdapter {
    private final Class<T> m_class;

    protected EditModuleCommandAdapter(Class<T> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'EditModuleCommandAdapter' must not be null";
        this.m_class = clazz;
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.EDIT_MODULE;
    }

    public final CompositeCommandAdapter.Type getType() {
        return CompositeCommandAdapter.Type.EDIT;
    }

    public final CompositeCommandAdapter.Applicable applicable(ISoftwareSystemProvider provider, List<Element> elements) {
        T module;
        assert (provider != null) : "Parameter 'provider' of method 'applicable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'applicable' must not be null";
        if (elements.size() == 1 && (module = this.getModuleFromSelection(elements, false)) != null && (this.supportsFixedNameModule() || !(module instanceof IFixedNameElement))) {
            return new CompositeCommandAdapter.Applicable(module.getPresentationKind());
        }
        return null;
    }

    protected T getModuleFromSelection(List<Element> elements, boolean mustBePresent) {
        assert (elements != null) : "Parameter 'elements' of method 'getModuleFromSelection' must not be null";
        Element element = (Element)CommandHandler.getSingleSelection(Element.class, elements, (boolean)mustBePresent);
        if (element != null) {
            NamedElement namedElement;
            if (this.m_class.isAssignableFrom(element.getClass())) {
                return (T)((Module)element);
            }
            if (element instanceof INamedElementNode && this.m_class.isAssignableFrom((namedElement = ((INamedElementNode)element).getNamedElement()).getClass())) {
                return (T)((Module)namedElement);
            }
        }
        return null;
    }

    protected boolean supportsFixedNameModule() {
        return false;
    }

    public void apply(ISoftwareSystemProvider provider, List<Element> elements) {
        NameAndDescriptionDialog dialog;
        assert (WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) : "No system available";
        T module = this.getModuleFromSelection(elements, true);
        if (module != null && (dialog = new NameAndDescriptionDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "Edit " + module.getPresentationKind(), ((IWorkspaceProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IWorkspaceProvider.class)).getModuleNameValidator(), module.getName(), module.getDescription(), !(module instanceof IFixedNameElement))).open() == 0) {
            EditModuleCommand cmd = new EditModuleCommand(provider, new SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction(){

                public void process(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'process' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                }

                public INavigationState getNavigationState() {
                    return ViewNavigationManager.getInstance().getCurrentNavigationState();
                }
            }, module, dialog.getName(), dialog.getDescription());
            UserInterfaceAdapter.getInstance().run((Command)cmd);
        }
    }
}

