/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.workbench;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ElementSelectionWidget
extends Composite
implements ISelectionChangedListener {
    private final TreeViewer m_treeviewer;
    private final List<IListener> m_listeners = new ArrayList<IListener>();
    private final ElementContentAndLabelProvider m_labelAndContentProvider;

    public ElementSelectionWidget(Composite parent, int style) {
        super(parent, style);
        this.m_treeviewer = new TreeViewer((Composite)this, style);
        this.m_labelAndContentProvider = new ElementContentAndLabelProvider();
        this.m_treeviewer.setLabelProvider((IBaseLabelProvider)this.m_labelAndContentProvider);
        this.m_treeviewer.setContentProvider((IContentProvider)this.m_labelAndContentProvider);
    }

    public TreeViewer getTreeViewer() {
        return this.m_treeviewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        NamedElement element = (NamedElement)selection.getFirstElement();
        for (IListener listener : this.m_listeners) {
            listener.elementSelected(element);
        }
    }

    public void setInput(Map<NamedElement, String> moduleLabels) {
        this.m_treeviewer.setInput(moduleLabels);
        if (!moduleLabels.isEmpty() && this.m_treeviewer.getSelection().isEmpty()) {
            this.m_treeviewer.setSelection((ISelection)new StructuredSelection((Object)moduleLabels.keySet().iterator().next()));
        }
    }

    public void dispose() {
        this.disableListeners();
        this.m_listeners.clear();
        super.dispose();
    }

    public void addSelectionListener(IListener listener) {
        assert (listener != null) : "Parameter 'listenr' of method 'setSelectionListener' must not be null";
        assert (!this.m_listeners.contains(listener)) : "Listener has already been added!";
        this.m_listeners.add(listener);
    }

    public void disableListeners() {
        this.m_treeviewer.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void enableListeners() {
        this.m_treeviewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void removeSelectionListener(IListener listener) {
        this.m_listeners.remove(listener);
    }

    private class ElementContentAndLabelProvider
    extends LabelProvider
    implements ITreeContentProvider {
        private Map<NamedElement, String> m_elementToLabelMapping;

        private ElementContentAndLabelProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput == null || !(newInput instanceof Map)) {
                return;
            }
            this.m_elementToLabelMapping = (Map)newInput;
        }

        public Image getImage(Object obj) {
            assert (obj instanceof NamedElement) : "Not of class named element: " + String.valueOf(obj);
            NamedElement element = (NamedElement)obj;
            return UiResourceManager.getInstance().getImage((Element)element);
        }

        public Object[] getChildren(Object obj) {
            return this.getElements(obj);
        }

        public String getText(Object element) {
            assert (element != null) : "Parameter 'element' of method 'getText' must not be null";
            return this.m_elementToLabelMapping.get(element);
        }

        public Object[] getElements(Object obj) {
            if (obj == null || !(obj instanceof Map)) {
                return null;
            }
            return this.m_elementToLabelMapping.keySet().toArray();
        }

        public Object getParent(Object obj) {
            return null;
        }

        public boolean hasChildren(Object obj) {
            Object[] elements = this.getElements(obj);
            return elements == null ? false : elements.length > 0;
        }
    }

    public static interface IListener {
        public void elementSelected(NamedElement var1);
    }
}

