/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ProxyDialog;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.widgets.Shell;

public final class StandaloneProxySettingsProvider
implements IProxySettingsProvider {
    public static final String PROXY_SETTINGS = "com.hello2morrow.sonargraph.standalone.proxySettings";
    public static final String HOST = "HOST";
    public static final String PORT = "PORT";
    public static final String USER_NAME = "USERNAME";
    public static final String PASSWORD = "PASSWORD";

    public ProxySettings getProxySettings(boolean loadNullOrEmptyValues) {
        ProxySettings proxySettings = null;
        IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences((String)PROXY_SETTINGS);
        String host = eclipsePreferences.get(HOST, null);
        if (loadNullOrEmptyValues || host != null && !host.isEmpty()) {
            proxySettings = ProxySettings.create((String)host, (String)eclipsePreferences.get(PORT, null), (String)eclipsePreferences.get(USER_NAME, null), (String)eclipsePreferences.get(PASSWORD, null));
        }
        return proxySettings;
    }

    public void store(String host, int port, String username, String password) {
        assert (host != null) : "Parameter 'host' of method 'store' must not be null";
        assert (username != null) : "Parameter 'username' of method 'store' must not be null";
        assert (password != null) : "Parameter 'password' of method 'store' must not be null";
        IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences((String)PROXY_SETTINGS);
        eclipsePreferences.put(HOST, host);
        eclipsePreferences.put(PORT, Integer.toString(port));
        eclipsePreferences.put(USER_NAME, username);
        eclipsePreferences.put(PASSWORD, password);
        PreferencesUtility.save((IEclipsePreferences)eclipsePreferences);
    }

    public int configureProxySettings(Shell shell) {
        ProxyDialog proxyDialog = new ProxyDialog(shell, this);
        return proxyDialog.open();
    }
}

