/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.model.path.QualityModelFileDescriptor;
import com.hello2morrow.sonargraph.core.model.path.ResolvedQualityModelDescriptorFile;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QualityModelLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(QualityModelLoader.class);

    private QualityModelLoader() {
    }

    public static final List<ResolvedQualityModelDescriptorFile> loadQualityModelFiles(List<QualityModelFileDescriptor> qualityModelFileDescriptors) {
        assert (qualityModelFileDescriptors != null && !qualityModelFileDescriptors.isEmpty()) : "Parameter 'qualityModelFileDescriptors' of method 'loadQualityModelFiles' must not be empty";
        ArrayList<ResolvedQualityModelDescriptorFile> resolvedDescriptors = new ArrayList<ResolvedQualityModelDescriptorFile>(qualityModelFileDescriptors.size());
        for (QualityModelFileDescriptor nextQMFileDescriptor : qualityModelFileDescriptors) {
            Bundle bundle = Platform.getBundle((String)nextQMFileDescriptor.getBundleId());
            if (bundle == null) continue;
            try {
                URL configURL = bundle.getResource(nextQMFileDescriptor.getFileName());
                if (configURL == null) continue;
                TFile resourceFile = new TFile(FileLocator.toFileURL((URL)configURL).getPath());
                if (!resourceFile.exists()) {
                    throw new IOException("QualityModel file '" + nextQMFileDescriptor.getFileName() + "' does not exist");
                }
                resolvedDescriptors.add(new ResolvedQualityModelDescriptorFile(nextQMFileDescriptor, resourceFile));
            }
            catch (IOException ex) {
                LOGGER.error("Cannot get quality model file", (Throwable)ex);
            }
        }
        return resolvedDescriptors;
    }
}

