/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ModifiableFileColumnLabelProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public final class PreRefreshActionsDialog
extends StandardDialog {
    private static final String TITLE = "Confirm pre-refresh actions";
    private static final int MAX_DEFAULT_HEIGHT = 400;
    private final PrepareRefreshResult m_prepareRefreshResult;

    public PreRefreshActionsDialog(Shell parentShell, String title, PrepareRefreshResult prepareRefreshResult) {
        super(parentShell, title != null && !title.isEmpty() ? title : TITLE);
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'PreRefreshActionsDialog' must not be empty";
        assert (parentShell != null) : "Parameter 'parentShell' of method 'NameAndDescriptionDialog' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'PreRefreshActionsDialog' must not be null";
        assert (prepareRefreshResult.confirmationRequired()) : "Confirmation must be required";
        this.m_prepareRefreshResult = prepareRefreshResult;
    }

    public PreRefreshActionsDialog(Shell parentShell, PrepareRefreshResult prepareRefreshResult) {
        this(parentShell, TITLE, prepareRefreshResult);
    }

    public final boolean hasValidData() {
        return true;
    }

    protected final int getNumberOfColumns() {
        return 1;
    }

    protected Point getPreferredSize() {
        int dynamicSize = 180 + this.m_prepareRefreshResult.getSystemFilesDelta().getNumberOfModifiedFiles() * 20;
        return new Point(500, dynamicSize > 400 ? 400 : dynamicSize);
    }

    protected void applyData() {
        super.applyData();
        this.getButton(0).setEnabled(true);
    }

    private void createConflictSystemFileTable(Composite parent, String operation, List<IModifiableFile> systemFiles) {
        assert (parent != null) : "Parameter 'parent' of method 'createSystemFileTable' must not be null";
        assert (systemFiles != null && !systemFiles.isEmpty()) : "Parameter 'systemFiles' of method 'createSystemFileTable' must not be empty";
        assert (operation != null && operation.length() > 0) : "Parameter 'operation' of method 'createConflictSystemFileTable' must not be empty";
        final TableViewer tableViewer = new TableViewer(parent, 66306);
        tableViewer.getTable().setToolTipText("Modified system files have also been " + operation + " on disk. Check to keep modified content.");
        tableViewer.getTable().setHeaderVisible(true);
        TableViewerColumn fileColumn = new TableViewerColumn(tableViewer, 0);
        fileColumn.getColumn().setText("Conflict file (also " + operation + " on disk)");
        fileColumn.setLabelProvider((CellLabelProvider)new ModifiableFileColumnLabelProvider());
        TableViewerColumn checkColumn = new TableViewerColumn(tableViewer, 0);
        checkColumn.getColumn().setResizable(false);
        checkColumn.getColumn().setText("Keep");
        checkColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                if (!$assertionsDisabled && cell == null) {
                    throw new AssertionError((Object)"Parameter 'cell' of method 'update' must not be null");
                }
                if (!($assertionsDisabled || cell.getElement() != null && cell.getElement() instanceof IModifiableFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'update': " + String.valueOf(cell.getElement())));
                }
                IModifiableFile modifiableFile = (IModifiableFile)cell.getElement();
                if (PreRefreshActionsDialog.this.m_prepareRefreshResult.getSystemFilesDelta().keepConflictContent(modifiableFile)) {
                    cell.setImage(UiResourceManager.getInstance().getImage("CheckBoxChecked"));
                } else {
                    cell.setImage(UiResourceManager.getInstance().getImage("CheckBoxUnchecked"));
                }
            }

            public String getToolTipText(Object element) {
                return "Check to keep modified content.";
            }
        });
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput(systemFiles);
        fileColumn.getColumn().pack();
        checkColumn.getColumn().pack();
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'selectionChanged' must not be null");
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    Object firstElement = selection.getFirstElement();
                    if (!($assertionsDisabled || firstElement != null && firstElement instanceof IModifiableFile)) {
                        throw new AssertionError((Object)("Unexpected class in method 'selectionChanged': " + String.valueOf(firstElement)));
                    }
                    IModifiableFile modifiableFile = (IModifiableFile)firstElement;
                    boolean currentKeep = PreRefreshActionsDialog.this.m_prepareRefreshResult.getSystemFilesDelta().keepConflictContent(modifiableFile);
                    PreRefreshActionsDialog.this.m_prepareRefreshResult.getSystemFilesDelta().setKeepConflictContent(modifiableFile, !currentKeep);
                }
                tableViewer.getTable().setRedraw(false);
                tableViewer.refresh();
                PreRefreshActionsDialog.this.applyData();
                tableViewer.getTable().setRedraw(true);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
        SwtUtility.packAllColumnsAndRightAlignLast((TableViewer)tableViewer);
    }

    private void createSystemFileTable(Composite parent, String title, List<IModifiableFile> systemFiles) {
        assert (parent != null) : "Parameter 'parent' of method 'createSystemFileTable' must not be null";
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'createSystemFileTable' must not be empty";
        assert (systemFiles != null && !systemFiles.isEmpty()) : "Parameter 'systemFiles' of method 'createSystemFileTable' must not be empty";
        TableViewer tableViewer = new TableViewer(parent, 770);
        tableViewer.getTable().setHeaderVisible(true);
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setText(title);
        column.setLabelProvider((CellLabelProvider)new ModifiableFileColumnLabelProvider());
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput(systemFiles);
        column.getColumn().pack();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
    }

    private void createElementTable(Composite parent, String title, List<Element> elements) {
        assert (parent != null) : "Parameter 'parent' of method 'createSystemFileTable' must not be null";
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'createSystemFileTable' must not be empty";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'createElementTable' must not be empty";
        TableViewer tableViewer = new TableViewer(parent, 770);
        tableViewer.getTable().setHeaderVisible(true);
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setText(title);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                if (!$assertionsDisabled && object == null) {
                    throw new AssertionError((Object)"Parameter 'object' of method 'getText' must not be null");
                }
                if (!$assertionsDisabled && !(object instanceof Element)) {
                    throw new AssertionError((Object)("Unexpected class: " + String.valueOf(object)));
                }
                Element element = (Element)object;
                return element.getName();
            }

            public Image getImage(Object object) {
                if (!$assertionsDisabled && object == null) {
                    throw new AssertionError((Object)"Parameter 'object' of method 'getImage' must not be null");
                }
                if (!$assertionsDisabled && !(object instanceof Element)) {
                    throw new AssertionError((Object)("Unexpected class: " + String.valueOf(object)));
                }
                Element element = (Element)object;
                return UiResourceManager.getInstance().getImage(element);
            }
        });
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput(elements);
        column.getColumn().pack();
    }

    private void createInfoTable(Composite parent, List<String> messages) {
        assert (parent != null) : "Parameter 'parent' of method 'createSystemFileTable' must not be null";
        assert (messages != null && !messages.isEmpty()) : "Parameter 'messages' of method 'createMessageTable' must not be empty";
        TableViewer tableViewer = new TableViewer(parent, 770);
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                if (!$assertionsDisabled && object == null) {
                    throw new AssertionError((Object)"Parameter 'object' of method 'getText' must not be null");
                }
                if (!$assertionsDisabled && !(object instanceof String)) {
                    throw new AssertionError((Object)("Unexpected class: " + String.valueOf(object)));
                }
                return object.toString();
            }

            public Image getImage(Object object) {
                if (!$assertionsDisabled && object == null) {
                    throw new AssertionError((Object)"Parameter 'object' of method 'getImage' must not be null");
                }
                if (!$assertionsDisabled && !(object instanceof String)) {
                    throw new AssertionError((Object)("Unexpected class: " + String.valueOf(object)));
                }
                return UiResourceManager.getInstance().getImage("Info");
            }
        });
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput(messages);
        column.getColumn().pack();
    }

    protected final void fillDialogArea(Composite composite) {
        List info;
        List aboutToBeDeletedElements;
        List addedSystemFiles;
        List modifiedSystemFiles;
        List deletedSystemFiles;
        List conflictWithDeletedSystemFiles;
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        SashForm sashForm = new SashForm(composite, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        List conflictWithModifiedSystemFiles = this.m_prepareRefreshResult.getSystemFilesDelta().getConflictsWithModified();
        if (!conflictWithModifiedSystemFiles.isEmpty()) {
            this.createConflictSystemFileTable((Composite)sashForm, "modified", conflictWithModifiedSystemFiles);
        }
        if (!(conflictWithDeletedSystemFiles = this.m_prepareRefreshResult.getSystemFilesDelta().getConflictsWithDeleted()).isEmpty()) {
            this.createConflictSystemFileTable((Composite)sashForm, "deleted", conflictWithDeletedSystemFiles);
        }
        if (!(deletedSystemFiles = this.m_prepareRefreshResult.getSystemFilesDelta().getDeleted()).isEmpty()) {
            this.createSystemFileTable((Composite)sashForm, "Deleted file", deletedSystemFiles);
        }
        if (!(modifiedSystemFiles = this.m_prepareRefreshResult.getSystemFilesDelta().getModified()).isEmpty()) {
            this.createSystemFileTable((Composite)sashForm, "Modified file", modifiedSystemFiles);
        }
        if (!(addedSystemFiles = this.m_prepareRefreshResult.getSystemFilesDelta().getAdded()).isEmpty()) {
            this.createSystemFileTable((Composite)sashForm, "Added file", addedSystemFiles);
        }
        if (!(aboutToBeDeletedElements = this.m_prepareRefreshResult.getAboutToBeDeletedElements()).isEmpty()) {
            this.createElementTable((Composite)sashForm, "About to be deleted element", aboutToBeDeletedElements);
        }
        if (!(info = this.m_prepareRefreshResult.getInfo()).isEmpty()) {
            this.createInfoTable((Composite)sashForm, info);
        }
    }
}

