/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class PathDialog
extends StandardDialog
implements ValidatingPathWidget.IConsumer {
    private final TFile m_basePath;
    private final String m_label;
    private final IPathValidator m_fileValidator;
    private final TFile m_currentInput;
    private TFile m_directory;

    public PathDialog(Shell parentShell, String title, TFile basePath, String label, IPathValidator fileValidator) {
        this(parentShell, title, basePath, label, fileValidator, null);
    }

    public PathDialog(Shell parentShell, String title, TFile basePath, String label, IPathValidator pathValidator, TFile currentInput) {
        super(parentShell, title);
        assert (label != null && label.length() > 0) : "Parameter 'label' of method 'PathDialog' must not be empty";
        assert (pathValidator != null) : "Parameter 'PathValidator' of method 'PathDialog' must not be null";
        this.m_basePath = basePath;
        this.m_label = label;
        this.m_fileValidator = pathValidator;
        this.m_currentInput = currentInput;
    }

    protected Point getPreferredSize() {
        return new Point(500, 150);
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        Label label = new Label(composite, 0);
        label.setText(this.m_label + ":");
        ValidatingPathWidget validatingPathWidget = new ValidatingPathWidget(composite, (ValidatingPathWidget.IConsumer)this, this.m_fileValidator, 2, this.m_currentInput, true, this.m_basePath);
        validatingPathWidget.setLayoutData((Object)new GridData(768));
        validatingPathWidget.getBrowseButton().setFocus();
    }

    public boolean hasValidData() {
        return this.m_directory != null;
    }

    public TFile getDirectory() {
        assert (this.hasValidData()) : "Data not valid";
        return this.m_directory;
    }

    public void setPath(TFile file, boolean inputModified) {
        this.m_directory = file;
        this.getButton(0).setEnabled(this.m_directory != null);
    }
}

