/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.command.system.AbstractSolutionFileImportCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.system.settings.IVisualStudioProjectReferenceInfo;
import com.hello2morrow.sonargraph.core.model.system.settings.SolutionFileInfo;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ProjectInfoAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.SystemDirectoryWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ValidationControlDecorator;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.VisualStudioProjectReferenceImportModel;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class NewModulesFromVSSolutionFileWizardLoadModulesPage
extends StandardWizardPage
implements ValidatingPathWidget.IConsumer,
AbstractSolutionFileImportCommand.IInteraction {
    private final IPathValidator m_solutionFileValidator;
    private PropertyTableViewer<VisualStudioProjectReferenceImportModel> m_tableProjects;
    private ValidationControlDecorator m_projectReferencesDecorator;
    private ValidationControlDecorator m_configurationDecorator;
    private Combo m_comboConfigurations;
    private String m_selectedConfigurationName;
    private TFile m_softwareSystemBaseDirectory;
    private TFile m_currentSolutionFile;
    private boolean m_referencedProjectsExist = false;
    private Combo m_comboPlatform;
    private String m_selectedPlatformName;
    private final IFileType m_solutionFileType;
    private ValidatingPathWidget m_pathWidget;
    private OperationResult m_solutionImportResult;
    private SolutionFileInfo m_solutionFileInfo;
    private final List<VisualStudioProjectReferenceImportModel> m_referencesToImport = new ArrayList<VisualStudioProjectReferenceImportModel>();
    private Button m_selectAll;
    private Button m_deselectAll;

    protected NewModulesFromVSSolutionFileWizardLoadModulesPage(String pageName, String title, IPathValidator solutionFileValidator, IFileType solutionFileType) {
        super(pageName, title);
        assert (solutionFileValidator != null) : "Parameter 'solutionFileValidator' of method 'CSharpVsSolutionFileDialog' must not be null";
        assert (solutionFileType != null) : "Parameter 'solutionFileType' of method 'NewModulesFromVSSolutionFileWizardLoadModulesPage' must not be null";
        this.m_solutionFileValidator = solutionFileValidator;
        this.m_solutionFileType = solutionFileType;
        this.setPageComplete(false);
    }

    public void createContent(Composite composite) {
        if (this.getPreviousPage() != null && this.getPreviousPage() instanceof SystemDirectoryWizardPage) {
            this.m_softwareSystemBaseDirectory = ((SystemDirectoryWizardPage)this.getPreviousPage()).getDirectory();
        }
        Label intro = new Label(composite, 64);
        intro.setText("Please make sure that you have built the solution successfully on your machine before creating the Sonargraph system.");
        intro.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        Label labelSolutionFile = new Label(composite, 0);
        List<String> fileExtensionsList = Arrays.asList(this.m_solutionFileType.getExtensions());
        labelSolutionFile.setText("Solution File (" + fileExtensionsList.stream().collect(Collectors.joining(", ")) + "):");
        this.m_pathWidget = new ValidatingPathWidget(composite, (ValidatingPathWidget.IConsumer)this, this.m_solutionFileValidator, 2, null, true, this.m_softwareSystemBaseDirectory);
        String fileFilter = fileExtensionsList.stream().map(e -> "*" + e).collect(Collectors.joining(";"));
        this.m_pathWidget.setFilterExtensions(new String[]{fileFilter});
        this.m_pathWidget.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Label labelProjects = new Label(composite, 0);
        labelProjects.setText("Projects:");
        labelProjects.setLayoutData((Object)new GridData(1, 128, false, false));
        this.m_tableProjects = new PropertyTableViewer(composite, (BeanPropertyReader.BeanAdapter)new ProjectInfoAdapter(this.m_softwareSystemBaseDirectory), "name", true, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.m_tableProjects.addColumn("Import", "selected", null, "selectedImage", 80, PropertyTableViewer.ColumnType.IMAGE);
        this.m_tableProjects.addColumn("Name", "name", "name", "image", 150, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableProjects.addColumn("File", "path", "name", null, 300, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableProjects.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.addListenerToTable(this.m_tableProjects.getTable());
        this.m_projectReferencesDecorator = new ValidationControlDecorator((Control)this.m_tableProjects.getTable());
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false, 3, 1));
        buttonComposite.setLayout((Layout)new FillLayout());
        this.m_selectAll = new Button(buttonComposite, 8);
        this.m_selectAll.setText("Select All");
        this.m_selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (VisualStudioProjectReferenceImportModel ref : NewModulesFromVSSolutionFileWizardLoadModulesPage.this.m_tableProjects.getVisibleItems()) {
                    ref.setSelected(true);
                }
                NewModulesFromVSSolutionFileWizardLoadModulesPage.this.m_tableProjects.showData(NewModulesFromVSSolutionFileWizardLoadModulesPage.this.m_referencesToImport);
                NewModulesFromVSSolutionFileWizardLoadModulesPage.this.updatePageCompleteStatus();
            }
        });
        this.m_deselectAll = new Button(buttonComposite, 8);
        this.m_deselectAll.setText("Deselect All");
        this.m_deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (VisualStudioProjectReferenceImportModel ref : NewModulesFromVSSolutionFileWizardLoadModulesPage.this.m_tableProjects.getVisibleItems()) {
                    ref.setSelected(false);
                }
                NewModulesFromVSSolutionFileWizardLoadModulesPage.this.m_tableProjects.showData(NewModulesFromVSSolutionFileWizardLoadModulesPage.this.m_referencesToImport);
                NewModulesFromVSSolutionFileWizardLoadModulesPage.this.updatePageCompleteStatus();
            }
        });
        Label configuration = new Label(composite, 0);
        configuration.setText("Configuration:");
        this.m_comboConfigurations = new Combo(composite, 12);
        this.m_comboConfigurations.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_comboConfigurations.setEnabled(false);
        this.m_comboConfigurations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewModulesFromVSSolutionFileWizardLoadModulesPage.this.setSelectedConfiguration(NewModulesFromVSSolutionFileWizardLoadModulesPage.this.m_comboConfigurations.getText());
            }
        });
        this.m_configurationDecorator = new ValidationControlDecorator((Control)this.m_comboConfigurations);
        this.m_comboPlatform = new Combo(composite, 12);
        this.m_comboPlatform.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_comboPlatform.setEnabled(false);
        this.m_comboPlatform.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewModulesFromVSSolutionFileWizardLoadModulesPage.this.m_selectedPlatformName = NewModulesFromVSSolutionFileWizardLoadModulesPage.this.m_comboPlatform.getText();
            }
        });
        SwtUtility.createFillerForGridLayoutCell((Composite)composite, (int)3, (int)1);
        SwtUtility.createFillerForGridLayoutCell((Composite)composite);
        this.enableTableButtons(false);
    }

    private void addListenerToTable(final Table table) {
        assert (table != null) : "Parameter 'table' of method 'addListenerToTable' must not be null";
        table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent event) {
                int key = event.keyCode;
                if (key == 32) {
                    NewModulesFromVSSolutionFileWizardLoadModulesPage.this.updateTableRow(table, (EventObject)event);
                    NewModulesFromVSSolutionFileWizardLoadModulesPage.this.m_tableProjects.showData(NewModulesFromVSSolutionFileWizardLoadModulesPage.this.m_referencesToImport);
                    NewModulesFromVSSolutionFileWizardLoadModulesPage.this.updatePageCompleteStatus();
                }
            }
        });
        table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent event) {
                NewModulesFromVSSolutionFileWizardLoadModulesPage.this.updateTableRow(table, (EventObject)event);
                NewModulesFromVSSolutionFileWizardLoadModulesPage.this.m_tableProjects.showData(NewModulesFromVSSolutionFileWizardLoadModulesPage.this.m_referencesToImport);
                NewModulesFromVSSolutionFileWizardLoadModulesPage.this.updatePageCompleteStatus();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private void updateTableRow(Table table, EventObject event) {
        assert (table != null) : "Parameter 'table' of method 'updateTableRow' must not be null";
        assert (event != null) : "Parameter 'event' of method 'updateTableRow' must not be null";
        Object source = event.getSource();
        assert (source != null && source instanceof Table) : "Unexpected class in method 'mouseDown': " + String.valueOf(source);
        StructuredSelection selection = new StructuredSelection((Object[])table.getSelection());
        if (!selection.isEmpty()) {
            VisualStudioProjectReferenceImportModel reference;
            Object firstElement = selection.getFirstElement();
            assert (firstElement instanceof TableItem) : "Unexpected class in method 'selectionChanged': " + String.valueOf(firstElement.getClass());
            TableItem item = (TableItem)firstElement;
            assert (item.getData() != null && item.getData() instanceof VisualStudioProjectReferenceImportModel) : "Unexpected class in method 'mouseDown': " + String.valueOf(item.getData());
            reference.setSelected(!(reference = (VisualStudioProjectReferenceImportModel)item.getData()).isSelected());
        }
    }

    public void setSoftwareSystemBaseDirectory(TFile baseDirectory) {
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'setSoftwareSystemBaseDirectory' must not be null";
        this.m_softwareSystemBaseDirectory = baseDirectory;
        if (this.m_pathWidget != null) {
            this.m_pathWidget.setBasePath(this.m_softwareSystemBaseDirectory);
        }
    }

    public TFile getSystemBaseDirectory() {
        return this.m_softwareSystemBaseDirectory;
    }

    public void setPath(TFile input, boolean inputModified) {
        if (input == null || !inputModified) {
            return;
        }
        this.m_comboConfigurations.removeAll();
        this.m_comboPlatform.removeAll();
        this.m_selectedConfigurationName = null;
        assert (this.m_softwareSystemBaseDirectory != null) : "'m_softwareSystemBaseDirectory' of method 'setPath' must not be null";
        this.m_currentSolutionFile = input;
        this.importSolutionFile(this);
        this.m_referencesToImport.clear();
        ValidationResult validationResult = new ValidationResult(true);
        if (this.m_solutionImportResult.isFailure()) {
            UserInterfaceAdapter.getInstance().process(this.m_solutionImportResult);
            for (String error : this.m_solutionImportResult.getErrorMessages()) {
                validationResult.addError(error);
            }
        }
        for (String warning : this.m_solutionImportResult.getWarningMessages()) {
            validationResult.addWarning(warning);
        }
        if (this.m_solutionFileInfo != null && this.m_solutionFileInfo.getOmittedReferences().size() > 0) {
            UserInterfaceAdapter.getInstance().process(this.m_solutionImportResult);
        }
        this.m_projectReferencesDecorator.updateDecoration(validationResult);
        if (this.m_solutionImportResult.isFailure()) {
            this.m_tableProjects.showData(this.m_referencesToImport);
            this.m_referencedProjectsExist = false;
            this.enableTableButtons(false);
            this.setPageComplete(false);
            return;
        }
        if (this.m_solutionFileInfo.getProjectReferences().isEmpty()) {
            validationResult.addWarning("No referenced projects found.");
            this.m_referencedProjectsExist = false;
            this.enableTableButtons(false);
        } else {
            this.m_referencedProjectsExist = true;
        }
        this.m_projectReferencesDecorator.updateDecoration(validationResult);
        this.m_referencesToImport.addAll(this.convertProjectReferences(this.m_solutionFileInfo));
        this.m_tableProjects.showData(this.m_referencesToImport);
        ValidationResult configurationResult = new ValidationResult(true);
        if (this.m_solutionFileInfo.getConfigurations().isEmpty()) {
            configurationResult.addError("No configurations found in solution file");
            this.m_comboConfigurations.setEnabled(false);
        } else {
            ArrayList sortedConfigurations = new ArrayList(this.m_solutionFileInfo.getConfigurationPlatformMapping().keySet());
            Collections.sort(sortedConfigurations);
            for (String configName : sortedConfigurations) {
                this.m_comboConfigurations.add(configName);
            }
            this.m_comboConfigurations.setEnabled(true);
            this.m_comboConfigurations.select(0);
            this.setSelectedConfiguration(this.m_comboConfigurations.getItem(0));
        }
        this.m_configurationDecorator.updateDecoration(configurationResult);
        this.enableTableButtons(true);
        this.updatePageCompleteStatus();
    }

    private void updatePageCompleteStatus() {
        this.setPageComplete(this.m_referencedProjectsExist && !this.getReferencesToImport().isEmpty() && this.m_selectedConfigurationName != null);
    }

    private void enableTableButtons(boolean isEnabled) {
        this.m_selectAll.setEnabled(isEnabled);
        this.m_deselectAll.setEnabled(isEnabled);
    }

    protected abstract void importSolutionFile(AbstractSolutionFileImportCommand.IInteraction var1);

    public boolean collectSolutionFile(AbstractSolutionFileImportCommand.SolutionImportData data) {
        data.setSolutionFile(this.m_currentSolutionFile);
        return true;
    }

    public SolutionFileInfo getSolutionFileInfo() {
        return this.m_solutionFileInfo;
    }

    public void processResult(OperationResultWithOutcome<SolutionFileInfo> result) {
        assert (result != null) : "Parameter 'result' of method 'processResult' must not be null";
        this.m_solutionImportResult = result;
        this.m_solutionFileInfo = (SolutionFileInfo)result.getOutcome();
    }

    public INavigationState getNavigationState() {
        return null;
    }

    public String getConfigurationName() {
        return this.m_selectedConfigurationName;
    }

    public String getPlatformName() {
        return this.m_selectedPlatformName;
    }

    private List<VisualStudioProjectReferenceImportModel> convertProjectReferences(SolutionFileInfo solutionInfo) {
        return solutionInfo.getProjectReferences().stream().map(ref -> new VisualStudioProjectReferenceImportModel((IVisualStudioProjectReferenceInfo)ref)).collect(Collectors.toList());
    }

    private void setSelectedConfiguration(String configurationName) {
        this.m_selectedConfigurationName = configurationName;
        this.m_comboPlatform.removeAll();
        List platforms = (List)this.m_solutionFileInfo.getConfigurationPlatformMapping().get(this.m_selectedConfigurationName);
        if (platforms == null || platforms.isEmpty()) {
            this.m_comboPlatform.setEnabled(false);
            return;
        }
        for (String platform : platforms) {
            this.m_comboPlatform.add(platform);
        }
        this.m_comboPlatform.setEnabled(true);
        this.m_comboPlatform.select(0);
        this.m_selectedPlatformName = this.m_comboPlatform.getItem(0);
    }

    protected int getNumberOfColumns() {
        return 3;
    }

    public final List<IVisualStudioProjectReferenceInfo> getReferencesToImport() {
        return this.m_referencesToImport.stream().filter(ref -> ref.isSelected()).map(ref -> ref.getProject()).collect(Collectors.toList());
    }
}

